/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.rhq.core.domain.measurement.MeasurementBaseline;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.resource.Resource;

@Entity
@NamedQueries(value={@NamedQuery(name="MeasurementSchedule.FIND_ALL_FOR_DEFINITIONS", query="SELECT ms   FROM MeasurementSchedule ms  WHERE ms.definition IN (:definitions) "), @NamedQuery(name="MeasurementSchedule.findByIds", query="SELECT ms   FROM MeasurementSchedule ms  WHERE ms.id IN ( :ids )"), @NamedQuery(name="MeasurementSchedule.FIND_ENABLED_BY_ResourcesS_AND_RESOURCE_TYPE", query="SELECT ms.id, res.id, def.id   FROM MeasurementSchedule ms   JOIN ms.definition def   JOIN ms.resource res  WHERE def.resourceType = :resourceType    AND ms.definition = def    AND res IN (:resources)    AND ms.enabled = true   AND (def.dataType = :dataType OR :dataType is null )"), @NamedQuery(name="MeasurementSchedule.FIND_ENABLED_BY_ResourceIds_AND_RESOURCE_TYPE", query="SELECT ms.id, res.id, def.id   FROM MeasurementSchedule ms   JOIN ms.definition def   JOIN ms.resource res  WHERE def.resourceType.id = :resourceTypeId    AND ms.definition = def    AND res.id IN (:resourceIds)    AND ms.enabled = true"), @NamedQuery(name="MeasurementSchedule.findSchedulesWithBaselinesToCalculate", query="SELECT ms FROM MeasurementSchedule ms  WHERE ms.enabled = true    AND ms.definition.numericType = :measType    AND ms.baseline.computeTime < :ctime    AND ms.baseline.userEntered = false"), @NamedQuery(name="MeasurementSchedule.FIND_ALL_FOR_RESOURCE_ID", query="    SELECT ms       FROM MeasurementSchedule ms JOIN FETCH ms.definition      WHERE ms.resource.id = :resourceId        AND (ms.definition.dataType = :dataType OR :dataType is null)        AND (ms.definition.displayType = :displayType OR :displayType is null)        AND (ms.enabled = :enabled OR :enabled is null) "), @NamedQuery(name="MeasurementSchedule.findByResourceIdsAndDefinitionIds", query="SELECT ms   FROM MeasurementSchedule ms  WHERE ms.definition.id IN (:definitionIds)    AND ms.resource.id IN (:resourceIds)"), @NamedQuery(name="MeasurementDefinition.findScheduleCompositeForResource", query="SELECT new org.rhq.core.domain.measurement.composite.MeasurementScheduleComposite     ( ms.definition,        ms.enabled,        ms.interval )   FROM MeasurementSchedule ms  WHERE ms.resource.id = :resourceId    AND (ms.definition.dataType = :dataType OR :dataType is null) "), @NamedQuery(name="MeasurementSchedule.getScheduledMeasurementsPerMinute", query="SELECT SUM(1000.0 / ms.interval) * 60.0   FROM MeasurementSchedule ms  WHERE ms.enabled = true    AND ms.resource.inventoryStatus = :status"), @NamedQuery(name="MeasurementSchedule.disableAll", query="UPDATE MeasurementSchedule ms    SET ms.enabled = false"), @NamedQuery(name="MeasurementSchedule.deleteByResources", query="DELETE MeasurementSchedule ms  WHERE ms.resource.id IN ( :resourceIds )")})
@SequenceGenerator(name="RHQ_METRIC_SCHED_ID_SEQ", sequenceName="RHQ_MEASUREMENT_SCHED_ID_SEQ")
@Table(name="RHQ_MEASUREMENT_SCHED", uniqueConstraints={@UniqueConstraint(columnNames={"DEFINITION", "RESOURCE_ID"})})
public class MeasurementSchedule
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long MINIMUM_INTERVAL = 30000L;
    public static final String FIND_SCHEDULES_WITH_BASLINES_TO_CALC = "MeasurementSchedule.findSchedulesWithBaselinesToCalculate";
    public static final String FIND_ALL_FOR_RESOURCE_ID = "MeasurementSchedule.FIND_ALL_FOR_RESOURCE_ID";
    public static final String FIND_BY_RESOURCE_IDS_AND_DEFINITION_IDS = "MeasurementSchedule.findByResourceIdsAndDefinitionIds";
    public static final String FIND_SCHEDULE_COMPOSITE_FOR_RESOURCE = "MeasurementDefinition.findScheduleCompositeForResource";
    public static final String GET_SCHEDULED_MEASUREMENTS_PER_MINUTED = "MeasurementSchedule.getScheduledMeasurementsPerMinute";
    public static final String DISABLE_ALL = "MeasurementSchedule.disableAll";
    public static final String FIND_ENABLED_BY_RESOURCES_AND_RESOURCE_TYPE = "MeasurementSchedule.FIND_ENABLED_BY_ResourcesS_AND_RESOURCE_TYPE";
    public static final String FIND_ENABLED_BY_RESOURCE_IDS_AND_RESOURCE_TYPE_ID = "MeasurementSchedule.FIND_ENABLED_BY_ResourceIds_AND_RESOURCE_TYPE";
    public static final String DELETE_BY_RESOURCES = "MeasurementSchedule.deleteByResources";
    public static final String FIND_ALL_FOR_DEFINITIONS = "MeasurementSchedule.FIND_ALL_FOR_DEFINITIONS";
    public static final String FIND_BY_IDS = "MeasurementSchedule.findByIds";
    public static final String NATIVE_QUERY_REPORTING_RESOURCE_MEASUREMENT_SCHEDULE_REQUEST = "SELECT ms.RESOURCE_ID, ms.ID, def.NAME, ms.COLL_INTERVAL, ms.ENABLED, def.DATA_TYPE, def.RAW_NUMERIC_TYPE   FROM RHQ_MEASUREMENT_SCHED ms   JOIN RHQ_MEASUREMENT_DEF def ON ms.DEFINITION = def.ID  WHERE ms.RESOURCE_ID IN ( @@RESOURCES@@ )";
    public static final String NATIVE_QUERY_INSERT_SCHEDULES_POSTGRES = "INSERT INTO RHQ_MEASUREMENT_SCHED ( ID, ENABLED, COLL_INTERVAL, DEFINITION, RESOURCE_ID )      SELECT nextval('RHQ_MEASUREMENT_SCHED_ID_SEQ'),             def.DEFAULT_ON AS defaultOn,             def.DEFAULT_INTERVAL AS interval,             def.ID AS definitionId,             res.ID AS resourceId        FROM RHQ_RESOURCE res, RHQ_RESOURCE_TYPE type, RHQ_MEASUREMENT_DEF def       WHERE ( res.ID in ( @@RESOURCES@@ ) )         AND type.ID = res.RESOURCE_TYPE_ID         AND type.ID = def.RESOURCE_TYPE_ID         AND NOT EXISTS ( SELECT ms.id                            FROM RHQ_MEASUREMENT_SCHED ms                           WHERE ms.RESOURCE_ID = res.ID                             AND ms.DEFINITION = def.ID ) ";
    public static final String NATIVE_QUERY_INSERT_SCHEDULES_ORACLE = "INSERT INTO RHQ_MEASUREMENT_SCHED ( ID, ENABLED, COLL_INTERVAL, DEFINITION, RESOURCE_ID )      SELECT RHQ_MEASUREMENT_SCHED_ID_SEQ.nextval,             defaultOn, interval, definitionId, resourceId        FROM ( SELECT def.DEFAULT_ON AS defaultOn,                      def.DEFAULT_INTERVAL AS interval,                      def.ID AS definitionId,                      res.ID AS resourceId                 FROM RHQ_RESOURCE res, RHQ_RESOURCE_TYPE type, RHQ_MEASUREMENT_DEF def                WHERE ( res.ID in ( @@RESOURCES@@ ) )                  AND type.ID = res.RESOURCE_TYPE_ID                  AND type.ID = def.RESOURCE_TYPE_ID                  AND NOT EXISTS ( SELECT ms.id                                     FROM RHQ_MEASUREMENT_SCHED ms                                    WHERE ms.RESOURCE_ID = res.ID                                      AND ms.DEFINITION = def.ID ) ) ";
    public static final String NATIVE_QUERY_INSERT_SCHEDULES_SQL_SERVER = "INSERT INTO RHQ_MEASUREMENT_SCHED ( ENABLED, COLL_INTERVAL, DEFINITION, RESOURCE_ID )      SELECT def.DEFAULT_ON AS defaultOn,             def.DEFAULT_INTERVAL AS interval,             def.ID AS definitionId,             res.ID AS resourceId        FROM RHQ_RESOURCE res, RHQ_RESOURCE_TYPE type, RHQ_MEASUREMENT_DEF def       WHERE ( res.ID in ( @@RESOURCES@@ ) )         AND type.ID = res.RESOURCE_TYPE_ID         AND type.ID = def.RESOURCE_TYPE_ID         AND NOT EXISTS ( SELECT ms.id                            FROM RHQ_MEASUREMENT_SCHED ms                           WHERE ms.RESOURCE_ID = res.ID                             AND ms.DEFINITION = def.ID ) ";
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RHQ_METRIC_SCHED_ID_SEQ")
    @Id
    private int id;
    @OneToOne(mappedBy="schedule", cascade={CascadeType.MERGE}, fetch=FetchType.LAZY)
    private MeasurementBaseline baseline;
    @JoinColumn(name="DEFINITION")
    @ManyToOne(fetch=FetchType.EAGER)
    private MeasurementDefinition definition;
    @JoinColumn(name="RESOURCE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Resource resource;
    @Column(name="COLL_INTERVAL")
    private long interval;
    @Column(name="MTIME")
    private Long mtime;
    @Column(name="ENABLED")
    private boolean enabled;

    public MeasurementSchedule() {
    }

    public long getInterval() {
        return this.interval < 30000L ? 30000L : this.interval;
    }

    public MeasurementSchedule(MeasurementDefinition definition, Resource resource) {
        this.definition = definition;
        this.enabled = true;
        this.resource = resource;
    }

    public String toString() {
        return "[MeasurementSchedule, id=" + this.id + "]";
    }

    public MeasurementBaseline getBaseline() {
        return this.baseline;
    }

    public void setBaseline(MeasurementBaseline baseline) {
        this.baseline = baseline;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Long getMtime() {
        return this.mtime;
    }

    @PrePersist
    @PreUpdate
    private void setMtime() {
        this.mtime = System.currentTimeMillis();
    }

    public MeasurementDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(MeasurementDefinition myDefinition) {
        this.definition = myDefinition;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.definition == null ? 0 : this.definition.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeasurementSchedule)) {
            return false;
        }
        MeasurementSchedule other = (MeasurementSchedule)obj;
        if (this.definition == null ? other.definition != null : !this.definition.equals(other.definition)) {
            return false;
        }
        return !(this.resource == null ? other.resource != null : !this.resource.equals(other.resource));
    }
}

