/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ScopeInfo;
import org.jboss.logging.Logger;
import org.jboss.metadata.plugins.context.AbstractMetaDataContext;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.context.MetaDataContext;
import org.jboss.metadata.spi.loader.MutableMetaDataLoader;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractScopeInfo
implements ScopeInfo {
    private static final Logger log = Logger.getLogger(AbstractScopeInfo.class);
    private ScopeKey scopeKey;
    private ScopeKey mutableScopeKey;
    private ScopeKey installScope;
    private MutableMetaDataRepository repository;
    private CopyOnWriteArraySet<ScopeKey> addedScopes = new CopyOnWriteArraySet();

    public AbstractScopeInfo(Object name) {
        this(name, null);
    }

    public AbstractScopeInfo(Object name, String className) {
        if (name == null) {
            throw new IllegalArgumentException("Null scope");
        }
        ScopeKey scopeKey = ScopeKey.DEFAULT_SCOPE.clone();
        scopeKey.addScope(CommonLevels.INSTANCE, (Object)name.toString());
        if (className != null) {
            scopeKey.addScope(CommonLevels.CLASS, (Object)className);
        }
        this.setScope(scopeKey);
        this.setMutableScope(new ScopeKey(CommonLevels.INSTANCE, (Object)name.toString()));
    }

    public AbstractScopeInfo(ScopeKey key, ScopeKey mutable) {
        this.setScope(key);
        this.setMutableScope(mutable);
    }

    @Override
    public MetaData getMetaData() {
        if (this.repository == null) {
            return null;
        }
        return this.repository.getMetaData(this.getScope());
    }

    @Override
    public void addMetaData(MutableMetaDataRepository repository, ControllerContext context) {
        MutableMetaDataLoader mutable;
        this.repository = repository;
        ScopeKey scope = this.getMutableScope();
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(scope);
        if (retrieval == null) {
            mutable = this.initMutableMetaDataRetrieval(repository, context, scope);
            repository.addMetaDataRetrieval((MetaDataRetrieval)mutable);
            this.addedScopes.add(scope);
        } else {
            mutable = this.getMutableMetaDataLoader(retrieval);
        }
        if (mutable == null) {
            log.warn((Object)("MetaData context is not mutable: " + retrieval + " for " + context.toShortString()));
            return;
        }
        this.updateMetaData(repository, context, mutable, true);
    }

    protected void updateMetaData(MutableMetaDataRepository repository, ControllerContext context, MutableMetaDataLoader mutable, boolean add) {
    }

    @Override
    public void removeMetaData(MutableMetaDataRepository repository, ControllerContext context) {
        MutableMetaDataLoader mutable;
        ScopeKey mutableScope = this.getMutableScope();
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(mutableScope);
        if (retrieval != null && (mutable = this.getMutableMetaDataLoader(retrieval)) != null) {
            this.updateMetaData(repository, context, mutable, false);
        }
        for (ScopeKey scope : this.addedScopes) {
            try {
                repository.removeMetaDataRetrieval(scope);
            }
            catch (Exception e) {
                log.trace((Object)"Ignored", (Throwable)e);
            }
        }
        this.addedScopes.clear();
        this.repository = null;
    }

    protected MutableMetaDataLoader getMutableMetaDataLoader(MetaDataRetrieval retrieval) {
        MetaDataContext metaDataContext;
        List locals;
        if (retrieval == null) {
            return null;
        }
        if (retrieval instanceof MutableMetaDataLoader) {
            return (MutableMetaDataLoader)retrieval;
        }
        if (retrieval instanceof MetaDataContext && (locals = (metaDataContext = (MetaDataContext)retrieval).getLocalRetrievals()) != null) {
            for (MetaDataRetrieval local : locals) {
                if (!(local instanceof MutableMetaDataLoader)) continue;
                return (MutableMetaDataLoader)local;
            }
        }
        return null;
    }

    @Override
    public MetaDataRetrieval initMetaDataRetrieval(MutableMetaDataRepository repository, ControllerContext context, Scope scope) {
        return null;
    }

    @Override
    public MetaDataRetrieval initMetaDataRetrieval(MutableMetaDataRepository repository, ControllerContext context) {
        ScopeKey scopeKey = this.getScope();
        ArrayList<MetaDataRetrieval> retrievals = new ArrayList<MetaDataRetrieval>();
        for (Scope scope : scopeKey.getScopes()) {
            ScopeKey thisScope = new ScopeKey(scope);
            MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(thisScope);
            if (retrieval == null && (retrieval = this.initMetaDataRetrieval(repository, context, scope)) == null) {
                retrieval = this.initMutableMetaDataRetrieval(repository, context, thisScope);
                repository.addMetaDataRetrieval(retrieval);
                this.addedScopes.add(thisScope);
            }
            retrievals.add(0, retrieval);
        }
        MetaDataRetrieval metaDataRetrieval = this.createMetaDataRetrieval(context, retrievals);
        repository.addMetaDataRetrieval(metaDataRetrieval);
        this.addedScopes.add(metaDataRetrieval.getScope());
        return metaDataRetrieval;
    }

    @Override
    public MutableMetaDataLoader initMutableMetaDataRetrieval(MutableMetaDataRepository repository, ControllerContext context, ScopeKey scopeKey) {
        return new MemoryMetaDataLoader(scopeKey);
    }

    @Override
    public ScopeKey getScope() {
        return this.scopeKey;
    }

    @Override
    public void setScope(ScopeKey key) {
        if (key == null) {
            throw new IllegalArgumentException("Null scope key");
        }
        this.scopeKey = key;
    }

    @Override
    public ScopeKey getMutableScope() {
        return this.mutableScopeKey;
    }

    @Override
    public void setMutableScope(ScopeKey key) {
        if (key == null) {
            throw new IllegalArgumentException("Null scope key");
        }
        this.mutableScopeKey = key;
    }

    @Override
    public ScopeKey getInstallScope() {
        return this.installScope;
    }

    @Override
    public void setInstallScope(ScopeKey key) {
        this.installScope = key;
    }

    protected MetaDataRetrieval createMetaDataRetrieval(ControllerContext context, List<MetaDataRetrieval> retrievals) {
        return new AbstractMetaDataContext(null, retrievals);
    }
}

