/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonBinding;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.EndpointInvocation;
import org.jboss.ws.core.HeaderSource;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.jaxrpc.ParameterWrapping;
import org.jboss.ws.core.jaxws.handler.MessageContextJAXWS;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.MessageFactoryImpl;
import org.jboss.ws.core.soap.NameImpl;
import org.jboss.ws.core.soap.SOAPBodyElementDoc;
import org.jboss.ws.core.soap.SOAPBodyElementRpc;
import org.jboss.ws.core.soap.SOAPBodyImpl;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.SOAPFactoryImpl;
import org.jboss.ws.core.soap.SOAPFaultImpl;
import org.jboss.ws.core.soap.SOAPHeaderElementImpl;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.core.soap.Style;
import org.jboss.ws.core.soap.UnboundHeader;
import org.jboss.ws.core.soap.Use;
import org.jboss.ws.core.soap.attachment.AttachmentPartImpl;
import org.jboss.ws.core.soap.attachment.CIDGenerator;
import org.jboss.ws.core.utils.MimeUtils;
import org.jboss.ws.extensions.wsrm.common.RMHelper;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.TypesMetaData;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.common.JavaUtils;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonSOAPBinding
implements CommonBinding {
    protected Logger log = Logger.getLogger(this.getClass());
    private boolean mtomEnabled;
    protected HeaderSource headerSource;
    public static final String SOAP11HTTP_BINDING = "http://schemas.xmlsoap.org/wsdl/soap/http";
    public static final String SOAP12HTTP_BINDING = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    public static final String SOAP11HTTP_MTOM_BINDING = "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true";
    public static final String SOAP12HTTP_MTOM_BINDING = "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true";
    private static final Name SOAP_ARRAY_NAME = new NameImpl("Array", "soap11-enc", "http://schemas.xmlsoap.org/soap/encoding/");

    public MessageFactory getMessageFactory() {
        return new MessageFactoryImpl();
    }

    public SOAPFactory getSOAPFactory() {
        return new SOAPFactoryImpl();
    }

    public boolean isMTOMEnabled() {
        return this.mtomEnabled;
    }

    public void setMTOMEnabled(boolean flag) {
        this.mtomEnabled = flag;
    }

    protected abstract MessageAbstraction createMessage(OperationMetaData var1) throws SOAPException;

    @Override
    public MessageAbstraction bindRequestMessage(OperationMetaData opMetaData, EndpointInvocation epInv, Map<QName, UnboundHeader> unboundHeaders) throws BindingException {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug((Object)("bindRequestMessage: " + opMetaData.getQName()));
        }
        try {
            Object value;
            QName xmlName;
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext == null) {
                throw new WSException("MessageContext not available");
            }
            if (opMetaData.isRPCEncoded()) {
                XOPContext.setMTOMEnabled(false);
            } else {
                XOPContext.setMTOMEnabled(this.isMTOMEnabled());
            }
            SOAPMessageImpl reqMessage = (SOAPMessageImpl)this.createMessage(opMetaData);
            msgContext.setSOAPMessage(reqMessage);
            SOAPEnvelope soapEnvelope = reqMessage.getSOAPPart().getEnvelope();
            SOAPBody soapBody = soapEnvelope.getBody();
            SOAPHeader soapHeader = soapEnvelope.getHeader();
            NamespaceRegistry namespaceRegistry = msgContext.getNamespaceRegistry();
            Style style = opMetaData.getStyle();
            Object soapBodyElement = soapBody;
            if (style == Style.RPC) {
                boolean serialize = true;
                if (opMetaData.getEndpointMetaData().getConfig().getRMMetaData() != null && RMHelper.isRMOperation(opMetaData.getQName())) {
                    serialize = false;
                }
                if (serialize) {
                    QName opQName = opMetaData.getQName();
                    NameImpl opName = new NameImpl(namespaceRegistry.registerQName(opQName));
                    if (debugEnabled) {
                        this.log.debug((Object)("Create RPC body element: " + opName));
                    }
                    soapBodyElement = new SOAPBodyElementRpc(opName);
                    soapBodyElement = (SOAPBodyElement)soapBody.addChildElement((SOAPElement)soapBodyElement);
                    if (opMetaData.getUse() == Use.ENCODED) {
                        String envURI = soapEnvelope.getNamespaceURI();
                        String envPrefix = soapEnvelope.getPrefix();
                        soapBodyElement.setAttributeNS(envURI, envPrefix + ":encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
                    }
                }
            }
            for (ParameterMetaData paramMetaData : opMetaData.getInputParameters()) {
                xmlName = paramMetaData.getXmlName();
                value = epInv.getRequestParamValue(xmlName);
                if (paramMetaData.isSwA()) {
                    CIDGenerator cidGenerator = reqMessage.getCidGenerator();
                    AttachmentPart part = this.createAttachmentPart(paramMetaData, value, cidGenerator);
                    reqMessage.addAttachmentPart(part);
                    if (!(value instanceof DataHandler) || !(msgContext instanceof MessageContextJAXWS)) continue;
                    DataHandler dataHandler = (DataHandler)value;
                    Map attachments = (Map)msgContext.get("javax.xml.ws.binding.attachments.outbound");
                    attachments.put(dataHandler.getContentType(), dataHandler);
                    continue;
                }
                SOAPHeader soapElement = paramMetaData.isInHeader() ? soapHeader : soapBodyElement;
                this.addParameterToMessage(paramMetaData, value, (SOAPElement)soapElement);
            }
            if (unboundHeaders != null) {
                for (UnboundHeader unboundHeader : unboundHeaders.values()) {
                    if (unboundHeader.getMode() == ParameterMode.OUT) continue;
                    xmlName = unboundHeader.getXmlName();
                    value = unboundHeader.getHeaderValue();
                    xmlName = namespaceRegistry.registerQName(xmlName);
                    NameImpl soapName = new NameImpl(xmlName.getLocalPart(), xmlName.getPrefix(), xmlName.getNamespaceURI());
                    if (debugEnabled) {
                        this.log.debug((Object)("Add unboundHeader element: " + soapName));
                    }
                    SOAPHeaderElementImpl contentElement = new SOAPHeaderElementImpl(soapName);
                    contentElement.setParamMetaData(unboundHeader.toParameterMetaData(opMetaData));
                    if (soapHeader == null) {
                        soapHeader = soapEnvelope.addHeader();
                    }
                    soapHeader.addChildElement((SOAPElement)contentElement);
                    contentElement.setObjectValue(value);
                }
            }
            this.setSOAPActionHeader(opMetaData, reqMessage);
            return reqMessage;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public abstract void setSOAPActionHeader(OperationMetaData var1, SOAPMessage var2);

    @Override
    public EndpointInvocation unbindRequestMessage(OperationMetaData opMetaData, MessageAbstraction payload) throws BindingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("unbindRequestMessage: " + opMetaData.getQName()));
        }
        try {
            SOAPMessageImpl reqMessage = (SOAPMessageImpl)payload;
            SOAPEnvelope soapEnvelope = reqMessage.getSOAPPart().getEnvelope();
            SOAPHeader soapHeader = soapEnvelope.getHeader();
            SOAPBody soapBody = soapEnvelope.getBody();
            this.verifySOAPVersion(opMetaData, soapEnvelope);
            EndpointInvocation epInv = new EndpointInvocation(opMetaData);
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext == null) {
                throw new WSException("MessageContext not available");
            }
            if (opMetaData.isRPCEncoded()) {
                msgContext.put("org.jboss.ws.mtom.enabled", (Object)Boolean.FALSE);
            }
            NamespaceRegistry namespaceRegistry = msgContext.getNamespaceRegistry();
            if (!opMetaData.isMessageEndpoint()) {
                Style style = opMetaData.getStyle();
                SOAPBody payloadParent = soapBody;
                if (style == Style.RPC) {
                    payloadParent = null;
                    Iterator it = soapBody.getChildElements();
                    while (payloadParent == null && it.hasNext()) {
                        Object childNode = it.next();
                        if (!(childNode instanceof SOAPElement)) continue;
                        payloadParent = (SOAPElement)childNode;
                    }
                    if (!RMHelper.isRMOperation(opMetaData.getQName())) {
                        if (payloadParent == null) {
                            throw new SOAPException("Cannot find RPC element in");
                        }
                        QName elName = payloadParent.getElementQName();
                        elName = namespaceRegistry.registerQName(elName);
                    }
                }
                int numParameters = 0;
                for (ParameterMetaData paramMetaData : opMetaData.getParameters()) {
                    SOAPHeader element;
                    QName xmlName = paramMetaData.getXmlName();
                    if (paramMetaData.getMode() == ParameterMode.OUT) {
                        epInv.setRequestParamValue(xmlName, null);
                        continue;
                    }
                    if (paramMetaData.isSwA()) {
                        AttachmentPart part = this.getAttachmentFromMessage(paramMetaData, reqMessage);
                        epInv.setRequestParamValue(xmlName, part);
                        if (part.getDataHandler() == null || !(msgContext instanceof MessageContextJAXWS)) continue;
                        DataHandler dataHandler = part.getDataHandler();
                        Map attachments = (Map)msgContext.get("javax.xml.ws.binding.attachments.inbound");
                        attachments.put(part.getContentId(), dataHandler);
                        continue;
                    }
                    boolean isHeader = paramMetaData.isInHeader();
                    Object object = element = isHeader ? soapHeader : payloadParent;
                    if (!isHeader) {
                        ++numParameters;
                    }
                    SOAPContentElement value = this.getParameterFromMessage(paramMetaData, (SOAPElement)element, false);
                    epInv.setRequestParamValue(xmlName, value);
                }
                if (!RMHelper.isRMOperation(opMetaData.getQName())) {
                    int numChildElements = 0;
                    Iterator itElements = payloadParent.getChildElements();
                    while (itElements.hasNext()) {
                        Node node = (Node)itElements.next();
                        if (!(node instanceof SOAPElement)) continue;
                        ++numChildElements;
                    }
                    if (numChildElements != numParameters) {
                        throw new WSException("Invalid number of payload elements: " + numChildElements);
                    }
                }
            } else {
                for (ParameterMetaData paramMetaData : opMetaData.getParameters()) {
                    QName xmlName = paramMetaData.getXmlName();
                    Object value = soapBody.getChildElements().next();
                    epInv.setRequestParamValue(xmlName, value);
                }
            }
            return epInv;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public MessageAbstraction bindResponseMessage(OperationMetaData opMetaData, EndpointInvocation epInv) throws BindingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("bindResponseMessage: " + opMetaData.getQName()));
        }
        try {
            ParameterMetaData retMetaData;
            QName opQName;
            boolean isWsrmMessage;
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext == null) {
                throw new WSException("MessageContext not available");
            }
            if (opMetaData.isRPCEncoded()) {
                XOPContext.setMTOMEnabled(false);
            } else {
                XOPContext.setMTOMEnabled(this.isMTOMEnabled());
            }
            SOAPMessageImpl resMessage = (SOAPMessageImpl)this.createMessage(opMetaData);
            msgContext.setSOAPMessage(resMessage);
            boolean bl = isWsrmMessage = msgContext.get("wsrm.responseContext") != null;
            if (opMetaData.isOneWay() && !isWsrmMessage) {
                resMessage.getSOAPPart().setContent(null);
                return resMessage;
            }
            SOAPEnvelope soapEnvelope = resMessage.getSOAPPart().getEnvelope();
            SOAPHeader soapHeader = soapEnvelope.getHeader();
            SOAPBody soapBody = soapEnvelope.getBody();
            NamespaceRegistry namespaceRegistry = msgContext.getNamespaceRegistry();
            Style style = opMetaData.getStyle();
            Object soapBodyElement = soapBody;
            if (style == Style.RPC && !RMHelper.isRMOperation(opQName = opMetaData.getResponseName())) {
                NameImpl opName = new NameImpl(namespaceRegistry.registerQName(opQName));
                soapBodyElement = new SOAPBodyElementRpc(opName);
                soapBodyElement = (SOAPBodyElement)soapBody.addChildElement((SOAPElement)soapBodyElement);
                if (opMetaData.getUse() == Use.ENCODED) {
                    String envURI = soapEnvelope.getNamespaceURI();
                    String envPrefix = soapEnvelope.getPrefix();
                    soapBodyElement.setAttributeNS(envURI, envPrefix + ":encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
                }
            }
            if ((retMetaData = opMetaData.getReturnParameter()) != null) {
                Object value = epInv.getReturnValue();
                if (opMetaData.isDocumentWrapped()) {
                    value = ParameterWrapping.wrapResponseParameters(retMetaData, value, epInv.getOutParameters());
                }
                if (retMetaData.isSwA()) {
                    CIDGenerator cidGenerator = resMessage.getCidGenerator();
                    AttachmentPart part = this.createAttachmentPart(retMetaData, value, cidGenerator);
                    resMessage.addAttachmentPart(part);
                    epInv.setReturnValue(part);
                    if (part.getDataHandler() != null && msgContext instanceof MessageContextJAXWS) {
                        DataHandler dataHandler = part.getDataHandler();
                        Map attachments = (Map)msgContext.get("javax.xml.ws.binding.attachments.outbound");
                        attachments.put(part.getContentId(), dataHandler);
                    }
                } else {
                    SOAPContentElement soapElement = this.addParameterToMessage(retMetaData, value, (SOAPElement)soapBodyElement);
                    epInv.setReturnValue(soapElement);
                    soapElement.setObjectValue(value);
                }
            }
            for (ParameterMetaData paramMetaData : opMetaData.getOutputParameters()) {
                QName xmlName = paramMetaData.getXmlName();
                Object value = epInv.getResponseParamValue(xmlName);
                if (paramMetaData.isSwA()) {
                    CIDGenerator cidGenerator = resMessage.getCidGenerator();
                    AttachmentPart part = this.createAttachmentPart(paramMetaData, value, cidGenerator);
                    resMessage.addAttachmentPart(part);
                    if (!(value instanceof DataHandler) || !(msgContext instanceof MessageContextJAXWS)) continue;
                    DataHandler dataHandler = (DataHandler)value;
                    Map attachments = (Map)msgContext.get("javax.xml.ws.binding.attachments.outbound");
                    attachments.put(dataHandler.getContentType(), dataHandler);
                    continue;
                }
                if (paramMetaData.isInHeader()) {
                    this.addParameterToMessage(paramMetaData, value, (SOAPElement)soapHeader);
                    continue;
                }
                this.addParameterToMessage(paramMetaData, value, (SOAPElement)soapBodyElement);
            }
            return resMessage;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void unbindResponseMessage(OperationMetaData opMetaData, MessageAbstraction payload, EndpointInvocation epInv, Map<QName, UnboundHeader> unboundHeaders) throws BindingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("unbindResponseMessage: " + opMetaData.getQName()));
        }
        try {
            ParameterMetaData retMetaData;
            if (opMetaData.isOneWay()) {
                return;
            }
            SOAPMessageImpl resMessage = (SOAPMessageImpl)payload;
            SOAPEnvelope soapEnvelope = resMessage.getSOAPPart().getEnvelope();
            if (soapEnvelope == null) {
                return;
            }
            this.verifySOAPVersion(opMetaData, soapEnvelope);
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext == null) {
                throw new WSException("MessageContext not available");
            }
            if (opMetaData.isRPCEncoded()) {
                msgContext.put("org.jboss.ws.mtom.enabled", (Object)Boolean.FALSE);
            }
            SOAPHeader soapHeader = soapEnvelope.getHeader();
            SOAPBodyImpl soapBody = (SOAPBodyImpl)soapEnvelope.getBody();
            SOAPBodyElement soapBodyElement = soapBody.getBodyElement();
            if (soapBodyElement instanceof SOAPFaultImpl) {
                this.throwFaultException((SOAPFaultImpl)soapBodyElement);
            }
            if (unboundHeaders != null && soapHeader != null) {
                HashMap<QName, UnboundHeader> outHeaders = new HashMap<QName, UnboundHeader>();
                Iterator itHeaderElements = soapHeader.getChildElements();
                while (itHeaderElements.hasNext()) {
                    SOAPHeaderElementImpl soapHeaderElement = (SOAPHeaderElementImpl)itHeaderElements.next();
                    Name elName = soapHeaderElement.getElementName();
                    QName xmlName = new QName(elName.getURI(), elName.getLocalName());
                    UnboundHeader unboundHeader = unboundHeaders.get(xmlName);
                    if (unboundHeader == null) continue;
                    soapHeaderElement.setParamMetaData(unboundHeader.toParameterMetaData(opMetaData));
                    Object value = soapHeaderElement.getObjectValue();
                    unboundHeader.setHeaderValue(value);
                    outHeaders.put(xmlName, unboundHeader);
                }
                unboundHeaders.clear();
                unboundHeaders.putAll(outHeaders);
            }
            Style style = opMetaData.getStyle();
            SOAPBodyImpl soapElement = soapBody;
            if (style == Style.RPC) {
                if (soapBodyElement == null) {
                    throw new WSException("Cannot unbind response message with empty soap body");
                }
                soapElement = soapBodyElement;
            }
            if ((retMetaData = opMetaData.getReturnParameter()) != null) {
                if (retMetaData.isSwA()) {
                    AttachmentPart part = this.getAttachmentFromMessage(retMetaData, resMessage);
                    epInv.setReturnValue(part);
                    if (part.getDataHandler() != null && msgContext instanceof MessageContextJAXWS) {
                        DataHandler dataHandler = part.getDataHandler();
                        Map attachments = (Map)msgContext.get("javax.xml.ws.binding.attachments.inbound");
                        attachments.put(part.getContentId(), dataHandler);
                    }
                } else {
                    SOAPContentElement value = this.getParameterFromMessage(retMetaData, soapElement, false);
                    epInv.setReturnValue(value);
                }
            }
            for (ParameterMetaData paramMetaData : opMetaData.getOutputParameters()) {
                QName xmlName = paramMetaData.getXmlName();
                if (paramMetaData.isSwA()) {
                    AttachmentPart part = this.getAttachmentFromMessage(paramMetaData, resMessage);
                    epInv.setResponseParamValue(xmlName, part);
                    if (part.getDataHandler() == null || !(msgContext instanceof MessageContextJAXWS)) continue;
                    DataHandler dataHandler = part.getDataHandler();
                    Map attachments = (Map)msgContext.get("javax.xml.ws.binding.attachments.inbound");
                    attachments.put(part.getContentId(), dataHandler);
                    continue;
                }
                Object element = paramMetaData.isInHeader() ? soapHeader : soapElement;
                SOAPContentElement value = this.getParameterFromMessage(paramMetaData, (SOAPElement)element, false);
                epInv.setResponseParamValue(xmlName, value);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public MessageAbstraction bindFaultMessage(Exception ex) {
        SOAPMessageImpl faultMessage = (SOAPMessageImpl)this.createFaultMessageFromException(ex);
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext != null) {
            msgContext.setSOAPMessage(faultMessage);
        } else {
            this.log.warn((Object)"Cannot set fault message in message context");
        }
        return faultMessage;
    }

    protected abstract SOAPMessage createFaultMessageFromException(Exception var1);

    private void verifySOAPVersion(OperationMetaData opMetaData, SOAPEnvelope soapEnvelope) {
        String envNS = soapEnvelope.getNamespaceURI();
        String bindingId = opMetaData.getEndpointMetaData().getBindingId();
        if (SOAP11HTTP_BINDING.equals(bindingId) && !"http://schemas.xmlsoap.org/soap/envelope/".equals(envNS)) {
            this.log.warn((Object)("Expected SOAP-1.1 envelope, but got: " + envNS));
        }
        if (SOAP12HTTP_BINDING.equals(bindingId) && !"http://www.w3.org/2003/05/soap-envelope".equals(envNS)) {
            this.log.warn((Object)("Expected SOAP-1.2 envelope, but got: " + envNS));
        }
    }

    private AttachmentPart createAttachmentPart(ParameterMetaData paramMetaData, Object value, CIDGenerator cidGenerator) throws SOAPException, BindingException {
        String partName = paramMetaData.getXmlName().getLocalPart();
        Set<String> mimeTypes = paramMetaData.getMimeTypes();
        AttachmentPartImpl part = new AttachmentPartImpl();
        if (value instanceof DataHandler) {
            DataHandler handler = (DataHandler)value;
            String mimeType = MimeUtils.getBaseMimeType(handler.getContentType());
            if (mimeTypes != null && !MimeUtils.isMemberOf(mimeType, mimeTypes)) {
                this.log.warn((Object)("Mime type " + mimeType + " not allowed for parameter " + partName + " allowed types are " + mimeTypes));
            }
            part.setDataHandler((DataHandler)value);
        } else {
            String mimeType = null;
            mimeType = mimeTypes != null && mimeTypes.size() > 0 ? mimeTypes.iterator().next() : MimeUtils.resolveMimeType(value);
            if (mimeType == null) {
                throw new BindingException("Could not determine mime type for attachment parameter: " + partName);
            }
            part.setContent(value, mimeType);
        }
        if (paramMetaData.isSwA()) {
            String swaCID = '<' + partName + "=" + cidGenerator.generateFromCount() + '>';
            part.setContentId(swaCID);
        }
        if (paramMetaData.isXOP()) {
            String xopCID = '<' + cidGenerator.generateFromName(partName) + '>';
            part.setContentId(xopCID);
        }
        return part;
    }

    private AttachmentPart getAttachmentFromMessage(ParameterMetaData paramMetaData, SOAPMessage message) throws SOAPException, BindingException {
        QName xmlName = paramMetaData.getXmlName();
        AttachmentPart part = ((SOAPMessageImpl)message).getAttachmentByPartName(xmlName.getLocalPart());
        if (part == null) {
            throw new BindingException("Could not locate attachment for parameter: " + paramMetaData.getXmlName());
        }
        return part;
    }

    private SOAPContentElement addParameterToMessage(ParameterMetaData paramMetaData, Object value, SOAPElement soapElement) throws SOAPException, BindingException {
        CommonMessageContext msgContext;
        SOAPContentElement contentElement;
        Class<?> valueType;
        QName xmlName = paramMetaData.getXmlName();
        Class javaType = paramMetaData.getJavaType();
        if (value != null && !paramMetaData.isXOP() && !JavaUtils.isAssignableFrom((Class)javaType, valueType = value.getClass())) {
            throw new BindingException("javaType " + javaType.getName() + " is not assignable from: " + valueType.getName());
        }
        if (xmlName.getNamespaceURI().length() > 0) {
            CommonMessageContext msgContext2 = MessageContextAssociation.peekMessageContext();
            NamespaceRegistry namespaceRegistry = msgContext2.getNamespaceRegistry();
            xmlName = namespaceRegistry.registerQName(xmlName);
        }
        NameImpl soapName = new NameImpl(xmlName.getLocalPart(), xmlName.getPrefix(), xmlName.getNamespaceURI());
        if (soapElement instanceof SOAPHeader) {
            contentElement = new SOAPHeaderElementImpl(soapName);
            soapElement.addChildElement((SOAPElement)contentElement);
        } else {
            Style style = paramMetaData.getOperationMetaData().getStyle();
            if (style == Style.DOCUMENT) {
                contentElement = new SOAPBodyElementDoc(soapName);
                soapElement.addChildElement((SOAPElement)contentElement);
            } else {
                contentElement = new SOAPContentElement(soapName);
                soapElement.addChildElement((SOAPElement)contentElement);
            }
        }
        contentElement.setParamMetaData(paramMetaData);
        if (paramMetaData.isSOAPArrayParam()) {
            this.log.trace((Object)"Add parameter as SOAP encoded Array");
            contentElement.addNamespaceDeclaration("soap11-enc", "http://schemas.xmlsoap.org/soap/encoding/");
        }
        if (paramMetaData.isXOP() && XOPContext.isMTOMEnabled()) {
            this.log.trace((Object)"Add parameter as XOP");
            msgContext = MessageContextAssociation.peekMessageContext();
            SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
            soapMessage.setXOPMessage(true);
        } else if (paramMetaData.isSwaRef()) {
            msgContext = MessageContextAssociation.peekMessageContext();
            SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
            soapMessage.setSWARefMessage(true);
        }
        contentElement.setObjectValue(value);
        return contentElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SOAPContentElement getParameterFromMessage(ParameterMetaData paramMetaData, SOAPElement soapElement, boolean optional) throws BindingException {
        SOAPMessageImpl soapMessage;
        NameImpl xmlName = new NameImpl(paramMetaData.getXmlName());
        SOAPContentElement soapContentElement = null;
        Iterator childElements = soapElement.getChildElements();
        while (childElements.hasNext()) {
            Object childNode = childElements.next();
            if (!(childNode instanceof SOAPElement)) continue;
            SOAPElementImpl childElement = (SOAPElementImpl)childNode;
            if (!(childElement instanceof SOAPContentElement)) {
                childElement = (SOAPContentElement)((Object)soapElement.replaceChild((org.w3c.dom.Node)((Object)new SOAPContentElement(childElement)), (org.w3c.dom.Node)((Object)childElement)));
            }
            SOAPContentElement aux = (SOAPContentElement)childElement;
            Name elName = aux.getElementName();
            if (xmlName.getLocalName().equals("") || ((Object)xmlName).equals(elName)) {
                soapContentElement = aux;
                soapContentElement.setParamMetaData(paramMetaData);
                break;
            }
            if (!SOAP_ARRAY_NAME.equals(elName)) continue;
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            msgContext.put("org.jboss.ws.allow.expand.dom", (Object)Boolean.TRUE);
            try {
                QName compXMLName = paramMetaData.getXmlName();
                Element compElement = DOMUtils.getFirstChildElement((org.w3c.dom.Node)((Object)aux));
                if (compElement != null && !compElement.getNodeName().equals(compXMLName.getLocalPart())) continue;
                soapContentElement = aux;
                soapContentElement.setParamMetaData(paramMetaData);
                break;
            }
            finally {
                msgContext.remove("org.jboss.ws.allow.expand.dom");
            }
        }
        if (soapContentElement == null) {
            childElements = soapElement.getChildElements();
            OperationMetaData opMetaData = paramMetaData.getOperationMetaData();
            TypesMetaData typesMetaData = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
            if (childElements.hasNext() && opMetaData.getStyle() == Style.DOCUMENT) {
                SOAPElementImpl childElement = (SOAPElementImpl)childElements.next();
                SOAPContentElement aux = (SOAPContentElement)childElement;
                Name elName = aux.getElementName();
                QName elType = null;
                XSElementDeclaration xsdElement = typesMetaData.getSchemaModel().getElementDeclaration(elName.getLocalName(), elName.getURI());
                if (xsdElement != null && xsdElement.getTypeDefinition() != null) {
                    XSTypeDefinition xsdType = xsdElement.getTypeDefinition();
                    elType = new QName(xsdType.getNamespace(), xsdType.getName());
                }
                if (paramMetaData.getXmlType().equals(elType)) {
                    soapContentElement = aux;
                    soapContentElement.setParamMetaData(paramMetaData);
                }
            }
        }
        if (soapContentElement == null && !optional) {
            throw new WSException("Cannot find child element: " + xmlName);
        }
        if (paramMetaData.isXOP() && XOPContext.isXOPEncodedRequest()) {
            soapMessage = (SOAPMessageImpl)MessageContextAssociation.peekMessageContext().getSOAPMessage();
            soapMessage.setXOPMessage(true);
        } else if (paramMetaData.isSwaRef()) {
            soapMessage = (SOAPMessageImpl)MessageContextAssociation.peekMessageContext().getSOAPMessage();
            soapMessage.setSWARefMessage(true);
        }
        return soapContentElement;
    }

    protected abstract void throwFaultException(SOAPFaultImpl var1) throws Exception;

    protected abstract void verifyUnderstoodHeader(SOAPHeaderElement var1) throws Exception;

    public void checkMustUnderstand(OperationMetaData opMetaData) throws Exception {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext == null) {
            throw new WSException("MessageContext not available");
        }
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        if (soapEnvelope == null || soapEnvelope.getHeader() == null) {
            return;
        }
        Iterator it = soapEnvelope.getHeader().examineAllHeaderElements();
        while (it.hasNext()) {
            SOAPHeaderElement soapHeaderElement = (SOAPHeaderElement)it.next();
            Name name = soapHeaderElement.getElementName();
            QName xmlName = new QName(name.getURI(), name.getLocalName());
            ParameterMetaData paramMetaData = opMetaData != null ? opMetaData.getParameter(xmlName) : null;
            boolean isBoundHeader = paramMetaData != null && paramMetaData.isInHeader();
            if (isBoundHeader || !soapHeaderElement.getMustUnderstand()) continue;
            this.verifyUnderstoodHeader(soapHeaderElement);
        }
    }

    @Override
    public void setHeaderSource(HeaderSource source) {
        this.headerSource = source;
    }

    private void handleException(Exception ex) throws BindingException {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof BindingException) {
            throw (BindingException)ex;
        }
        throw new BindingException(ex);
    }
}

