/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client.transport;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelPipelineCoverage(value="one")
public class WSResponseHandler
extends SimpleChannelUpstreamHandler {
    private FutureResult future = new FutureResult();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this.future.isCancelled()) {
            return;
        }
        this.future.start();
        ResultImpl result = new ResultImpl();
        this.future.setResult(result);
        try {
            HttpResponse response = (HttpResponse)e.getMessage();
            Map<String, Object> responseHeaders = result.getResponseHeaders();
            responseHeaders.put("Protocol", response.getProtocolVersion());
            responseHeaders.put("ResponseCode", response.getStatus().getCode());
            responseHeaders.put("ResponseCodeMessage", response.getStatus().getReasonPhrase());
            for (String headerName : response.getHeaderNames()) {
                responseHeaders.put(headerName, response.getHeaders(headerName));
            }
            ChannelBuffer content = response.getContent();
            result.setResponse((InputStream)new ChannelBufferInputStream(content));
        }
        catch (Throwable t) {
            this.future.setException(t);
        }
        finally {
            this.future.done();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (this.future.isCancelled()) {
            return;
        }
        this.future.start();
        this.future.setException(e.getCause());
        this.future.done();
    }

    public Future<Result> getFutureResult() {
        return this.future;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultImpl
    implements Result {
        private InputStream is;
        private Map<String, Object> responseHeaders = new HashMap<String, Object>();

        private ResultImpl() {
        }

        @Override
        public InputStream getResponse() {
            return this.is;
        }

        public void setResponse(InputStream is) {
            this.is = is;
        }

        @Override
        public Map<String, Object> getResponseHeaders() {
            return this.responseHeaders;
        }

        public void setResponseHeaders(Map<String, Object> responseHeaders) {
            this.responseHeaders = responseHeaders;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Result {
        public InputStream getResponse();

        public Map<String, Object> getResponseHeaders();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FutureResult
    implements Future<Result> {
        protected Result result;
        protected Throwable exception;
        protected boolean done = false;
        protected boolean cancelled = false;
        protected boolean started = false;

        public void setResult(Result result) {
            this.result = result;
        }

        public void setException(Throwable exception) {
            this.exception = exception;
        }

        public void start() {
            this.started = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            this.done = true;
            FutureResult futureResult = this;
            synchronized (futureResult) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.started) {
                this.cancelled = true;
                FutureResult futureResult = this;
                synchronized (futureResult) {
                    this.notifyAll();
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result get() throws InterruptedException, ExecutionException {
            FutureResult futureResult = this;
            synchronized (futureResult) {
                if (!this.done) {
                    this.wait();
                }
            }
            if (this.cancelled) {
                throw new InterruptedException("Operation Cancelled");
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            FutureResult futureResult = this;
            synchronized (futureResult) {
                if (!this.done) {
                    unit.timedWait(this, timeout);
                }
            }
            if (this.cancelled) {
                throw new InterruptedException("Operation Cancelled");
            }
            if (!this.done) {
                throw new TimeoutException("Timeout Exceeded");
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }
    }
}

