/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.CommonSOAPFaultException;
import org.jboss.ws.core.binding.AbstractDeserializerFactory;
import org.jboss.ws.core.binding.AbstractSerializerFactory;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.DeserializerSupport;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.binding.SerializerSupport;
import org.jboss.ws.core.binding.TypeMappingImpl;
import org.jboss.ws.core.jaxrpc.SOAPFaultHelperJAXRPC;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.MessageFactoryImpl;
import org.jboss.ws.core.soap.NameImpl;
import org.jboss.ws.core.soap.SOAPFactoryImpl;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.core.soap.XMLFragment;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPFaultHelperJAXWS {
    private static Logger log = Logger.getLogger(SOAPFaultHelperJAXWS.class);

    public static SOAPFaultException getSOAPFaultException(SOAPFault soapFault) {
        if (soapFault == null) {
            throw new IllegalArgumentException("SOAPFault cannot be null");
        }
        SOAPFaultException faultEx = new SOAPFaultException(soapFault);
        Detail detail = soapFault.getDetail();
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (detail != null && msgContext != null) {
            log.debug((Object)"Processing detail");
            SerializationContext serContext = msgContext.getSerializationContext();
            TypeMappingImpl typeMapping = serContext.getTypeMapping();
            Iterator it = detail.getDetailEntries();
            boolean debugEnabled = log.isDebugEnabled();
            while (it.hasNext()) {
                OperationMetaData opMetaData;
                FaultMetaData faultMetaData;
                DetailEntry deElement = (DetailEntry)it.next();
                QName xmlName = deElement.getElementQName();
                if (debugEnabled) {
                    log.debug((Object)("Processing detail entry: " + xmlName));
                }
                if ((faultMetaData = (opMetaData = msgContext.getOperationMetaData()).getFault(xmlName)) != null) {
                    String nsURI;
                    if (debugEnabled) {
                        log.debug((Object)("Deserialize fault: " + faultMetaData));
                    }
                    QName xmlType = faultMetaData.getXmlType();
                    Class faultBeanClass = faultMetaData.getFaultBean();
                    AbstractDeserializerFactory desFactory = (AbstractDeserializerFactory)typeMapping.getDeserializer(faultBeanClass, xmlType);
                    if (desFactory == null) {
                        throw new WebServiceException("Cannot obtain deserializer factory: xmlType=" + xmlType + ", javaType=" + faultBeanClass);
                    }
                    String prefix = deElement.getPrefix();
                    if (prefix != null && prefix.length() > 0 && (nsURI = deElement.getNamespaceURI()).length() > 0 && deElement.getAttributeNS("http://www.w3.org/2000/xmlns/", prefix).length() == 0) {
                        try {
                            deElement.addNamespaceDeclaration(prefix, nsURI);
                        }
                        catch (SOAPException e) {
                            log.warn((Object)"Declaration of detail entry namespace failed", (Throwable)e);
                        }
                    }
                    try {
                        Class[] types = opMetaData.getEndpointMetaData().getRegisteredTypes().toArray(new Class[0]);
                        serContext.setProperty("org.jboss.ws.jaxb.context.types", types);
                        DOMSource source = new DOMSource((Node)deElement);
                        DeserializerSupport des = desFactory.getDeserializer();
                        Object faultBean = des.deserialize(xmlName, xmlType, source, serContext);
                        Exception serviceEx = faultMetaData.toServiceException(faultBean, soapFault.getFaultString());
                        faultEx.initCause((Throwable)serviceEx);
                        continue;
                    }
                    catch (BindingException e) {
                        throw new WebServiceException((Throwable)e);
                    }
                }
                if (!debugEnabled) continue;
                log.debug((Object)("Cannot find fault meta data for: " + xmlName));
            }
        }
        return faultEx;
    }

    public static SOAPMessageImpl exceptionToFaultMessage(Exception reqEx) {
        log.error((Object)"SOAP request exception", (Throwable)reqEx);
        try {
            Throwable cause = reqEx.getCause();
            SOAPMessageImpl faultMessage = reqEx instanceof SOAPFaultException ? SOAPFaultHelperJAXWS.toSOAPMessage((SOAPFaultException)reqEx) : (cause != null && cause instanceof SOAPFaultException ? SOAPFaultHelperJAXWS.toSOAPMessage((SOAPFaultException)cause) : (reqEx instanceof CommonSOAPFaultException ? SOAPFaultHelperJAXRPC.exceptionToFaultMessage(reqEx) : SOAPFaultHelperJAXWS.toSOAPMessage(reqEx)));
            return faultMessage;
        }
        catch (SOAPException ex) {
            log.error((Object)"Error creating SOAPFault message", (Throwable)ex);
            throw new WebServiceException("Cannot create SOAPFault message for: " + reqEx);
        }
    }

    private static SOAPMessageImpl toSOAPMessage(SOAPFaultException faultEx) throws SOAPException {
        SOAPMessageImpl soapMessage = SOAPFaultHelperJAXWS.createSOAPMessage();
        SOAPBody soapBody = soapMessage.getSOAPBody();
        SOAPFaultHelperJAXWS.populateSOAPFault(soapBody, faultEx);
        Detail detail = faultEx.getFault().getDetail();
        if (detail != null) {
            soapBody.getFault().addChildElement((SOAPElement)detail);
        }
        return soapMessage;
    }

    private static void populateSOAPFault(SOAPBody soapBody, SOAPFaultException faultEx) throws SOAPException {
        SOAPFault sourceFault = faultEx.getFault();
        Name faultCode = sourceFault.getFaultCodeAsName();
        faultCode = faultCode != null ? new NameImpl(faultCode.getLocalName(), "codeNS", faultCode.getURI()) : SOAPFaultHelperJAXWS.getFallbackFaultCode();
        String faultString = sourceFault.getFaultString();
        if (faultString == null) {
            faultString = SOAPFaultHelperJAXWS.getFallbackFaultString((Exception)faultEx);
        }
        SOAPFault targetFault = soapBody.addFault(faultCode, faultString);
        String faultActor = sourceFault.getFaultActor();
        if (faultActor != null) {
            targetFault.setFaultActor(faultActor);
        }
    }

    private static SOAPMessageImpl toSOAPMessage(Exception ex) throws SOAPException {
        SOAPMessageImpl soapMessage = SOAPFaultHelperJAXWS.createSOAPMessage();
        SOAPBody soapBody = soapMessage.getSOAPBody();
        SOAPFault soapFault = soapBody.addFault(SOAPFaultHelperJAXWS.getFallbackFaultCode(), SOAPFaultHelperJAXWS.getFallbackFaultString(ex));
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        SerializationContext serContext = msgContext.getSerializationContext();
        NameImpl faultCode = (NameImpl)soapFault.getFaultCodeAsName();
        if (faultCode.getURI().length() > 0) {
            serContext.getNamespaceRegistry().registerQName(faultCode.toQName());
        }
        OperationMetaData opMetaData = msgContext.getOperationMetaData();
        Class<?> exClass = ex.getClass();
        if (opMetaData != null && opMetaData.getFaultMetaData(exClass) != null) {
            FaultMetaData faultMetaData = opMetaData.getFaultMetaData(exClass);
            Object faultBean = faultMetaData.toFaultBean(ex);
            Detail detail = soapFault.addDetail();
            SOAPElement detailEntry = SOAPFaultHelperJAXWS.toDetailEntry(faultBean, serContext, faultMetaData);
            detail.addChildElement(detailEntry);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Cannot obtain fault meta data for: " + exClass));
        }
        return soapMessage;
    }

    private static SOAPMessageImpl createSOAPMessage() throws SOAPException {
        MessageFactoryImpl factory = (MessageFactoryImpl)MessageFactory.newInstance();
        if (SOAPFaultHelperJAXWS.isSOAP12()) {
            factory.setEnvNamespace("http://www.w3.org/2003/05/soap-envelope");
        }
        return (SOAPMessageImpl)factory.createMessage();
    }

    private static boolean isSOAP12() {
        EndpointMetaData emd;
        String bindingId;
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        return msgContext != null && ("http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(bindingId = (emd = msgContext.getEndpointMetaData()).getBindingId()) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(bindingId));
    }

    private static Name getFallbackFaultCode() {
        if (!SOAPFaultHelperJAXWS.isSOAP12()) {
            return new NameImpl(Constants.SOAP11_FAULT_CODE_SERVER);
        }
        return new NameImpl(SOAPConstants.SOAP_RECEIVER_FAULT);
    }

    private static String getFallbackFaultString(Exception ex) {
        String faultString = ex.getMessage();
        if (faultString == null) {
            faultString = ex.toString();
        }
        return faultString;
    }

    private static SOAPElement toDetailEntry(Object faultObject, SerializationContext serContext, FaultMetaData faultMetaData) throws SOAPException {
        QName xmlName = faultMetaData.getXmlName();
        xmlName = serContext.getNamespaceRegistry().registerQName(xmlName);
        QName xmlType = faultMetaData.getXmlType();
        Class javaType = faultMetaData.getFaultBean();
        serContext.setJavaType(javaType);
        AbstractSerializerFactory serFactory = (AbstractSerializerFactory)serContext.getTypeMapping().getSerializer(javaType, xmlType);
        if (serFactory == null) {
            throw new WebServiceException("Cannot obtain serializer factory: xmlType=" + xmlType + ", javaType=" + javaType);
        }
        try {
            SerializerSupport ser = serFactory.getSerializer();
            Result result = ser.serialize(xmlName, xmlType, faultObject, serContext, null);
            XMLFragment xmlFragment = new XMLFragment(result);
            String xmlStr = xmlFragment.toXMLString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fault detail: " + xmlStr));
            }
            Element domElement = xmlFragment.toElement();
            SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
            return soapFactory.createElement(domElement);
        }
        catch (BindingException e) {
            throw new WebServiceException((Throwable)e);
        }
    }
}

