/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing.map;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingConstants;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.addressing.EndpointReference;
import org.jboss.ws.extensions.addressing.map.NativeMAP;
import org.jboss.ws.extensions.addressing.map.NativeMAPConstants;
import org.jboss.ws.extensions.addressing.map.NativeMAPEndpoint;
import org.jboss.ws.extensions.addressing.map.NativeMAPRelatesTo;
import org.jboss.wsf.common.addressing.MAP;
import org.jboss.wsf.common.addressing.MAPBuilder;
import org.jboss.wsf.common.addressing.MAPConstants;
import org.jboss.wsf.common.addressing.MAPEndpoint;
import org.jboss.wsf.common.addressing.MAPRelatesTo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeMAPBuilder
implements MAPBuilder {
    private AddressingBuilder addressingBuilder;
    private static MAPBuilder theBuilder = new NativeMAPBuilder();

    private NativeMAPBuilder() {
        AddressingBuilder implementation;
        this.addressingBuilder = implementation = AddressingBuilder.getAddressingBuilder();
    }

    public static MAPBuilder getBuilder() {
        return theBuilder;
    }

    public MAP newMap() {
        AddressingProperties implementation = this.addressingBuilder.newAddressingProperties();
        return new NativeMAP(implementation);
    }

    public MAP inboundMap(Map<String, Object> ctx) {
        AddressingProperties implementation = (AddressingProperties)ctx.get("javax.xml.ws.addressing.context.inbound");
        return this.newMap(implementation);
    }

    public MAP outboundMap(Map<String, Object> ctx) {
        AddressingProperties implementation = (AddressingProperties)ctx.get("javax.xml.ws.addressing.context.outbound");
        return this.newMap(implementation);
    }

    MAP newMap(AddressingProperties implementation) {
        return new NativeMAP(implementation);
    }

    public MAPConstants newConstants() {
        AddressingConstants implementation = this.addressingBuilder.newAddressingConstants();
        return new NativeMAPConstants(implementation);
    }

    public MAPEndpoint newEndpoint(String address) {
        try {
            URI uri = new URI(address);
            EndpointReference implementation = this.addressingBuilder.newEndpointReference(uri);
            return new NativeMAPEndpoint(implementation);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public MAPRelatesTo newRelatesTo(String id, QName type) {
        return new NativeMAPRelatesTo(id, type);
    }
}

