/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.transport;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jboss.logging.Logger;
import org.jboss.ws.core.MessageTrace;
import org.jboss.ws.core.client.transport.NettyClient;
import org.jboss.ws.extensions.wsrm.RMClientSequence;
import org.jboss.ws.extensions.wsrm.transport.RMChannelResponse;
import org.jboss.ws.extensions.wsrm.transport.RMMarshaller;
import org.jboss.ws.extensions.wsrm.transport.RMMessage;
import org.jboss.ws.extensions.wsrm.transport.RMTransportHelper;
import org.jboss.ws.extensions.wsrm.transport.RMUnMarshaller;
import org.jboss.ws.extensions.wsrm.transport.backchannel.RMCallbackHandler;
import org.jboss.ws.extensions.wsrm.transport.backchannel.RMCallbackHandlerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RMChannelTask
implements Callable<RMChannelResponse> {
    private static final Logger logger = Logger.getLogger(RMChannelTask.class);
    private final RMMessage rmRequest;

    RMChannelTask(RMMessage rmRequest) {
        this.rmRequest = rmRequest;
    }

    @Override
    public RMChannelResponse call() {
        try {
            String targetAddress = (String)this.rmRequest.getMetadata().getContext("invocationContext").get("targetAddress");
            URI backPort = RMTransportHelper.getBackPortURI(this.rmRequest);
            String messageId = RMTransportHelper.getAddressingMessageId(this.rmRequest);
            logger.debug((Object)("[WS-RM] backport URI is: " + backPort));
            RMCallbackHandler callbackHandler = null;
            if (backPort != null) {
                callbackHandler = RMCallbackHandlerFactory.getCallbackHandler(backPort);
                RMClientSequence sequence = RMTransportHelper.getSequence(this.rmRequest);
                if (sequence != null) {
                    callbackHandler.addUnassignedMessageListener(sequence);
                }
            }
            boolean oneWay = RMTransportHelper.isOneWayOperation(this.rmRequest);
            NettyClient client = new NettyClient(RMMarshaller.getInstance(), RMUnMarshaller.getInstance());
            Map<String, Object> additionalHeaders = this.rmRequest.getMetadata().getContext("remotingInvocationContext");
            HashMap<String, Object> callProps = new HashMap<String, Object>();
            callProps.putAll(this.rmRequest.getMetadata().getContext("invocationContext"));
            MessageTrace.traceMessage("Outgoing RM Response Message", this.rmRequest.getPayload());
            RMMessage rmResponse = null;
            if (oneWay && null == backPort) {
                client.invoke(this.rmRequest.getPayload(), targetAddress, true, additionalHeaders, callProps);
            } else {
                Object retVal = client.invoke(this.rmRequest.getPayload(), targetAddress, false, additionalHeaders, callProps);
                if (null != retVal && !(retVal instanceof RMMessage)) {
                    String msg = retVal.getClass().getName() + ": '" + retVal + "'";
                    logger.warn((Object)msg);
                    throw new IOException(msg);
                }
                rmResponse = (RMMessage)retVal;
            }
            this.rmRequest.getMetadata().getContext("invocationContext").putAll(callProps);
            if (rmResponse != null && backPort == null) {
                MessageTrace.traceMessage("Incoming RM Response Message", rmResponse.getPayload());
            }
            if (backPort != null && null != messageId && !RMTransportHelper.isOneWayOperation(this.rmRequest)) {
                return new RMChannelResponse(callbackHandler, messageId);
            }
            return new RMChannelResponse(rmResponse);
        }
        catch (Throwable t) {
            return new RMChannelResponse(t);
        }
    }
}

