/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.client.Marshaller;
import org.jboss.ws.core.client.UnMarshaller;
import org.jboss.ws.extensions.wsrm.transport.RMMessage;
import org.jboss.ws.extensions.wsrm.transport.RMMessageFactory;
import org.jboss.ws.extensions.wsrm.transport.RMMetadata;
import org.jboss.ws.extensions.wsrm.transport.RMTransportHelper;

public final class RMMessageAssembler {
    public static RMMessage convertMessageToRMSource(MessageAbstraction request, RMMetadata rmMetadata) throws Throwable {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Marshaller marshaller = (Marshaller)rmMetadata.getContext("serializationContext").get("marshaller");
        marshaller.write(request, baos);
        RMMessage rmMessage = RMMessageFactory.newMessage(baos.toByteArray(), rmMetadata);
        return rmMessage;
    }

    public static MessageAbstraction convertRMSourceToMessage(RMMessage rmRequest, RMMessage rmResponse, RMMetadata rmMetadata) throws Throwable {
        boolean oneWay = RMTransportHelper.isOneWayOperation(rmRequest);
        MessageAbstraction response = null;
        if (!oneWay) {
            byte[] payload = rmResponse.getPayload();
            ByteArrayInputStream in = payload == null ? null : new ByteArrayInputStream(rmResponse.getPayload());
            UnMarshaller unmarshaller = (UnMarshaller)rmMetadata.getContext("serializationContext").get("unmarshaller");
            response = (MessageAbstraction)unmarshaller.read(in, rmResponse.getMetadata().getContext("remotingInvocationContext"));
        }
        Map<String, Object> invocationContext = rmMetadata.getContext("invocationContext");
        invocationContext.clear();
        invocationContext.putAll(rmMetadata.getContext("remotingInvocationContext"));
        return response;
    }
}

