/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.ExternalContextFactoryImpl;
import com.sun.faces.util.FacesLogger;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;

public class InjectionExternalContextFactory
extends ExternalContextFactory {
    private static final Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private final ExternalContextFactory delegate;
    private Field defaultExternalContext;

    public InjectionExternalContextFactory(ExternalContextFactory delegate) {
        this.delegate = delegate;
        try {
            this.defaultExternalContext = ExternalContext.class.getDeclaredField("defaultExternalContext");
            this.defaultExternalContext.setAccessible(true);
        }
        catch (NoSuchFieldException nsfe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to find private field named 'defaultExternalContext' in javax.faces.context.ExternalContext.");
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            this.defaultExternalContext = null;
        }
    }

    public ExternalContextFactory getWrapped() {
        return this.delegate;
    }

    public ExternalContext getExternalContext(Object context, Object request, Object response) throws FacesException {
        ExternalContext ctx = this.delegate.getExternalContext(context, request, response);
        if (ctx == null) {
            String message = MessageFormat.format("Delegate ExternalContextFactory, {0}, returned null when calling getExternalContext().", this.delegate.getClass().getName());
            throw new IllegalStateException(message);
        }
        if (context instanceof ServletContext) {
            this.injectDefaults(ctx, request);
        }
        return ctx;
    }

    private void injectDefaults(ExternalContext target, Object request) {
        block5: {
            if (this.defaultExternalContext != null) {
                ServletRequest reqObj;
                ExternalContext defaultExtContext = null;
                if (request instanceof ServletRequest && (defaultExtContext = (ExternalContext)(reqObj = (ServletRequest)request).getAttribute(ExternalContextFactoryImpl.DEFAULT_EXTERNAL_CONTEXT_KEY)) != null) {
                    reqObj.removeAttribute(ExternalContextFactoryImpl.DEFAULT_EXTERNAL_CONTEXT_KEY);
                }
                if (defaultExtContext != null) {
                    try {
                        this.defaultExternalContext.set(target, defaultExtContext);
                    }
                    catch (IllegalAccessException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block5;
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
        }
    }
}

