/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jmx;

import java.util.Arrays;
import java.util.logging.LoggingMXBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.plugins.jmx.MBeanResourceComponent;

public class JavaUtilLoggingResourceComponent
extends MBeanResourceComponent {
    public Configuration loadResourceConfiguration() {
        EmsAttribute namesAttribute = this.getEmsBean().getAttribute("LoggerNames");
        Object[] names = (String[])namesAttribute.refresh();
        Arrays.sort(names);
        LoggingMXBean logging = (LoggingMXBean)this.getEmsBean().getProxy(LoggingMXBean.class);
        Configuration configuration = new Configuration();
        PropertyList list = new PropertyList("AppenderList");
        for (Object name : names) {
            if (name == null || ((String)name).equals("")) continue;
            PropertyMap map = new PropertyMap("Appender");
            String level = this.getLoggerLevel(logging, (String)name);
            map.put((Property)new PropertySimple("name", name));
            map.put((Property)new PropertySimple("level", (Object)level));
            list.add((Property)map);
        }
        configuration.put((Property)list);
        return configuration;
    }

    public String getLoggerLevel(LoggingMXBean logging, String name) {
        String level = logging.getLoggerLevel(name);
        if (level != null) {
            String parentLoggerName = logging.getParentLoggerName(name);
            if (level.equals("") && parentLoggerName != null && !parentLoggerName.equals("")) {
                level = this.getLoggerLevel(logging, parentLoggerName);
            }
        } else {
            level = "Pseudo";
        }
        return level;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        PropertyList list = report.getConfiguration().getList("AppenderList");
        LoggingMXBean logging = (LoggingMXBean)this.getEmsBean().getProxy(LoggingMXBean.class);
        for (Property property : list.getList()) {
            PropertyMap map = (PropertyMap)property;
            String name = map.getSimple("name").getStringValue();
            String level = map.getSimple("level").getStringValue();
            if (level == null || level.equals(this.getLoggerLevel(logging, name))) continue;
            try {
                logging.setLoggerLevel(name, level);
            }
            catch (IllegalArgumentException iae) {
                report.setErrorMessage("Error setting logger level: " + iae.getMessage());
            }
        }
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
    }
}

