/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas5.AbstractManagedDeploymentComponent;
import org.rhq.plugins.jbossas5.helper.MoreKnownComponentTypes;
import org.rhq.plugins.jbossas5.util.ManagedComponentUtils;
import org.rhq.plugins.jbossas5.util.RegularExpressionNameMatcher;
import org.rhq.plugins.jbossas5.util.ResourceComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebApplicationContextDiscoveryComponent
implements ResourceDiscoveryComponent<AbstractManagedDeploymentComponent> {
    private static final String CONTEXT_COMPONENT_NAME = "ContextMO";
    private static final String WEB_APPLICATION_COMPONENT_NAMES_REGEX_TEMPLATE = "jboss.web:J2EEApplication=none,J2EEServer=none,j2eeType=WebModule,name=//[^/]+%contextPath%";
    private static final String WEB_APPLICATION_MANAGER_COMPONENT_NAME_TEMPLATE = "jboss.web:host=%virtualHost%,path=%contextPath%,type=Manager";
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<AbstractManagedDeploymentComponent> discoveryContext) throws Exception {
        ResourceType resourceType = discoveryContext.getResourceType();
        this.log.trace((Object)("Discovering " + resourceType.getName() + " Resources..."));
        AbstractManagedDeploymentComponent parentWarComponent = (AbstractManagedDeploymentComponent)discoveryContext.getParentResourceComponent();
        ManagementView managementView = parentWarComponent.getConnection().getManagementView();
        managementView.load();
        String contextPath = this.getContextPath(discoveryContext);
        Set<ManagedComponent> webApplicationComponents = WebApplicationContextDiscoveryComponent.getWebApplicationComponents(contextPath, managementView);
        LinkedHashSet<DiscoveredResourceDetails> discoveredResources = new LinkedHashSet<DiscoveredResourceDetails>(webApplicationComponents.size());
        for (ManagedComponent webApplicationComponent : webApplicationComponents) {
            String virtualHost = WebApplicationContextDiscoveryComponent.getWebApplicationComponentVirtualHost(webApplicationComponent);
            String resourceName = "//" + virtualHost + contextPath;
            String resourceKey = virtualHost;
            String resourceVersion = null;
            Configuration pluginConfig = discoveryContext.getDefaultPluginConfiguration();
            pluginConfig.put((Property)new PropertySimple("virtualHost", (Object)virtualHost));
            pluginConfig.put((Property)new PropertySimple("contextPath", (Object)contextPath));
            String webApplicationManagerComponentName = ResourceComponentUtils.replacePropertyExpressionsInTemplate(WEB_APPLICATION_MANAGER_COMPONENT_NAME_TEMPLATE, pluginConfig);
            pluginConfig.put((Property)new PropertySimple("componentName", (Object)webApplicationManagerComponentName));
            DiscoveredResourceDetails resource = new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, resourceVersion, resourceType.getDescription(), pluginConfig, null);
            discoveredResources.add(resource);
        }
        this.log.trace((Object)("Discovered " + discoveredResources.size() + " " + resourceType.getName() + " Resources."));
        return discoveredResources;
    }

    @Nullable
    private String getContextPath(ResourceDiscoveryContext<AbstractManagedDeploymentComponent> discoveryContext) throws NoSuchDeploymentException {
        AbstractManagedDeploymentComponent parentWarComponent = (AbstractManagedDeploymentComponent)discoveryContext.getParentResourceComponent();
        ManagedDeployment deployment = parentWarComponent.getManagedDeployment();
        ManagedComponent contextComponent = deployment.getComponent(CONTEXT_COMPONENT_NAME);
        if (contextComponent != null) {
            return (String)((Object)ManagedComponentUtils.getSimplePropertyValue(contextComponent, "contextRoot"));
        }
        return null;
    }

    static Set<String> getVirtualHosts(String contextPath, ManagementView managementView) throws Exception {
        HashSet<String> virtualHosts = new HashSet<String>();
        Set<ManagedComponent> webApplicationManagerComponents = WebApplicationContextDiscoveryComponent.getWebApplicationComponents(contextPath, managementView);
        for (ManagedComponent webApplicationManagerComponent : webApplicationManagerComponents) {
            virtualHosts.add(WebApplicationContextDiscoveryComponent.getWebApplicationComponentVirtualHost(webApplicationManagerComponent));
        }
        return virtualHosts;
    }

    private static Set<ManagedComponent> getWebApplicationComponents(String contextPath, ManagementView managementView) throws Exception {
        if (contextPath == null) {
            return Collections.emptySet();
        }
        String webApplicationManagerComponentNamesRegex = WEB_APPLICATION_COMPONENT_NAMES_REGEX_TEMPLATE.replaceAll("%contextPath%", contextPath);
        ComponentType webApplicationComponentType = MoreKnownComponentTypes.MBean.WebApplication.getType();
        return ManagedComponentUtils.getManagedComponents(managementView, webApplicationComponentType, webApplicationManagerComponentNamesRegex, new RegularExpressionNameMatcher());
    }

    private static String getWebApplicationComponentVirtualHost(ManagedComponent webApplicationComponent) {
        ObjectName objectName;
        try {
            objectName = new ObjectName(webApplicationComponent.getName());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("'" + webApplicationComponent.getName() + "' is not a valid JMX ObjectName.");
        }
        String name = objectName.getKeyProperty("name");
        return name.substring(2, name.lastIndexOf(47));
    }
}

