/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.xnio;

import java.net.SocketAddress;
import org.jboss.netty.channel.AbstractChannelSink;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.xnio.DefaultXnioServerChannel;
import org.jboss.netty.channel.xnio.XnioChannel;
import org.jboss.netty.channel.xnio.XnioClientChannelSink;

final class XnioServerChannelSink
extends AbstractChannelSink {
    private final XnioClientChannelSink acceptedChannelSink = new XnioClientChannelSink();

    XnioServerChannelSink() {
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (channel instanceof DefaultXnioServerChannel) {
            this.handleServerSocket(e);
        } else if (channel instanceof XnioChannel) {
            this.acceptedChannelSink.eventSunk(pipeline, e);
        } else {
            throw new Error("should not reach here");
        }
    }

    private void handleServerSocket(ChannelEvent e) {
        if (!(e instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e;
        DefaultXnioServerChannel channel = (DefaultXnioServerChannel)event.getChannel();
        ChannelFuture future = event.getFuture();
        ChannelState state = event.getState();
        Object value = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value)) break;
                channel.closeNow(future);
                break;
            }
            case BOUND: {
                if (value != null) {
                    channel.bindNow(future, (SocketAddress)value);
                    break;
                }
                channel.closeNow(future);
            }
        }
    }
}

