/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.mcmp.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.modcluster.Context;
import org.jboss.modcluster.Engine;
import org.jboss.modcluster.Host;
import org.jboss.modcluster.Server;
import org.jboss.modcluster.config.BalancerConfiguration;
import org.jboss.modcluster.config.NodeConfiguration;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPRequestFactory;
import org.jboss.modcluster.mcmp.ResetRequestSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResetRequestSourceImpl
implements ResetRequestSource {
    private final NodeConfiguration nodeConfig;
    private final BalancerConfiguration balancerConfig;
    private final MCMPRequestFactory requestFactory;
    private volatile Map<String, Set<String>> excludedContexts;
    private volatile Server server;

    public ResetRequestSourceImpl(NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig, MCMPRequestFactory requestFactory) {
        this.nodeConfig = nodeConfig;
        this.balancerConfig = balancerConfig;
        this.requestFactory = requestFactory;
    }

    @Override
    public void init(Server server, Map<String, Set<String>> excludedContexts) {
        this.excludedContexts = excludedContexts;
        this.server = server;
    }

    @Override
    public List<MCMPRequest> getResetRequests(Map<String, Set<ResetRequestSource.VirtualHost>> response) {
        ArrayList<MCMPRequest> requests = new ArrayList<MCMPRequest>();
        if (this.server == null) {
            return requests;
        }
        LinkedList<MCMPRequest> engineRequests = new LinkedList<MCMPRequest>();
        for (Engine engine : this.server.getEngines()) {
            engineRequests.add(this.requestFactory.createConfigRequest(engine, this.nodeConfig, this.balancerConfig));
            String jvmRoute = engine.getJvmRoute();
            Set<ResetRequestSource.VirtualHost> responseHosts = response.containsKey(jvmRoute) ? response.get(jvmRoute) : Collections.emptySet();
            for (Host host : engine.getHosts()) {
                String hostName = host.getName();
                Set<String> aliases = host.getAliases();
                ResetRequestSource.VirtualHost responseHost = null;
                for (ResetRequestSource.VirtualHost virtualHost : responseHosts) {
                    if (!virtualHost.getAliases().contains(hostName)) continue;
                    responseHost = virtualHost;
                    break;
                }
                Set<String> responseAliases = Collections.emptySet();
                Map<Object, Object> responseContexts = Collections.emptyMap();
                if (responseHost != null) {
                    responseAliases = responseHost.getAliases();
                    responseContexts = responseHost.getContexts();
                    if (!((Object)aliases).equals(responseAliases)) {
                        engineRequests.add(0, this.requestFactory.createRemoveRequest(engine));
                    }
                }
                HashSet obsoleteContexts = new HashSet(responseContexts.keySet());
                for (Context context : host.getContexts()) {
                    String path = context.getPath();
                    Set<String> excludedPaths = this.excludedContexts.get(hostName);
                    if (excludedPaths != null && excludedPaths.contains(path)) continue;
                    obsoleteContexts.remove(path);
                    ResetRequestSource.Status status = (ResetRequestSource.Status)((Object)responseContexts.get(path));
                    if (context.isStarted()) {
                        if (status == ResetRequestSource.Status.ENABLED) continue;
                        engineRequests.add(this.requestFactory.createEnableRequest(context));
                        continue;
                    }
                    if (status != ResetRequestSource.Status.ENABLED) continue;
                    engineRequests.add(this.requestFactory.createStopRequest(context));
                }
                if (obsoleteContexts.isEmpty()) continue;
                if (obsoleteContexts.size() == responseContexts.size()) {
                    engineRequests.add(0, this.requestFactory.createRemoveRequest(engine));
                    continue;
                }
                for (String string : obsoleteContexts) {
                    engineRequests.add(this.requestFactory.createRemoveContextRequest(jvmRoute, responseAliases, string));
                }
            }
            requests.addAll(engineRequests);
            engineRequests.clear();
        }
        return requests;
    }
}

