/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingProperties;
import org.jboss.logging.Logger;
import org.jboss.ws.core.jaxws.client.ClientImpl;
import org.jboss.ws.core.server.netty.NettyCallbackHandler;
import org.jboss.ws.core.server.netty.NettyHttpServer;
import org.jboss.ws.core.server.netty.NettyHttpServerFactory;
import org.jboss.ws.extensions.addressing.AddressingClientUtil;
import org.jboss.ws.extensions.wsrm.RMAddressingConstants;
import org.jboss.ws.extensions.wsrm.RMSequence;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.config.RMConfig;
import org.jboss.ws.extensions.wsrm.protocol.RMConstants;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMIncompleteSequenceBehavior;
import org.jboss.ws.extensions.wsrm.transport.RMUnassignedMessageListener;
import org.jboss.ws.extensions.wsrm.transport.backchannel.RMRequestHandlerFactory;
import org.jboss.wsf.common.utils.UUIDGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RMClientSequence
implements RMSequence,
RMUnassignedMessageListener {
    private static final Logger logger = Logger.getLogger(RMClientSequence.class);
    private static final String PATH_PREFIX = "/temporary_listen_address/";
    private static final RMConstants wsrmConstants = RMProvider.get().getConstants();
    private final RMConfig wsrmConfig;
    private final boolean addressableClient;
    private final Set<Long> acknowledgedOutboundMessages = new TreeSet<Long>();
    private final Set<Long> receivedInboundMessages = new TreeSet<Long>();
    private RMIncompleteSequenceBehavior behavior = RMIncompleteSequenceBehavior.NO_DISCARD;
    private String incomingSequenceId;
    private String outgoingSequenceId;
    private long duration = -1L;
    private long creationTime;
    private URI backPort;
    private ClientImpl client;
    private boolean isFinal;
    private AtomicBoolean inboundMessageAckRequested = new AtomicBoolean();
    private AtomicLong messageNumber = new AtomicLong();
    private AtomicInteger countOfUnassignedMessagesAvailable = new AtomicInteger();
    private static final String ANONYMOUS_URI = AddressingBuilder.getAddressingBuilder().newAddressingConstants().getAnonymousURI();

    public RMClientSequence(RMConfig wsrmConfig) {
        if (wsrmConfig == null) {
            throw new RMException("WS-RM configuration missing");
        }
        this.wsrmConfig = wsrmConfig;
        boolean bl = this.addressableClient = wsrmConfig.getBackPortsServer() != null;
        if (this.addressableClient) {
            try {
                String host = wsrmConfig.getBackPortsServer().getHost();
                if (host == null) {
                    host = InetAddress.getLocalHost().getCanonicalHostName();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Backports server configuration omits host configuration - using autodetected " + host));
                    }
                }
                String port = wsrmConfig.getBackPortsServer().getPort();
                String path = PATH_PREFIX + UUIDGenerator.generateRandomUUIDString();
                this.backPort = new URI("http://" + host + ":" + port + path);
            }
            catch (URISyntaxException use) {
                logger.warn((Object)use);
                throw new RMException(use.getMessage(), use);
            }
            catch (UnknownHostException uhe) {
                logger.warn((Object)uhe);
                throw new RMException(uhe.getMessage(), uhe);
            }
        }
    }

    @Override
    public void unassignedMessageReceived() {
        this.countOfUnassignedMessagesAvailable.addAndGet(1);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Expected sequence expiration in " + (System.currentTimeMillis() - this.creationTime) / 1000L + "seconds"));
            logger.debug((Object)"Unassigned message available in callback handler");
        }
    }

    public final RMConfig getRMConfig() {
        return this.wsrmConfig;
    }

    @Override
    public final Set<Long> getReceivedInboundMessages() {
        return this.receivedInboundMessages;
    }

    public final BindingProvider getBindingProvider() {
        return this.client;
    }

    public final void setFinal() {
        this.isFinal = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sequence " + this.outgoingSequenceId + " state changed to final"));
        }
    }

    public final void ackRequested(boolean requested) {
        this.inboundMessageAckRequested.set(requested);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Inbound Sequence: " + this.incomingSequenceId + ", ack requested. Messages in the queue: " + this.receivedInboundMessages));
        }
    }

    public final boolean isAckRequested() {
        return this.inboundMessageAckRequested.get();
    }

    public final void addReceivedInboundMessage(long messageId) {
        this.receivedInboundMessages.add(messageId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Inbound Sequence: " + this.incomingSequenceId + ", received message no. " + messageId));
        }
    }

    public final void addReceivedOutboundMessage(long messageId) {
        this.acknowledgedOutboundMessages.add(messageId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Outbound Sequence: " + this.outgoingSequenceId + ", message no. " + messageId + " acknowledged by server"));
        }
    }

    public final void setOutboundId(String outboundId) {
        this.outgoingSequenceId = outboundId;
    }

    public final void setInboundId(String inboundId) {
        this.incomingSequenceId = inboundId;
    }

    public final void setClient(ClientImpl client) {
        this.client = client;
    }

    public final void setDuration(long duration) {
        if (duration > 0L) {
            this.creationTime = System.currentTimeMillis();
            this.duration = duration;
        }
    }

    @Override
    public final long getDuration() {
        return this.duration;
    }

    public final URI getBackPort() {
        return this.addressableClient ? this.backPort : null;
    }

    @Override
    public final String getAcksTo() {
        return this.addressableClient ? this.backPort.toString() : ANONYMOUS_URI;
    }

    @Override
    public final void setAcksTo(URI uri) {
        this.backPort = uri;
    }

    @Override
    public final long newMessageNumber() {
        return this.messageNumber.incrementAndGet();
    }

    @Override
    public final long getLastMessageNumber() {
        return this.messageNumber.get();
    }

    public final void close() throws RMException {
        this.sendCloseMessage();
        this.sendTerminateMessage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendMessage(String action, QName operationQName, List protocolMessages) throws RMException {
        try {
            try {
                String address = this.client.getEndpointMetaData().getEndpointAddress();
                AddressingProperties props = null;
                if (this.client.getWSRMSequence().getBackPort() != null) {
                    props = AddressingClientUtil.createDefaultProps(action, address);
                    props.setReplyTo(AddressingBuilder.getAddressingBuilder().newEndpointReference(this.client.getWSRMSequence().getBackPort()));
                } else {
                    props = AddressingClientUtil.createAnonymousProps(action, address);
                }
                Map requestContext = this.client.getBindingProvider().getRequestContext();
                HashMap<String, List> rmRequestContext = (HashMap<String, List>)requestContext.get("wsrm.requestContext");
                if (rmRequestContext == null) {
                    rmRequestContext = new HashMap<String, List>();
                }
                rmRequestContext.put("wsrm.protocolMessages", protocolMessages);
                rmRequestContext.put("wsrm.sequenceReference", (List)((Object)this));
                requestContext.put("javax.xml.ws.addressing.context.outbound", props);
                requestContext.put("wsrm.requestContext", rmRequestContext);
                this.client.invoke(operationQName, new Object[0], this.client.getBindingProvider().getResponseContext());
            }
            catch (Exception e) {
                throw new RMException("Unable to terminate WSRM sequence", e);
            }
            Object var9_9 = null;
            if (this.backPort == null) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (this.backPort == null) throw throwable;
            NettyHttpServer server = NettyHttpServerFactory.getNettyHttpServer(this.backPort.getPort(), RMRequestHandlerFactory.getInstance());
            NettyCallbackHandler callback = server.getCallback(this.backPort.getPath());
            server.unregisterCallback(callback);
            throw throwable;
        }
        NettyHttpServer server = NettyHttpServerFactory.getNettyHttpServer(this.backPort.getPort(), RMRequestHandlerFactory.getInstance());
        NettyCallbackHandler callback = server.getCallback(this.backPort.getPath());
        server.unregisterCallback(callback);
    }

    public final void sendCloseMessage() {
        if (RMProvider.get().getMessageFactory().newCloseSequence() != null) {
            while (this.isAckRequested()) {
                logger.debug((Object)"Waiting till all inbound sequence acknowledgements will be sent");
                this.sendSequenceAcknowledgementMessage();
            }
            HashMap<String, Boolean> wsrmReqCtx = new HashMap<String, Boolean>();
            wsrmReqCtx.put("wsrm.oneWayOperation", false);
            this.getBindingProvider().getRequestContext().put("wsrm.requestContext", wsrmReqCtx);
            LinkedList<QName> msgs = new LinkedList<QName>();
            msgs.add(wsrmConstants.getCloseSequenceQName());
            this.sendMessage(RMAddressingConstants.CLOSE_SEQUENCE_WSA_ACTION, wsrmConstants.getCloseSequenceQName(), msgs);
        }
    }

    public final void sendTerminateMessage() {
        LinkedList<QName> msgs = new LinkedList<QName>();
        msgs.add(wsrmConstants.getTerminateSequenceQName());
        if (this.getInboundId() != null) {
            msgs.add(wsrmConstants.getSequenceAcknowledgementQName());
        }
        HashMap<String, Boolean> wsrmReqCtx = new HashMap<String, Boolean>();
        boolean oneWayOperation = RMProvider.get().getMessageFactory().newTerminateSequenceResponse() == null;
        wsrmReqCtx.put("wsrm.oneWayOperation", oneWayOperation);
        this.getBindingProvider().getRequestContext().put("wsrm.requestContext", wsrmReqCtx);
        this.sendMessage(RMAddressingConstants.TERMINATE_SEQUENCE_WSA_ACTION, wsrmConstants.getTerminateSequenceQName(), msgs);
    }

    public final void sendSequenceAcknowledgementMessage() {
        HashMap<String, Boolean> wsrmReqCtx = new HashMap<String, Boolean>();
        wsrmReqCtx.put("wsrm.oneWayOperation", true);
        this.getBindingProvider().getRequestContext().put("wsrm.requestContext", wsrmReqCtx);
        this.ackRequested(false);
        LinkedList<QName> msgs = new LinkedList<QName>();
        msgs.add(wsrmConstants.getSequenceAcknowledgementQName());
        this.sendMessage(RMAddressingConstants.SEQUENCE_ACKNOWLEDGEMENT_WSA_ACTION, wsrmConstants.getSequenceAcknowledgementQName(), msgs);
    }

    public final void setBehavior(RMIncompleteSequenceBehavior behavior) {
        if (behavior != null) {
            this.behavior = behavior;
        }
    }

    @Override
    public final String getOutboundId() {
        return this.outgoingSequenceId;
    }

    @Override
    public final String getInboundId() {
        return this.incomingSequenceId;
    }
}

