/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.soap.Use;
import org.jboss.ws.extensions.addressing.AddressingPropertiesImpl;
import org.jboss.ws.extensions.addressing.metadata.AddressingOpMetaExt;
import org.jboss.ws.extensions.eventing.EventingUtils;
import org.jboss.ws.extensions.eventing.metadata.EventingEpMetaExt;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSESecurityMetaData;
import org.jboss.wsf.spi.metadata.j2ee.MDBMetaData;

public abstract class MetaDataBuilder {
    private static final Logger log = Logger.getLogger(MetaDataBuilder.class);

    protected void initEndpointBinding(WSDLEndpoint wsdlEndpoint, EndpointMetaData epMetaData) {
        WSDLDefinitions wsdlDefinitions = wsdlEndpoint.getWsdlService().getWsdlDefinitions();
        WSDLInterface wsdlInterface = wsdlEndpoint.getInterface();
        WSDLBinding wsdlBinding = wsdlDefinitions.getBindingByInterfaceName(wsdlInterface.getName());
        this.initEndpointBinding(wsdlBinding, epMetaData);
    }

    protected void initEndpointBinding(WSDLBinding wsdlBinding, EndpointMetaData epMetaData) {
        String bindingType = wsdlBinding.getType();
        if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(bindingType)) {
            epMetaData.setBindingId("http://schemas.xmlsoap.org/wsdl/soap/http");
        } else if ("http://schemas.xmlsoap.org/wsdl/soap12/".equals(bindingType)) {
            epMetaData.setBindingId("http://www.w3.org/2003/05/soap/bindings/HTTP/");
        }
    }

    protected void initEndpointEncodingStyle(EndpointMetaData epMetaData) {
        WSDLDefinitions wsdlDefinitions = epMetaData.getServiceMetaData().getWsdlDefinitions();
        for (WSDLService wsdlService : wsdlDefinitions.getServices()) {
            for (WSDLEndpoint wsdlEndpoint : wsdlService.getEndpoints()) {
                if (!epMetaData.getPortName().equals(wsdlEndpoint.getName())) continue;
                QName bindQName = wsdlEndpoint.getBinding();
                WSDLBinding wsdlBinding = wsdlDefinitions.getBinding(bindQName);
                if (wsdlBinding == null) {
                    throw new WSException("Cannot obtain binding: " + bindQName);
                }
                for (WSDLBindingOperation wsdlBindingOperation : wsdlBinding.getOperations()) {
                    String encStyle = wsdlBindingOperation.getEncodingStyle();
                    epMetaData.setEncodingStyle(Use.valueOf(encStyle));
                }
            }
        }
    }

    protected void initEndpointAddress(Deployment dep, ServerEndpointMetaData sepMetaData) {
        Integer port;
        Endpoint endpoint;
        String contextRoot = dep.getService().getContextRoot();
        String urlPattern = null;
        String linkName = sepMetaData.getLinkName();
        if (linkName != null && (endpoint = dep.getService().getEndpointByName(linkName)) != null) {
            urlPattern = endpoint.getURLPattern();
        }
        if ((port = (Integer)dep.getService().getProperty("port")) == null) {
            port = -1;
        }
        if (contextRoot == null) {
            String simpleName = dep.getSimpleName();
            contextRoot = simpleName.substring(0, simpleName.indexOf(46));
            if (dep instanceof ArchiveDeployment && ((ArchiveDeployment)dep).getParent() != null) {
                simpleName = ((ArchiveDeployment)dep).getParent().getSimpleName();
                simpleName = simpleName.substring(0, simpleName.indexOf(46));
                contextRoot = simpleName + "-" + contextRoot;
            }
        }
        if (urlPattern == null) {
            urlPattern = "/*";
        }
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        if (!urlPattern.startsWith("/")) {
            urlPattern = "/" + urlPattern;
        }
        sepMetaData.setContextRoot(contextRoot);
        sepMetaData.setURLPattern(urlPattern);
        String servicePath = contextRoot + urlPattern;
        sepMetaData.setEndpointAddress(MetaDataBuilder.getServiceEndpointAddress(null, servicePath, port));
    }

    public static ObjectName createServiceEndpointID(Deployment dep, ServerEndpointMetaData sepMetaData) {
        String linkName = sepMetaData.getLinkName();
        String context = sepMetaData.getContextRoot();
        if (context.startsWith("/")) {
            context = context.substring(1);
        }
        StringBuilder idstr = new StringBuilder("jboss.ws:");
        idstr.append("context=" + context);
        idstr.append(",endpoint=" + linkName);
        EJBArchiveMetaData apMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class);
        if (apMetaData != null) {
            String ejbName = sepMetaData.getLinkName();
            if (ejbName == null) {
                throw new WSException("Cannot obtain ejb-link from port component");
            }
            EJBMetaData beanMetaData = apMetaData.getBeanByEjbName(ejbName);
            if (beanMetaData == null) {
                throw new WSException("Cannot obtain ejb meta data for: " + ejbName);
            }
            if (beanMetaData instanceof MDBMetaData) {
                MDBMetaData mdMetaData = (MDBMetaData)beanMetaData;
                String jndiName = mdMetaData.getDestinationJndiName();
                idstr.append(",jms=" + jndiName);
            }
        }
        return ObjectNameFactory.create((String)idstr.toString());
    }

    public static String getServiceEndpointAddress(String uriScheme, String servicePath, int servicePort) {
        int portNo;
        if (servicePath == null || servicePath.length() == 0) {
            throw new WSException("Service path cannot be null");
        }
        if (servicePath.endsWith("/*")) {
            servicePath = servicePath.substring(0, servicePath.length() - 2);
        }
        if (uriScheme == null) {
            uriScheme = "http";
        }
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        ServerConfig config = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
        String host = config.getWebServiceHost();
        String port = "";
        if (servicePort != -1) {
            port = ":" + servicePort;
        } else if ("https".equals(uriScheme)) {
            portNo = config.getWebServiceSecurePort();
            if (portNo != 443) {
                port = ":" + portNo;
            }
        } else {
            portNo = config.getWebServicePort();
            if (portNo != 80) {
                port = ":" + portNo;
            }
        }
        String urlStr = uriScheme + "://" + host + port + servicePath;
        try {
            return new URL(urlStr).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new WSException("Malformed URL: " + urlStr);
        }
    }

    protected void initTransportGuaranteeJSE(Deployment dep, ServerEndpointMetaData sepMetaData, String servletLink) throws IOException {
        String transportGuarantee = null;
        JSEArchiveMetaData webMetaData = (JSEArchiveMetaData)dep.getAttachment(JSEArchiveMetaData.class);
        if (webMetaData != null) {
            Map servletMappings = webMetaData.getServletMappings();
            String urlPattern = (String)servletMappings.get(servletLink);
            if (urlPattern == null) {
                throw new WSException("Cannot find <url-pattern> for servlet-name: " + servletLink);
            }
            List securityList = webMetaData.getSecurityMetaData();
            for (JSESecurityMetaData currentSecurity : securityList) {
                if (currentSecurity.getTransportGuarantee() == null || currentSecurity.getTransportGuarantee().length() <= 0) continue;
                for (JSESecurityMetaData.JSEResourceCollection currentCollection : currentSecurity.getWebResources()) {
                    for (String currentUrlPattern : currentCollection.getUrlPatterns()) {
                        if (!urlPattern.equals(currentUrlPattern) && !"/*".equals(currentUrlPattern)) continue;
                        transportGuarantee = currentSecurity.getTransportGuarantee();
                    }
                }
            }
        }
        sepMetaData.setTransportGuarantee(transportGuarantee);
    }

    public static void replaceAddressLocation(ServerEndpointMetaData sepMetaData) {
        WSDLDefinitions wsdlDefinitions = sepMetaData.getServiceMetaData().getWsdlDefinitions();
        QName portName = sepMetaData.getPortName();
        boolean endpointFound = false;
        for (WSDLService wsdlService : wsdlDefinitions.getServices()) {
            for (WSDLEndpoint wsdlEndpoint : wsdlService.getEndpoints()) {
                QName wsdlPortName = wsdlEndpoint.getName();
                if (!wsdlPortName.equals(portName)) continue;
                endpointFound = true;
                String orgAddress = wsdlEndpoint.getAddress();
                String uriScheme = MetaDataBuilder.getUriScheme(orgAddress);
                String transportGuarantee = sepMetaData.getTransportGuarantee();
                if ("CONFIDENTIAL".equals(transportGuarantee)) {
                    uriScheme = "https";
                }
                if (MetaDataBuilder.requiresRewrite(orgAddress, uriScheme)) {
                    String servicePath = sepMetaData.getContextRoot() + sepMetaData.getURLPattern();
                    String serviceEndpointURL = MetaDataBuilder.getServiceEndpointAddress(uriScheme, servicePath, -1);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Replace service endpoint address '" + orgAddress + "' with '" + serviceEndpointURL + "'"));
                    }
                    wsdlEndpoint.setAddress(serviceEndpointURL);
                    sepMetaData.setEndpointAddress(serviceEndpointURL);
                    if (wsdlDefinitions.getWsdlOneOneDefinition() == null) continue;
                    MetaDataBuilder.replaceWSDL11PortAddress(wsdlDefinitions, portName, serviceEndpointURL);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Don't replace service endpoint address '" + orgAddress + "'"));
                }
                try {
                    sepMetaData.setEndpointAddress(new URL(orgAddress).toExternalForm());
                }
                catch (MalformedURLException e) {
                    log.warn((Object)("Malformed URL: " + orgAddress));
                    sepMetaData.setEndpointAddress(orgAddress);
                }
            }
        }
        if (!endpointFound) {
            throw new WSException("Cannot find port in wsdl: " + portName);
        }
    }

    private static boolean requiresRewrite(String orgAddress, String uriScheme) {
        if (uriScheme != null && !uriScheme.toLowerCase().startsWith("http")) {
            return false;
        }
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        ServerConfig config = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
        boolean alwaysModify = config.isModifySOAPAddress();
        return alwaysModify || uriScheme == null || orgAddress.indexOf("REPLACE_WITH_ACTUAL_URL") >= 0;
    }

    private static void replaceWSDL11PortAddress(WSDLDefinitions wsdlDefinitions, QName portQName, String serviceEndpointURL) {
        Definition wsdlOneOneDefinition = wsdlDefinitions.getWsdlOneOneDefinition();
        String tnsURI = wsdlOneOneDefinition.getTargetNamespace();
        if (MetaDataBuilder.modifyPortAddress(tnsURI, portQName, serviceEndpointURL, wsdlOneOneDefinition.getServices())) {
            return;
        }
        if (!wsdlOneOneDefinition.getImports().isEmpty()) {
            for (List l : wsdlOneOneDefinition.getImports().values()) {
                for (Import anImport : l) {
                    if (!MetaDataBuilder.modifyPortAddress(anImport.getNamespaceURI(), portQName, serviceEndpointURL, anImport.getDefinition().getServices())) continue;
                    return;
                }
            }
        }
        throw new IllegalArgumentException("Cannot find port with name '" + portQName + "' in wsdl document");
    }

    private static boolean modifyPortAddress(String tnsURI, QName portQName, String serviceEndpointURL, Map services) {
        for (Service wsdlOneOneService : services.values()) {
            Map wsdlOneOnePorts = wsdlOneOneService.getPorts();
            for (String portLocalName : wsdlOneOnePorts.keySet()) {
                if (!portQName.equals(new QName(tnsURI, portLocalName))) continue;
                Port wsdlOneOnePort = (Port)wsdlOneOnePorts.get(portLocalName);
                List extElements = wsdlOneOnePort.getExtensibilityElements();
                for (Object extElement : extElements) {
                    SOAPAddress address;
                    if (extElement instanceof SOAPAddress) {
                        address = (SOAPAddress)extElement;
                        address.setLocationURI(serviceEndpointURL);
                        continue;
                    }
                    if (extElement instanceof SOAP12Address) {
                        address = (SOAP12Address)extElement;
                        address.setLocationURI(serviceEndpointURL);
                        continue;
                    }
                    if (!(extElement instanceof HTTPAddress)) continue;
                    address = (HTTPAddress)extElement;
                    address.setLocationURI(serviceEndpointURL);
                }
                return true;
            }
        }
        return false;
    }

    private static String getUriScheme(String addrStr) {
        try {
            URI addrURI = new URI(addrStr);
            String scheme = addrURI.getScheme();
            return scheme;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    protected void processEndpointMetaDataExtensions(EndpointMetaData epMetaData, WSDLDefinitions wsdlDefinitions) {
        for (WSDLInterface wsdlInterface : wsdlDefinitions.getInterfaces()) {
            WSDLProperty eventSourceProp = wsdlInterface.getProperty("http://www.jboss.org/jbossws/wse/isEventSource");
            if (eventSourceProp == null || !(epMetaData instanceof ServerEndpointMetaData)) continue;
            ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)epMetaData;
            String eventSourceNS = wsdlInterface.getName().getNamespaceURI() + "/" + wsdlInterface.getName().getLocalPart();
            JBossXSModel schemaModel = WSDLUtils.getSchemaModel(wsdlDefinitions.getWsdlTypes());
            String[] notificationSchema = EventingUtils.extractNotificationSchema(schemaModel);
            String notificationRootElementNS = null;
            WSDLInterfaceOperation wsdlInterfaceOperation = wsdlInterface.getOperations()[0];
            if (wsdlInterfaceOperation.getOutputs().length <= 0) {
                throw new WSException("Unable to resolve eventing root element NS. No operation output found at " + wsdlInterfaceOperation.getName());
            }
            WSDLInterfaceOperationOutput wsdlInterfaceOperationOutput = wsdlInterfaceOperation.getOutputs()[0];
            notificationRootElementNS = wsdlInterfaceOperationOutput.getElement().getNamespaceURI();
            EventingEpMetaExt ext = new EventingEpMetaExt("http://schemas.xmlsoap.org/ws/2004/08/eventing");
            ext.setEventSourceNS(eventSourceNS);
            ext.setNotificationSchema(notificationSchema);
            ext.setNotificationRootElementNS(notificationRootElementNS);
            sepMetaData.addExtension(ext);
        }
    }

    protected void processOpMetaExtensions(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation) {
        String tns = wsdlOperation.getName().getNamespaceURI();
        String portTypeName = wsdlOperation.getName().getLocalPart();
        AddressingPropertiesImpl ADDR = new AddressingPropertiesImpl();
        AddressingOpMetaExt addrExt = new AddressingOpMetaExt(ADDR.getNamespaceURI());
        WSDLProperty wsaInAction = wsdlOperation.getProperty("http://www.jboss.org/jbossws/wsa/actionIn");
        if (wsaInAction != null) {
            addrExt.setInboundAction(wsaInAction.getValue());
        } else {
            WSDLProperty messageName = wsdlOperation.getProperty("http://www.jboss.org/jbossws/messagename/in");
            if (messageName != null) {
                addrExt.setInboundAction(tns + "/" + portTypeName + "/" + messageName.getValue());
            } else {
                addrExt.setInboundAction(tns + "/" + portTypeName + "/IN");
            }
        }
        WSDLProperty wsaOutAction = wsdlOperation.getProperty("http://www.jboss.org/jbossws/wsa/actionOut");
        if (wsaOutAction != null) {
            addrExt.setOutboundAction(wsaOutAction.getValue());
        } else {
            WSDLProperty messageName = wsdlOperation.getProperty("http://www.jboss.org/jbossws/messagename/out");
            if (messageName != null) {
                addrExt.setOutboundAction(tns + "/" + portTypeName + "/" + messageName.getValue());
            } else {
                addrExt.setOutboundAction(tns + "/" + portTypeName + "/OUT");
            }
        }
        opMetaData.addExtension(addrExt);
    }
}

