/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import org.hibernate.engine.jdbc.JdbcSupport;
import org.hibernate.engine.jdbc.JdbcSupportImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSupportLoader {
    private static final Logger log = LoggerFactory.getLogger((Class)JdbcSupportLoader.class);
    private static final Class[] NO_ARG_SIG = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];

    public static JdbcSupport loadJdbcSupport(Connection jdbcConnection) {
        return new JdbcSupportImpl(JdbcSupportLoader.useContextualLobCreation(jdbcConnection));
    }

    private static boolean useContextualLobCreation(Connection jdbcConnection) {
        block7: {
            if (jdbcConnection == null) {
                return false;
            }
            try {
                Class connectionClass = Connection.class;
                Method createClobMethod = connectionClass.getMethod("createClob", NO_ARG_SIG);
                if (!createClobMethod.getDeclaringClass().equals(Connection.class)) break block7;
                try {
                    Object clob = createClobMethod.invoke((Object)jdbcConnection, NO_ARGS);
                    try {
                        Method freeMethod = clob.getClass().getMethod("free", NO_ARG_SIG);
                        freeMethod.invoke(clob, NO_ARGS);
                    }
                    catch (Throwable ignore) {
                        log.trace("Unable to free CLOB created to test createClob() implementation : " + ignore);
                    }
                    return true;
                }
                catch (Throwable t) {
                    log.info("createClob() method threw error : " + t);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }
}

