/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.agent.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginDependencyGraph {
    private static final Log log = LogFactory.getLog(PluginDependencyGraph.class);
    private Map<String, List<PluginDependency>> dependencyMap = new HashMap<String, List<PluginDependency>>();

    public void addPlugin(String pluginName, List<PluginDependency> dependencies) {
        dependencies.remove(new PluginDependency(pluginName, false, false));
        this.dependencyMap.put(pluginName, dependencies);
    }

    public String getUseClassesDependency(String pluginName) {
        PluginDependency last = null;
        if (this.dependencyMap.containsKey(pluginName)) {
            for (PluginDependency dependency : this.dependencyMap.get(pluginName)) {
                if (!dependency.required) continue;
                if (dependency.useClasses) {
                    return dependency.name;
                }
                last = dependency;
            }
        }
        return last == null ? null : last.name;
    }

    public Set<String> getPlugins() {
        return new HashSet<String>(this.dependencyMap.keySet());
    }

    public List<String> getPluginDependencies(String pluginName) {
        ArrayList<String> dependencies = new ArrayList<String>();
        for (PluginDependency dependency : this.dependencyMap.get(pluginName)) {
            if (!dependency.required && !this.dependencyMap.containsKey(dependency.name)) continue;
            dependencies.add(dependency.name);
        }
        return dependencies;
    }

    public List<String> getOptionalDependents(String pluginName) {
        ArrayList<String> dependents = new ArrayList<String>();
        block0: for (Map.Entry<String, List<PluginDependency>> entry : this.dependencyMap.entrySet()) {
            if (entry.getKey().equals(pluginName)) continue;
            for (PluginDependency dependency : entry.getValue()) {
                if (dependency.required || !dependency.name.equals(pluginName)) continue;
                dependents.add(entry.getKey());
                continue block0;
            }
        }
        return dependents;
    }

    public boolean isComplete(StringBuilder errorBuffer) throws IllegalStateException {
        try {
            this.getDeploymentOrder();
            return true;
        }
        catch (IllegalArgumentException e) {
            if (errorBuffer != null) {
                errorBuffer.append(e.getMessage());
            }
            return false;
        }
    }

    public List<String> getDeploymentOrder() throws IllegalStateException, IllegalArgumentException {
        ArrayList<PluginItem> pluginItems = new ArrayList<PluginItem>();
        for (String pluginName : new TreeSet<String>(this.dependencyMap.keySet())) {
            pluginItems.add(new PluginItem(pluginName, this.getDeepDependencies(pluginName, new ArrayList<String>(), true)));
        }
        ArrayList<String> retList = new ArrayList<String>(pluginItems.size());
        for (PluginItem pluginItem : pluginItems) {
            int insertIndex = 0;
            for (String dependency : pluginItem.deepDependencies) {
                int dependencyIndex = retList.indexOf(dependency);
                if (dependencyIndex <= -1 || insertIndex >= dependencyIndex + 1) continue;
                insertIndex = dependencyIndex + 1;
            }
            retList.add(insertIndex, pluginItem.name);
        }
        return retList;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Plugin dependency graph:");
        for (Map.Entry<String, List<PluginDependency>> entry : this.dependencyMap.entrySet()) {
            str.append("\n");
            str.append(entry.getKey());
            str.append(":");
            str.append(entry.getValue());
        }
        return str.toString();
    }

    private Set<String> getDeepDependencies(String pluginName, Collection<String> dependingPlugins, boolean required) throws IllegalStateException, IllegalArgumentException {
        HashSet<String> results = new HashSet<String>();
        List<PluginDependency> childDependencies = this.dependencyMap.get(pluginName);
        if (childDependencies == null) {
            if (required) {
                throw new IllegalArgumentException("Plugin [" + pluginName + "] is required by plugins [" + dependingPlugins + "] but it does not exist in the dependency graph yet");
            }
            log.info((Object)("Optional plugin [" + pluginName + "] was requested by plugins [" + dependingPlugins + "] but it does not exist in the dependency graph yet and will be ignored"));
        } else {
            for (PluginDependency childDependency : childDependencies) {
                if (dependingPlugins.contains(childDependency.name)) {
                    throw this.createCircularDependencyException(childDependency.name);
                }
                dependingPlugins.add(pluginName);
                Set<String> childDeepDependencies = this.getDeepDependencies(childDependency.name, dependingPlugins, childDependency.required);
                dependingPlugins.remove(pluginName);
                results.add(childDependency.name);
                results.addAll(childDeepDependencies);
            }
        }
        return results;
    }

    private IllegalStateException createCircularDependencyException(String badPlugin) {
        StringBuffer err = new StringBuffer("Circular dependency detected in plugins!\n");
        err.append("Plugin with the circular dependency is [" + badPlugin + "]\n");
        err.append("Circular dependency path is [");
        err.append(this.getCircularDependencyString(badPlugin, new ArrayList<String>()));
        err.append("]\n");
        err.append(this.toString());
        return new IllegalStateException(err.toString());
    }

    private String getCircularDependencyString(String startPlugin, List<String> path) {
        boolean gotIt = path.contains(startPlugin);
        if (!gotIt) {
            path.add(startPlugin);
            List<PluginDependency> deps = this.dependencyMap.get(startPlugin);
            for (PluginDependency dep : deps) {
                ArrayList<String> tmpPath = new ArrayList<String>(path);
                String str = this.getCircularDependencyString(dep.name, tmpPath);
                if (str == null) continue;
                return str;
            }
            return null;
        }
        StringBuffer retPath = new StringBuffer();
        for (String pathElement : path) {
            retPath.append(pathElement);
            retPath.append("->");
        }
        retPath.append(startPlugin);
        path.add(startPlugin);
        return retPath.toString();
    }

    public static class PluginDependency {
        final String name;
        final boolean useClasses;
        final boolean required;

        public PluginDependency(String name) {
            this(name, false, false);
        }

        public PluginDependency(String name, boolean useClasses, boolean required) {
            this.name = name;
            this.useClasses = useClasses;
            this.required = required;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginDependency that = (PluginDependency)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "name=[" + this.name + "], required=[" + this.required + "], useClasses=[" + this.useClasses + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PluginItem {
        final String name;
        final Set<String> deepDependencies;

        PluginItem(String name, Set<String> deepDependencies) {
            this.name = name;
            this.deepDependencies = deepDependencies;
        }

        public String toString() {
            return this.name + ':' + this.deepDependencies;
        }
    }
}

