/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.serialization;

import java.io.StreamCorruptedException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.codec.serialization.CompactObjectInputStream;

public class ObjectDecoder
extends FrameDecoder {
    private final int maxObjectSize;
    private final ClassLoader classLoader;

    public ObjectDecoder() {
        this(0x100000);
    }

    public ObjectDecoder(int maxObjectSize) {
        this(maxObjectSize, null);
    }

    public ObjectDecoder(int maxObjectSize, ClassLoader classLoader) {
        if (maxObjectSize <= 0) {
            throw new IllegalArgumentException("maxObjectSize: " + maxObjectSize);
        }
        this.maxObjectSize = maxObjectSize;
        this.classLoader = classLoader;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < 4) {
            return null;
        }
        int dataLen = buffer.getInt(buffer.readerIndex());
        if (dataLen <= 0) {
            throw new StreamCorruptedException("invalid data length: " + dataLen);
        }
        if (dataLen > this.maxObjectSize) {
            throw new StreamCorruptedException("data length too big: " + dataLen + " (max: " + this.maxObjectSize + ')');
        }
        if (buffer.readableBytes() < dataLen + 4) {
            return null;
        }
        buffer.skipBytes(4);
        return new CompactObjectInputStream(new ChannelBufferInputStream(buffer, dataLen), this.classLoader).readObject();
    }
}

