/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.UnproxyableResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.interceptor.model.InterceptionModel;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.DeploymentException;
import org.jboss.weld.InconsistentSpecializationException;
import org.jboss.weld.NullableDependencyException;
import org.jboss.weld.UnserializableDependencyException;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.NewManagedBean;
import org.jboss.weld.bean.NewSessionBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.introspector.WeldAnnotated;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.ResolvableWeldClass;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator
implements Service {
    private void validateBean(Bean<?> bean, BeanManagerImpl beanManager) {
        for (InjectionPoint ij : bean.getInjectionPoints()) {
            this.validateInjectionPoint(ij, beanManager);
        }
        boolean normalScoped = ((MetaAnnotationStore)beanManager.getServices().get(MetaAnnotationStore.class)).getScopeModel(bean.getScope()).isNormal();
        if (normalScoped && !Beans.isBeanProxyable(bean)) {
            throw new UnproxyableResolutionException("Normal scoped bean " + bean + " is not proxyable");
        }
    }

    private void validateRIBean(RIBean<?> bean, BeanManagerImpl beanManager, Collection<RIBean<?>> specializedBeans) {
        this.validateBean(bean, beanManager);
        if (!(bean instanceof NewManagedBean) && !(bean instanceof NewSessionBean)) {
            RIBean<?> abstractBean = bean;
            if (abstractBean.isSpecializing()) {
                if (specializedBeans.contains(abstractBean.getSpecializedBean())) {
                    throw new InconsistentSpecializationException("Two beans cannot specialize the same bean: " + bean);
                }
                specializedBeans.add(abstractBean.getSpecializedBean());
            }
            if (Beans.isPassivationCapableBean(bean) && bean instanceof AbstractClassBean) {
                AbstractClassBean classBean = (AbstractClassBean)bean;
                if (classBean.hasDecorators()) {
                    this.validateDecorators(beanManager, classBean);
                }
                if (classBean.hasCdiBoundInterceptors()) {
                    this.validateCdiBoundInterceptors(beanManager, classBean);
                }
                if (((AbstractClassBean)bean).hasDirectlyDefinedInterceptors()) {
                    this.validateDirectlyDefinedInterceptorClasses(beanManager, classBean);
                }
            }
        }
    }

    private void validateDirectlyDefinedInterceptorClasses(BeanManagerImpl beanManager, AbstractClassBean<?> classBean) {
        Class[] classDeclaredInterceptors;
        InterceptionModel ejbInterceptorModel = beanManager.getClassDeclaredInterceptorsRegistry().getInterceptionModel(classBean.getType());
        if (ejbInterceptorModel != null && (classDeclaredInterceptors = ejbInterceptorModel.getAllInterceptors().toArray(new Class[ejbInterceptorModel.getAllInterceptors().size()])) != null) {
            for (Class interceptorClass : classDeclaredInterceptors) {
                if (!Reflections.isSerializable(interceptorClass)) {
                    throw new DeploymentException("The bean " + this + " declared a passivating scope, " + "but has a non-serializable interceptor class: " + interceptorClass.getName());
                }
                InjectionTarget injectionTarget = beanManager.createInjectionTarget(beanManager.createAnnotatedType(interceptorClass));
                for (InjectionPoint injectionPoint : injectionTarget.getInjectionPoints()) {
                    Bean resolvedBean = beanManager.resolve(beanManager.getInjectableBeans(injectionPoint));
                    this.validateInjectionPointPassivationCapable(injectionPoint, resolvedBean, beanManager);
                }
            }
        }
    }

    private void validateCdiBoundInterceptors(BeanManagerImpl beanManager, AbstractClassBean<?> classBean) {
        Set interceptors;
        InterceptionModel cdiInterceptorModel = beanManager.getCdiInterceptorsRegistry().getInterceptionModel(classBean.getType());
        if (cdiInterceptorModel != null && (interceptors = cdiInterceptorModel.getAllInterceptors()).size() > 0) {
            for (SerializableContextual serializableContextual : interceptors) {
                if (!Reflections.isSerializable(((Interceptor)serializableContextual.get()).getBeanClass())) {
                    throw new DeploymentException("The bean " + this + " declared a passivating scope " + "but has a non-serializable interceptor: " + serializableContextual.get());
                }
                for (InjectionPoint injectionPoint : ((Interceptor)serializableContextual.get()).getInjectionPoints()) {
                    Bean resolvedBean = beanManager.resolve(beanManager.getInjectableBeans(injectionPoint));
                    this.validateInjectionPointPassivationCapable(injectionPoint, resolvedBean, beanManager);
                }
            }
        }
    }

    private void validateDecorators(BeanManagerImpl beanManager, AbstractClassBean<?> classBean) {
        for (Decorator<?> decorator : classBean.getDecorators()) {
            if (!Reflections.isSerializable(decorator.getBeanClass())) {
                throw new UnserializableDependencyException("The bean " + classBean + " declares a passivating scope but has non-serializable decorator: " + decorator);
            }
            for (InjectionPoint ij : decorator.getInjectionPoints()) {
                Bean resolvedBean = beanManager.resolve(beanManager.getInjectableBeans(ij));
                this.validateInjectionPointPassivationCapable(ij, resolvedBean, beanManager);
            }
        }
    }

    public void validateInjectionPoint(InjectionPoint ij, BeanManagerImpl beanManager) {
        if (ij.getAnnotated().getAnnotation(New.class) != null && ij.getQualifiers().size() > 1) {
            throw new DefinitionException("The injection point " + ij + " is annotated with @New which cannot be combined with other binding types");
        }
        if (ij.getType().equals(InjectionPoint.class) && ij.getBean() == null) {
            throw new DefinitionException("Cannot inject an Injection point into a class which isn't a bean " + ij);
        }
        if (ij.getType().equals(InjectionPoint.class) && !Dependent.class.equals((Object)ij.getBean().getScope())) {
            throw new DefinitionException("Cannot inject an InjectionPoint into a non @Dependent scoped bean " + ij);
        }
        if (ij.getType() instanceof TypeVariable) {
            throw new DefinitionException("Cannot declare an injection point with a type variable " + ij);
        }
        Validator.checkFacadeInjectionPoint(ij, Instance.class);
        Validator.checkFacadeInjectionPoint(ij, Event.class);
        Object[] bindings = ij.getQualifiers().toArray(new Annotation[0]);
        WeldAnnotated annotatedItem = ResolvableWeldClass.of(ij.getType(), (Annotation[])bindings, beanManager);
        Set resolvedBeans = beanManager.getBeanResolver().resolve(beanManager.getInjectableBeans(ij));
        if (resolvedBeans.isEmpty()) {
            throw new DeploymentException("Injection point has unstatisfied dependencies. Injection point: " + ij.toString() + "; Qualifiers: " + Arrays.toString(bindings));
        }
        if (resolvedBeans.size() > 1) {
            throw new DeploymentException("Injection point has ambiguous dependencies. Injection point: " + ij.toString() + "; Qualifiers: " + Arrays.toString(bindings) + "; Possible dependencies: " + resolvedBeans);
        }
        Bean resolvedBean = resolvedBeans.iterator().next();
        if (((MetaAnnotationStore)beanManager.getServices().get(MetaAnnotationStore.class)).getScopeModel(resolvedBean.getScope()).isNormal() && !Proxies.isTypeProxyable(ij.getType())) {
            throw new UnproxyableResolutionException("The injection point " + ij + " has non-proxyable dependencies");
        }
        if (Reflections.isPrimitive(annotatedItem.getJavaClass()) && resolvedBean.isNullable()) {
            throw new NullableDependencyException("The injection point " + ij + " has nullable dependencies");
        }
        if (ij.getBean() != null && Beans.isPassivatingScope(ij.getBean(), beanManager) && !ij.isTransient() && !Beans.isPassivationCapableBean(resolvedBean)) {
            this.validateInjectionPointPassivationCapable(ij, resolvedBean, beanManager);
        }
    }

    public void validateInjectionPointPassivationCapable(InjectionPoint ij, Bean<?> resolvedBean, BeanManagerImpl beanManager) {
        if (!ij.isTransient() && !Beans.isPassivationCapableBean(resolvedBean)) {
            if (resolvedBean.getScope().equals(Dependent.class) && resolvedBean instanceof AbstractProducerBean) {
                throw new IllegalProductException("The bean " + ij.getBean() + " declares a passivating scope but the producer returned a non-serializable bean for injection: " + resolvedBean);
            }
            throw new UnserializableDependencyException("The bean " + ij.getBean() + " declares a passivating scope but has non-serializable dependency: " + resolvedBean);
        }
    }

    public void validateDeployment(BeanManagerImpl manager, BeanDeployerEnvironment environment) {
        this.validateBeans(manager.getDecorators(), new ArrayList(), manager);
        this.validateBeans(manager.getBeans(), new ArrayList(), manager);
        this.validateEnabledDecoratorClasses(manager);
        this.validateEnabledInterceptorClasses(manager);
        this.validateEnabledPolicies(manager);
        this.validateDisposalMethods(environment);
        this.validateBeanNames(manager);
    }

    public void validateBeans(Collection<? extends Bean<?>> beans, Collection<RIBean<?>> specializedBeans, BeanManagerImpl manager) {
        for (Bean<?> bean : beans) {
            if (bean instanceof RIBean) {
                this.validateRIBean((RIBean)bean, manager, specializedBeans);
                continue;
            }
            this.validateBean(bean, manager);
        }
    }

    public void validateBeanNames(BeanManagerImpl beanManager) {
        SetMultimap namedAccessibleBeans = Multimaps.newSetMultimap(new HashMap(), (Supplier)new Supplier<Set<Bean<?>>>(){

            public Set<Bean<?>> get() {
                return new HashSet();
            }
        });
        for (Bean<?> bean : beanManager.getAccessibleBeans()) {
            if (bean.getName() == null) continue;
            namedAccessibleBeans.put((Object)bean.getName(), bean);
        }
        ArrayList<String> accessibleNamespaces = new ArrayList<String>();
        for (String namespace : beanManager.getAccessibleNamespaces()) {
            accessibleNamespaces.add(namespace);
        }
        for (String name : namedAccessibleBeans.keySet()) {
            Set resolvedBeans = beanManager.getBeanResolver().resolve(namedAccessibleBeans.get((Object)name));
            if (resolvedBeans.size() > 1) {
                throw new DeploymentException("An unresolvable ambiguous EL name exists for " + name + "; found " + resolvedBeans);
            }
            if (!accessibleNamespaces.contains(name)) continue;
            throw new DeploymentException("The bean name " + name + " is used as a prefix for another bean");
        }
    }

    private void validateEnabledInterceptorClasses(BeanManagerImpl beanManager) {
        HashSet<Class> interceptorBeanClasses = new HashSet<Class>();
        for (Interceptor<?> interceptor : beanManager.getInterceptors()) {
            interceptorBeanClasses.add(interceptor.getBeanClass());
        }
        for (Class clazz : beanManager.getEnabledInterceptorClasses()) {
            if (beanManager.getEnabledInterceptorClasses().indexOf(clazz) < beanManager.getEnabledInterceptorClasses().lastIndexOf(clazz)) {
                throw new DeploymentException("Enabled interceptor class" + clazz + " specified twice");
            }
            if (interceptorBeanClasses.contains(clazz)) continue;
            throw new DeploymentException("Enabled interceptor class " + clazz + " is neither annotated with @Interceptor, nor registered through a portable extension");
        }
    }

    private void validateEnabledDecoratorClasses(BeanManagerImpl beanManager) {
        HashSet<Class> decoratorBeanClasses = new HashSet<Class>();
        for (Decorator<?> decorator : beanManager.getDecorators()) {
            decoratorBeanClasses.add(decorator.getBeanClass());
        }
        for (Class clazz : beanManager.getEnabledDecoratorClasses()) {
            if (beanManager.getEnabledDecoratorClasses().indexOf(clazz) < beanManager.getEnabledDecoratorClasses().lastIndexOf(clazz)) {
                throw new DeploymentException("Enabled decorator class" + clazz + " specified twice");
            }
            if (decoratorBeanClasses.contains(clazz)) continue;
            throw new DeploymentException("Enabled decorator class " + clazz + " is not the bean class of at least one decorator bean (detected decorator beans " + decoratorBeanClasses + ")");
        }
    }

    private void validateEnabledPolicies(BeanManagerImpl beanManager) {
        ArrayList<Class<? extends Annotation>> seenPolicies = new ArrayList<Class<? extends Annotation>>();
        for (Class<? extends Annotation> clazz : beanManager.getEnabledPolicyStereotypes()) {
            if (!clazz.isAnnotationPresent(Alternative.class)) {
                throw new DeploymentException("Enabled policy sterotype " + clazz + " is not annotated @Policy");
            }
            if (seenPolicies.contains(clazz)) {
                throw new DeploymentException("Cannot enable the same policy sterotype " + clazz + " in beans.xml");
            }
            seenPolicies.add(clazz);
        }
        for (Class<Annotation> clazz : beanManager.getEnabledPolicyClasses()) {
            if (!clazz.isAnnotationPresent(Alternative.class)) {
                throw new DeploymentException("Enabled policy bean class " + clazz + " is not annotated @Policy");
            }
            if (seenPolicies.contains(clazz)) {
                throw new DeploymentException("Cannot enable the same policy bean class " + clazz + " in beans.xml");
            }
            seenPolicies.add(clazz);
        }
    }

    private void validateDisposalMethods(BeanDeployerEnvironment environment) {
        Set<DisposalMethod<?, ?>> beans = environment.getUnresolvedDisposalBeans();
        if (!beans.isEmpty()) {
            throw new DefinitionException("The following Disposal methods were declared but did not resolved to a producer method " + beans);
        }
    }

    private static void checkFacadeInjectionPoint(InjectionPoint injectionPoint, Class<?> type) {
        if (injectionPoint.getAnnotated().getBaseType().equals(type)) {
            if (injectionPoint.getType() instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)injectionPoint.getType();
                if (parameterizedType.getActualTypeArguments()[0] instanceof TypeVariable) {
                    throw new DefinitionException("An injection point of type " + type + " cannot have a type variable type parameter " + injectionPoint);
                }
                if (parameterizedType.getActualTypeArguments()[0] instanceof WildcardType) {
                    throw new DefinitionException("An injection point of type " + type + " cannot have a wildcard type parameter " + injectionPoint);
                }
            } else {
                throw new DefinitionException("An injection point of type " + type + " must have a type parameter " + injectionPoint);
            }
        }
    }

    public void cleanup() {
    }
}

