/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.Container;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.WeldException;
import org.jboss.weld.bean.proxy.ClientProxyMethodHandler;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.collections.ConcurrentCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProxyProvider {
    private static final long serialVersionUID = 9029999149357529341L;
    private final ConcurrentCache<Bean<? extends Object>, Object> pool = new ConcurrentCache();

    private static <T> T createClientProxy(Bean<T> bean, BeanManagerImpl manager, String id) throws RuntimeException {
        try {
            return Proxies.createProxy(new ClientProxyMethodHandler(bean, manager, id), Proxies.TypeInfo.of(bean.getTypes()).add((Type)((Object)Serializable.class)));
        }
        catch (InstantiationException e) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_FAILED, (Throwable)e, bean);
        }
        catch (IllegalAccessException e) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_BEAN_ACCESS_FAILED, (Throwable)e, bean);
        }
    }

    public <T> T getClientProxy(final BeanManagerImpl manager, final Bean<T> bean) {
        Object instance = this.pool.putIfAbsent(bean, new Callable<T>(){

            @Override
            public T call() throws Exception {
                String id = ((ContextualStore)Container.instance().deploymentServices().get(ContextualStore.class)).putIfAbsent((Contextual)bean);
                if (id == null) {
                    throw new DefinitionException(BeanMessage.BEAN_ID_CREATION_FAILED, bean);
                }
                return ClientProxyProvider.createClientProxy(bean, manager, id);
            }
        });
        return (T)instance;
    }

    public String toString() {
        return "Proxy pool with " + this.pool.size() + " proxies";
    }

    public void clear() {
        this.pool.clear();
    }
}

