/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource.cached;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DualLRUMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = -313747679711995782L;
    private Map<V, K> reverseMap;
    private int capacity;

    public DualLRUMap(int capacity) {
        super(capacity, 0.75f, true);
        this.capacity = capacity;
        this.reverseMap = new HashMap<V, K>(capacity, 0.75f);
    }

    @Override
    public V put(K key, V value) {
        V v = super.put(key, value);
        this.reverseMap.put(value, key);
        return v;
    }

    @Override
    public V remove(Object key) {
        Object value = super.remove(key);
        if (value != null) {
            this.reverseMap.remove(value);
        }
        return value;
    }

    public K getKey(Object value) {
        K key = this.reverseMap.get(value);
        if (key != null) {
            this.get(key);
        }
        return key;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        boolean remove;
        boolean bl = remove = this.size() > this.capacity;
        if (remove) {
            this.reverseMap.remove(eldest.getValue());
        }
        return remove;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(super.values());
    }
}

