/*
 * Decompiled with CFR 0.152.
 */
package org.jboss;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.jboss.bootstrap.api.server.Server;
import org.jboss.naming.HttpNamingContextFactory;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;

public class Shutdown {
    public static final String PROGRAM_NAME = System.getProperty("program.name", "shutdown");

    protected static void displayUsage() {
        System.out.println("A JMX client to shutdown (exit or halt) a remote JBoss server.");
        System.out.println();
        System.out.println("usage: " + PROGRAM_NAME + " [options] <operation>");
        System.out.println();
        System.out.println("options:");
        System.out.println("    -h, --help                Show this help message (default)");
        System.out.println("    -D<name>[=<value>]        Set a system property");
        System.out.println("    --                        Stop processing options");
        System.out.println("    -s, --server=<url>        Specify the JNDI URL of the remote server");
        System.out.println("    -n, --serverName=<url>    Specify the JMX name of the ServerImpl");
        System.out.println("    -a, --adapter=<name>      Specify JNDI name of the MBeanServerConnection to use");
        System.out.println("    -u, --user=<name>         Specify the username for authentication");
        System.out.println("    -p, --password=<name>     Specify the password for authentication");
        System.out.println();
        System.out.println("operations:");
        System.out.println("    -S, --shutdown            Shutdown the server");
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        InitialContext ctx;
        int code;
        if (args.length == 0) {
            Shutdown.displayUsage();
            System.exit(0);
        }
        String sopts = "-:hD:s:n:a:u:p:S";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("server", 1, null, 115), new LongOpt("adapter", 1, null, 97), new LongOpt("serverName", 1, null, 110), new LongOpt("shutdown", 0, null, 83), new LongOpt("user", 1, null, 117), new LongOpt("password", 1, null, 112)};
        Getopt getopt = new Getopt(PROGRAM_NAME, args, sopts, lopts);
        String serverURL = null;
        String adapterName = "jmx/rmi/RMIAdaptor";
        String username = null;
        String password = null;
        ObjectName serverJMXName = new ObjectName("jboss.system:type=Server");
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    System.exit(1);
                    break;
                }
                case 1: {
                    System.err.println(PROGRAM_NAME + ": unused non-option argument: " + getopt.getOptarg());
                    break;
                }
                case 104: {
                    Shutdown.displayUsage();
                    System.exit(0);
                    break;
                }
                case 68: {
                    String value;
                    String name;
                    String arg = getopt.getOptarg();
                    int i = arg.indexOf("=");
                    if (i == -1) {
                        name = arg;
                        value = "true";
                    } else {
                        name = arg.substring(0, i);
                        value = arg.substring(i + 1, arg.length());
                    }
                    System.setProperty(name, value);
                    break;
                }
                case 115: {
                    serverURL = getopt.getOptarg();
                    break;
                }
                case 110: {
                    serverJMXName = new ObjectName(getopt.getOptarg());
                    break;
                }
                case 83: {
                    break;
                }
                case 97: {
                    adapterName = getopt.getOptarg();
                    break;
                }
                case 117: {
                    username = getopt.getOptarg();
                    SecurityAssociation.setPrincipal((Principal)new SimplePrincipal(username));
                    break;
                }
                case 112: {
                    password = getopt.getOptarg();
                    SecurityAssociation.setCredential((Object)password);
                }
            }
        }
        if (username != null && password == null) {
            System.out.print("Enter password for " + username + ": ");
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            password = br.readLine();
            SecurityAssociation.setCredential((Object)password);
        }
        if (serverURL == null) {
            ctx = new InitialContext();
        } else {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.provider.url", serverURL);
            env.put("jnp.disableDiscovery", "true");
            if (serverURL.startsWith("http:") || serverURL.startsWith("https:")) {
                env.put("java.naming.factory.initial", HttpNamingContextFactory.class.getName());
            }
            ctx = new InitialContext(env);
        }
        Object obj = ctx.lookup(adapterName);
        if (!(obj instanceof MBeanServerConnection)) {
            throw new RuntimeException("Object not of type: MBeanServerConnection, but: " + (obj == null ? "not found" : obj.getClass().getName()));
        }
        MBeanServerConnection adaptor = (MBeanServerConnection)obj;
        ServerProxyHandler handler = new ServerProxyHandler(adaptor, serverJMXName);
        Class[] ifaces = new Class[]{Server.class};
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        Server server = (Server)Proxy.newProxyInstance(tcl, ifaces, (InvocationHandler)handler);
        server.shutdown();
        System.out.println("Shutdown message has been posted to the server.");
        System.out.println("Server shutdown may take a while - check logfiles for completion");
    }

    private static class ServerProxyHandler
    implements InvocationHandler {
        ObjectName serverName;
        MBeanServerConnection server;

        ServerProxyHandler(MBeanServerConnection server, ObjectName serverName) {
            this.server = server;
            this.serverName = serverName;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            Class<?>[] sigTypes = method.getParameterTypes();
            ArrayList<String> sigStrings = new ArrayList<String>();
            for (int s = 0; s < sigTypes.length; ++s) {
                sigStrings.add(sigTypes[s].getName());
            }
            String[] sig = new String[sigTypes.length];
            sigStrings.toArray(sig);
            Object value = null;
            try {
                value = this.server.invoke(this.serverName, methodName, args, sig);
            }
            catch (UndeclaredThrowableException e) {
                System.out.println("getUndeclaredThrowable: " + e.getUndeclaredThrowable());
                throw e.getUndeclaredThrowable();
            }
            return value;
        }
    }
}

