/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui;

import javax.faces.application.FacesMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.embedded.manager.ResourceManager;
import org.jboss.on.embedded.manager.ResourceManagerFactory;
import org.jboss.on.embedded.ui.NavigationAction;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.faces.FacesMessages;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.clientapi.agent.inventory.DeleteResourceResponse;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;

@Name(value="resourceCRUDAction")
@Scope(value=ScopeType.EVENT)
public class SingleResourceAction {
    private static final Log log = LogFactory.getLog(SingleResourceAction.class);
    private ResourceManager resourceManager;
    @In
    private NavigationAction navigationAction;
    @In
    private transient FacesMessages facesMessages;
    private Resource selectedResource;
    @Out(value="resourceType", required=false)
    public ResourceType resourceType;
    @RequestParameter
    private Integer resourceId;

    @Out(value="selectedResource", required=false, scope=ScopeType.EVENT)
    public Resource getSelectedResource() {
        return this.selectedResource;
    }

    @In(value="selectedResource", required=false)
    public void setSelectedResource(Resource selectedResource) {
        this.selectedResource = selectedResource;
    }

    @Create
    public void create() {
        this.resourceManager = ResourceManagerFactory.resourceManager();
    }

    @Destroy
    public void destroy() {
        this.selectedResource = null;
    }

    public String removeResourceAction() {
        Resource resourceToBeDeleted = this.resourceManager.getResource(this.resourceId);
        if (resourceToBeDeleted == null) {
            this.facesMessages.add(FacesMessage.SEVERITY_ERROR, "Resource with id [" + this.resourceId + "] not found.", new Object[0]);
            return "failure";
        }
        return this.removeResourceAction(resourceToBeDeleted);
    }

    public String removeResourceAction(@NotNull Resource resource) {
        log.debug((Object)("Removing Resource " + resource + "..."));
        DeleteResourceResponse deleteResourceResponse = this.resourceManager.removeResource(resource);
        switch (deleteResourceResponse.getStatus()) {
            case SUCCESS: {
                this.facesMessages.addFromResourceBundle(FacesMessage.SEVERITY_INFO, "resource.status.remove.success", new Object[]{resource.getResourceType().getName(), resource.getName()});
                return "success";
            }
        }
        String details = deleteResourceResponse.getErrorMessage() != null ? deleteResourceResponse.getErrorMessage() : "Check server log for more details.";
        this.facesMessages.addFromResourceBundle(FacesMessage.SEVERITY_ERROR, "resource.status.remove.failure", new Object[]{resource.getResourceType().getName(), resource.getName(), details});
        return "failure";
    }

    @Observer(value={"org.jboss.seam.validationFailed"})
    public void validationFailed() {
        log.info((Object)"validation failed");
    }
}

