/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.helper;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.util.StringPropertyReplacer;
import org.rhq.plugins.jbossas5.helper.JBossInstallationInfo;
import org.rhq.plugins.jbossas5.util.JBossConfigurationUtility;

public class JBossInstanceInfo {
    private static final String JBOSS_MAIN_CLASS_NAME = "org.jboss.Main";
    private static final String ANY_ADDRESS = "0.0.0.0";
    private final Log log = LogFactory.getLog(this.getClass());
    private final ProcessInfo processInfo;
    private final Properties sysProps = new Properties();
    private String[] classPath;
    private JBossInstallationInfo installInfo;

    public JBossInstanceInfo(ProcessInfo processInfo) throws Exception {
        int i;
        this.log.debug((Object)("Parsing JBossAS command line " + Arrays.asList(processInfo.getCommandLine()) + "..."));
        this.processInfo = processInfo;
        String[] args = this.processInfo.getCommandLine();
        for (i = 0; i < args.length && !args[i].equals(JBOSS_MAIN_CLASS_NAME); ++i) {
        }
        String[] jvmArgs = new String[i + 1];
        System.arraycopy(args, 0, jvmArgs, 0, i + 1);
        this.processJvmArgs(jvmArgs);
        String[] jbossArgs = new String[args.length - jvmArgs.length];
        System.arraycopy(args, i + 1, jbossArgs, 0, jbossArgs.length);
        this.processJBossArgs(processInfo.getCurrentWorkingDirectory(), jbossArgs);
        this.finalizeSysProps();
        this.printSysProps();
    }

    public Properties getSystemProperties() {
        return this.sysProps;
    }

    public JBossInstallationInfo getInstallInfo() {
        return this.installInfo;
    }

    private void processJvmArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-cp") || arg.equals("-classpath")) {
                if (i == args.length - 1) {
                    this.log.error((Object)("'" + arg + "' option has no value."));
                    continue;
                }
                this.classPath = args[i + 1].split(File.pathSeparator);
                continue;
            }
            if (!arg.startsWith("-D")) continue;
            JBossInstanceInfo.addPropArgToProps(arg.substring("-D".length()), this.sysProps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processJBossArgs(String currentWorkingDir, String[] args) {
        programName = this.sysProps.getProperty("program.name", "jboss");
        shortOpts = "-:b:c:D:P:";
        longOpts = new LongOpt[]{new LongOpt("configuration", 1, null, 99), new LongOpt("properties", 1, null, 80), new LongOpt("host", 1, null, 98)};
        options = new Getopt(programName, args, shortOpts, longOpts);
        options.setOpterr(false);
        block18: while ((c = options.getopt()) != -1) {
            switch (c) {
                case 98: {
                    arg = options.getOptarg();
                    this.sysProps.setProperty("jboss.bind.address", arg);
                    break;
                }
                case 99: {
                    arg = options.getOptarg();
                    this.sysProps.setProperty("jboss.server.name", arg);
                    break;
                }
                case 68: {
                    arg = options.getOptarg();
                    name = JBossInstanceInfo.addPropArgToProps(arg, this.sysProps);
                    value = this.sysProps.getProperty(name);
                    if (!value.equals("")) break;
                    this.sysProps.setProperty(name, Boolean.TRUE.toString());
                    break;
                }
                case 80: {
                    arg = options.getOptarg();
                    try {
                        workingDir = new File(currentWorkingDir);
                        url = JBossConfigurationUtility.makeURL(arg, workingDir);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Failed to parse argument to --properties option: " + options.getOptarg()));
                        break;
                    }
                    props = new Properties();
                    inputStream = null;
                    try {
                        inputStream = new BufferedInputStream(url.openConnection().getInputStream());
                        props.load(inputStream);
                        ** if (inputStream == null) goto lbl-1000
                    }
                    catch (IOException e) {
                        try {
                            this.log.error((Object)("Could not read properties from file: " + arg), (Throwable)e);
                            if (inputStream == null) break;
                        }
                        catch (Throwable var14_19) {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException e) {
                                    this.log.error((Object)("Failed to close properties file: " + arg), (Throwable)e);
                                }
                            }
                            throw var14_19;
                        }
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            this.log.error((Object)("Failed to close properties file: " + arg), (Throwable)e);
                        }
                        break;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            this.log.error((Object)("Failed to close properties file: " + arg), (Throwable)e);
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    for (Object nameObj : props.keySet()) {
                        name = (String)nameObj;
                        value = props.getProperty(name);
                        newValue = StringPropertyReplacer.replaceProperties((String)value, (Properties)this.sysProps);
                        this.sysProps.setProperty(name, newValue);
                    }
                    continue block18;
                }
            }
        }
    }

    private static String addPropArgToProps(String arg, Properties props) {
        String value;
        String name;
        int i = arg.indexOf("=");
        if (i == -1) {
            name = arg;
            value = "";
        } else {
            name = arg.substring(0, i);
            value = arg.substring(i + 1, arg.length());
        }
        props.setProperty(name, value);
        return name;
    }

    private File getHomeDir() throws Exception {
        File runJar = null;
        File binDir = null;
        File homeDir = null;
        if (this.processInfo != null && this.processInfo.getExecutable() != null && this.processInfo.getExecutable().getCwd() != null && (runJar = new File(binDir = new File(homeDir = new File(this.processInfo.getExecutable().getCwd()).getParentFile(), "bin"), "run.jar")).exists()) {
            return homeDir;
        }
        for (String pathElement : this.classPath) {
            if (!pathElement.endsWith("run.jar")) continue;
            runJar = new File(pathElement);
            if (!runJar.isAbsolute()) {
                runJar = new File(this.processInfo.getExecutable().getCwd(), runJar.getPath());
            }
            if (!runJar.exists() || (binDir = runJar.getParentFile()) == null || !binDir.exists() || (homeDir = binDir.getParentFile()) == null || !homeDir.exists()) break;
            return homeDir;
        }
        throw new Exception("Could not determine JBossAS home dir - classpath is: " + Arrays.toString(this.classPath));
    }

    private void finalizeSysProps() throws Exception {
        File serverBaseDir;
        File homeDir;
        if (this.sysProps.containsKey("jboss.home.dir")) {
            homeDir = new File(this.sysProps.getProperty("jboss.home.dir"));
        } else {
            homeDir = this.getHomeDir();
            this.sysProps.setProperty("jboss.home.dir", homeDir.toString());
        }
        if (!this.sysProps.containsKey("jboss.home.url")) {
            this.sysProps.setProperty("jboss.home.url", homeDir.toURL().toString());
        }
        if (!this.sysProps.containsKey("jboss.server.base.dir")) {
            serverBaseDir = new File(homeDir, "server");
            this.sysProps.setProperty("jboss.server.base.dir", serverBaseDir.toString());
        } else {
            serverBaseDir = new File(this.sysProps.getProperty("jboss.server.base.dir"));
        }
        if (!this.sysProps.containsKey("jboss.server.base.url")) {
            this.sysProps.setProperty("jboss.server.base.url", serverBaseDir.toURL().toString());
        }
        this.installInfo = new JBossInstallationInfo(homeDir);
        if (!this.sysProps.containsKey("jboss.server.name")) {
            this.sysProps.setProperty("jboss.server.name", this.installInfo.getProductType().DEFAULT_CONFIG_NAME);
        }
        String serverName = this.sysProps.getProperty("jboss.server.name");
        if (!this.sysProps.containsKey("jboss.server.home.dir")) {
            this.sysProps.setProperty("jboss.server.home.dir", serverBaseDir + File.separator + serverName);
        }
        if (!this.sysProps.containsKey("jboss.server.home.url")) {
            String serverHomeDir = this.sysProps.getProperty("jboss.server.home.dir");
            this.sysProps.setProperty("jboss.server.home.url", new File(serverHomeDir).toURL().toString());
        }
        if (!this.sysProps.containsKey("jboss.bind.address")) {
            this.sysProps.setProperty("jboss.bind.address", this.installInfo.getDefaultBindAddress());
        }
        String bindAddress = this.sysProps.getProperty("jboss.bind.address");
        String remoteAddress = JBossInstanceInfo.getRemoteAddress(bindAddress);
        String jgroupsBindAddress = this.sysProps.getProperty("jboss.bind.address");
        String jgroupsBindAddr = this.sysProps.getProperty("jgroups.bind_addr");
        if (jgroupsBindAddress == null) {
            jgroupsBindAddress = jgroupsBindAddr != null ? jgroupsBindAddr : remoteAddress;
            this.sysProps.setProperty("jboss.bind.address", jgroupsBindAddress);
        }
        if (jgroupsBindAddr == null) {
            this.sysProps.setProperty("jgroups.bind_addr", jgroupsBindAddress);
        }
        if (!this.sysProps.contains("java.rmi.server.hostname")) {
            this.sysProps.setProperty("java.rmi.server.hostname", remoteAddress);
        }
    }

    private void printSysProps() {
        if (this.log.isDebugEnabled()) {
            this.printSysProp("jboss.home.dir");
            this.printSysProp("jboss.server.home.dir");
            this.printSysProp("jboss.server.name");
            this.printSysProp("jboss.bind.address");
        }
    }

    private void printSysProp(String name) {
        String value = this.sysProps.getProperty(name);
        this.log.debug((Object)(name + "=" + (value != null ? "\"" + value + "\"" : null)));
    }

    private static String getRemoteAddress(String address) {
        try {
            if (address == null || address.equals(ANY_ADDRESS)) {
                return InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return address;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getSimpleName());
        buf.append("[");
        buf.append("sysProps").append("=").append(this.sysProps).append(", ");
        buf.append("installInfo").append("=").append(this.installInfo);
        buf.append("]");
        return buf.toString();
    }
}

