/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.util.StringPropertyReplacer;
import org.rhq.plugins.jbossas5.util.JBossConfigurationUtility;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class JnpConfig {
    private static Log log = LogFactory.getLog(JnpConfig.class);
    static final String PROPERTY_EXPRESSION_PREFIX = "${";
    private static final HashMap<File, JnpConfig> CACHE = new HashMap();
    private String jnpAddress;
    private Integer jnpPort;
    private long lastModified = 0L;
    private String serverName;
    private File storeFile;
    private Properties systemProperties;

    private JnpConfig(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public static synchronized JnpConfig getConfig(File distributionDirectory, File configXML, Properties systemProperties) {
        JnpConfig config = CACHE.get(configXML);
        long lastModified = configXML.lastModified();
        if (config == null || lastModified != config.lastModified) {
            config = new JnpConfig(systemProperties);
            config.lastModified = lastModified;
            CACHE.put(configXML, config);
            try {
                config.read(distributionDirectory, configXML);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return config;
    }

    @Nullable
    public Integer getJnpPort() {
        return this.jnpPort;
    }

    @Nullable
    public String getJnpAddress() {
        return this.jnpAddress;
    }

    private void read(File distributionDirectory, File file) throws IOException {
        try {
            this.parseServiceXML(distributionDirectory, file);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (this.jnpPort == null && this.storeFile != null) {
            this.parseBindingManagerXML();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseServiceXML(File distributionDirectory, File serviceXmlFile) throws IOException, SAXException, ParserConfigurationException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(serviceXmlFile);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            LocalEntityResolver r = new LocalEntityResolver(distributionDirectory);
            JBossServiceHandler handler = new JBossServiceHandler(serviceXmlFile);
            XMLReader reader = parser.getXMLReader();
            reader.setEntityResolver(r);
            reader.setContentHandler(handler);
            reader.parse(new InputSource(is));
            this.jnpAddress = handler.getNamingBindAddress();
            this.jnpPort = handler.getNamingPort();
            this.storeFile = handler.getStoreFile();
            this.serverName = handler.getServerName();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private void parseBindingManagerXML() throws IOException {
        InputStream bindIs = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            if (!this.storeFile.isFile()) {
                log.warn((Object)("Store file does not exist: " + this.storeFile));
                return;
            }
            JBossBindingManagerHandler bindingHandler = new JBossBindingManagerHandler(this.storeFile);
            bindingHandler.setServerName(this.serverName);
            XMLReader reader = parser.getXMLReader();
            bindIs = new FileInputStream(this.storeFile);
            reader.setContentHandler(bindingHandler);
            reader.parse(new InputSource(bindIs));
            this.jnpAddress = bindingHandler.getJnpAddress();
            this.jnpPort = bindingHandler.getJnpPort();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        finally {
            if (bindIs != null) {
                bindIs.close();
            }
        }
    }

    private String replaceProperties(String value) {
        return value != null ? StringPropertyReplacer.replaceProperties((String)value, (Properties)this.systemProperties) : null;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: <config file>");
            System.exit(1);
        }
        File serviceFile = new File(args[0]);
        File distDir = serviceFile.getParentFile().getParentFile().getParentFile().getParentFile();
        JnpConfig cfg = JnpConfig.getConfig(distDir, serviceFile, new Properties());
        System.out.println("JNP address: " + cfg.getJnpAddress());
        System.out.println("JNP port: " + cfg.getJnpPort());
    }

    public static class LocalEntityResolver
    implements EntityResolver {
        static Properties resolverMap = new Properties();
        private File distributionDirectory;

        public LocalEntityResolver(File distributionDirectory) {
            this.distributionDirectory = distributionDirectory;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            File systemJar;
            String dtdName;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolving DTD [" + publicId + "]..."));
            }
            if ((dtdName = resolverMap.getProperty(publicId)) != null && (systemJar = new File(this.distributionDirectory + File.separator + "lib" + File.separator + "jboss-system.jar")).exists()) {
                JarFile j = new JarFile(systemJar);
                JarEntry entry = j.getJarEntry("dtd/" + dtdName);
                if (entry == null) {
                    entry = j.getJarEntry("org/jboss/metadata/" + dtdName);
                }
                if (entry != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found DTD locally: " + entry.getName()));
                    }
                    return new InputSource(j.getInputStream(entry));
                }
            }
            return null;
        }

        static {
            resolverMap.setProperty("-//JBoss//DTD JBOSS 3.2//EN", "jboss-service_3_2.dtd");
            resolverMap.setProperty("-//JBoss//DTD JBOSS 4.0//EN", "jboss-service_4_0.dtd");
        }
    }

    private class JBossServiceHandler
    extends DefaultHandler {
        private static final String DEFAULT_JNP_ADDRESS = "0.0.0.0";
        private static final String DEFAULT_JNP_PORT = "1099";
        private File file;
        private boolean inNaming = false;
        private boolean inNamingPort = false;
        private boolean inNamingBindAddress = false;
        private StringBuilder namingPort = null;
        private StringBuilder namingBindAddress = null;
        private boolean inBinding = false;
        private boolean inServerName = false;
        private boolean inStoreURL = false;
        private boolean isBindingManagerInUse = false;
        private StringBuilder storeURL = new StringBuilder();
        private StringBuilder serverName = new StringBuilder();

        private JBossServiceHandler(File filePath) {
            this.file = filePath;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inNamingBindAddress) {
                this.namingBindAddress.append(ch, start, length);
            } else if (this.inNamingPort) {
                this.namingPort.append(ch, start, length);
            } else if (this.inServerName) {
                this.serverName.append(ch, start, length);
            } else if (this.inStoreURL) {
                this.storeURL.append(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (this.inNamingPort && qName.equals("attribute")) {
                this.inNamingPort = false;
                this.namingPort = this.processValue(this.namingPort, DEFAULT_JNP_PORT);
                return;
            }
            if (this.inNamingBindAddress && qName.equals("attribute")) {
                this.inNamingBindAddress = false;
                this.namingBindAddress = this.processValue(this.namingBindAddress, DEFAULT_JNP_ADDRESS);
                return;
            }
            if (this.inServerName && qName.equals("attribute")) {
                this.inServerName = false;
                this.serverName = this.processValue(this.serverName, null);
                return;
            }
            if (this.inStoreURL && qName.equals("attribute")) {
                this.storeURL = this.processValue(this.storeURL, null);
                this.inStoreURL = false;
                return;
            }
            if (this.inNaming && qName.equals("mbean")) {
                this.inNaming = false;
                return;
            }
            if (this.inBinding && qName.equals("mbean")) {
                this.inBinding = false;
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String name;
            if (this.inNaming && qName.equals("attribute") && (name = attributes.getValue("name")) != null) {
                if (name.equals("Port")) {
                    this.inNamingPort = true;
                    this.namingPort = new StringBuilder();
                    return;
                }
                if (name.equals("BindAddress")) {
                    this.inNamingBindAddress = true;
                    this.namingBindAddress = new StringBuilder();
                    return;
                }
            }
            if (this.inBinding && qName.equals("attribute")) {
                name = attributes.getValue("name");
                if (name != null && name.equals("ServerName")) {
                    this.inServerName = true;
                    return;
                }
                if (name != null && name.equals("StoreURL")) {
                    this.inStoreURL = true;
                    return;
                }
            }
            if (qName.equals("mbean")) {
                name = attributes.getValue("name");
                if (name != null && name.equals("jboss:service=Naming")) {
                    this.inNaming = true;
                    return;
                }
                if (name != null && name.equals("jboss.system:service=ServiceBindingManager")) {
                    this.inBinding = true;
                    this.isBindingManagerInUse = true;
                }
            }
        }

        protected Integer getNamingPort() {
            if (this.isBindingManagerInUse) {
                return null;
            }
            if (null == this.namingPort) {
                log.warn((Object)("Naming 'RmiPort' attribute not found in JBossAS config file " + this.file + ". This may be ok as it can be specified in more than one place."));
                return null;
            }
            try {
                return Integer.parseInt(this.namingPort.toString());
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Naming 'Port' attribute has invalid value (" + this.namingPort + ") in JBossAS config file " + this.file + " - the value should be a positive integer or a resolvable property reference."));
                return null;
            }
        }

        protected String getNamingBindAddress() {
            if (this.isBindingManagerInUse) {
                return null;
            }
            if (null == this.namingBindAddress) {
                log.warn((Object)("Naming 'BindingAddress' attribute not found in JBossAS config file " + this.file + ". This may be ok as it can be specified in more than one place."));
                return null;
            }
            String bindAddressString = this.namingBindAddress.toString();
            if (null == bindAddressString || bindAddressString.startsWith(JnpConfig.PROPERTY_EXPRESSION_PREFIX)) {
                log.warn((Object)("Naming 'BindingAddress' attribute has invalid value (" + this.namingBindAddress + ") in JBossAS config file " + this.file + ". The value should be a host name, an IP address, or a resolvable property reference."));
                return null;
            }
            return bindAddressString;
        }

        protected String getServerName() {
            return this.serverName.toString();
        }

        protected File getStoreFile() {
            File homeDir = new File(JnpConfig.this.systemProperties.getProperty("jboss.home.dir"));
            try {
                URL url = JBossConfigurationUtility.makeURL(this.storeURL.toString(), homeDir);
                if (!"file".equals(url.getProtocol())) {
                    throw new MalformedURLException();
                }
                return new File(url.getPath());
            }
            catch (MalformedURLException e) {
                log.warn((Object)("Binding 'StoreURL' attribute has invalid value (" + this.storeURL + ") in JBossAS config file " + this.file + " - the value should be a file URL or file path."));
                return null;
            }
        }

        private StringBuilder processValue(StringBuilder value, String defaultValue) {
            String stringValue = value.toString().trim();
            if (stringValue.equals("") && defaultValue != null) {
                stringValue = defaultValue;
            }
            stringValue = JnpConfig.this.replaceProperties(stringValue);
            return new StringBuilder(stringValue);
        }
    }

    private class JBossBindingManagerHandler
    extends DefaultHandler {
        private File file;
        private boolean inServer = false;
        private boolean inServiceConfig = false;
        private boolean inNamingPort = false;
        private String jnpAddress;
        private Integer jnpPort;
        private String serverName;

        private JBossBindingManagerHandler(File file) {
            this.file = file;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String name;
            if (qName.equals("server") && (name = attributes.getValue("name")) != null && name.equals(this.serverName)) {
                this.inServer = true;
                return;
            }
            if (this.inServer && qName.equals("service-config") && (name = attributes.getValue("name")) != null && name.equals("jboss:service=Naming")) {
                this.inServiceConfig = true;
                return;
            }
            if (this.inServiceConfig && qName.equals("binding")) {
                this.jnpAddress = JnpConfig.this.replaceProperties(attributes.getValue("host"));
                if (this.jnpAddress.substring(0, JnpConfig.PROPERTY_EXPRESSION_PREFIX.length()).equals(JnpConfig.PROPERTY_EXPRESSION_PREFIX)) {
                    log.warn((Object)("Naming binding 'host' attribute has invalid value (" + this.jnpAddress + ") in JBossAS config file " + this.file + " - the value should be a host name, an IP address, or a resolvable property reference."));
                    this.jnpAddress = null;
                }
                String jnpPortString = JnpConfig.this.replaceProperties(attributes.getValue("port"));
                try {
                    this.jnpPort = Integer.parseInt(jnpPortString);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Naming binding 'port' attribute has invalid value (" + jnpPortString + ") in JBossAS config file " + this.file + " - the value should be a positive integer or a resolvable property reference."));
                    this.jnpPort = null;
                }
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (this.inServiceConfig && qName.equals("binding")) {
                this.inServiceConfig = false;
            }
            if (this.inNamingPort && qName.equals("service-config")) {
                this.inNamingPort = false;
            }
            if (this.inServer && qName.equals("server")) {
                this.inServer = false;
            }
        }

        public String getJnpAddress() {
            return this.jnpAddress;
        }

        protected Integer getJnpPort() {
            return this.jnpPort;
        }

        protected void setServerName(String serverName) {
            this.serverName = serverName;
        }
    }
}

