/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.inventory;

import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.system.ProcessInfo;

public class DiscoveredResourceDetails {
    private static final int RESOURCE_KEY_MAX_LENGTH = 500;
    private static final int RESOURCE_NAME_MAX_LENGTH = 500;
    private static final int RESOURCE_VERSION_MAX_LENGTH = 50;
    private static final int RESOURCE_DESCRIPTION_MAX_LENGTH = 1000;
    private ResourceType resourceType;
    private String resourceKey;
    private String resourceName;
    private String resourceVersion;
    private String resourceDescription;
    private Configuration pluginConfiguration;
    private ProcessInfo processInfo;

    public DiscoveredResourceDetails(ResourceType resourceType, String resourceKey, String resourceName, String resourceVersion, String resourceDescription, Configuration pluginConfiguration, ProcessInfo processInfo) {
        if (resourceType == null) {
            throw new IllegalArgumentException("resourceType==null");
        }
        this.resourceType = resourceType;
        this.processInfo = processInfo;
        this.setResourceKey(resourceKey);
        this.setResourceName(resourceName);
        this.setResourceVersion(resourceVersion);
        this.setResourceDescription(resourceDescription);
        this.setPluginConfiguration(pluginConfiguration);
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public void setResourceKey(String resourceKey) {
        if (resourceKey == null) {
            throw new IllegalArgumentException("resourceKey==null");
        }
        if (resourceKey.length() > 500) {
            throw new IllegalArgumentException("Resource key is longer than maximum length (500) [" + resourceKey + "]");
        }
        this.resourceKey = resourceKey;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException("resourceName==null");
        }
        if (resourceName.length() > 500) {
            throw new IllegalArgumentException("Resource name is longer than maximum length (500) [" + resourceName + "]");
        }
        this.resourceName = resourceName;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        if (resourceVersion == null) {
            resourceVersion = "";
        }
        if (resourceVersion.length() > 50) {
            throw new IllegalArgumentException("Resource version is longer than maximum length (50) [" + resourceVersion + "]");
        }
        this.resourceVersion = resourceVersion;
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public void setResourceDescription(String resourceDescription) {
        if (resourceDescription == null) {
            resourceDescription = "";
        }
        if (resourceDescription.length() > 1000) {
            throw new IllegalArgumentException("Resource description is longer than maximum length (1000) [" + resourceDescription + "]");
        }
        this.resourceDescription = resourceDescription;
    }

    public Configuration getPluginConfiguration() {
        if (this.pluginConfiguration == null) {
            this.pluginConfiguration = this.getDefaultPluginConfiguration();
        }
        return this.pluginConfiguration;
    }

    public ProcessInfo getProcessInfo() {
        return this.processInfo;
    }

    public void setPluginConfiguration(Configuration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("key=");
        buf.append(this.getResourceKey());
        buf.append(",name=");
        buf.append(this.getResourceName());
        buf.append(",type=");
        buf.append(this.getResourceType().getName());
        buf.append(",version=");
        buf.append(this.getResourceVersion());
        buf.append(",description=");
        buf.append(this.getResourceDescription());
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveredResourceDetails that = (DiscoveredResourceDetails)o;
        if (!this.resourceKey.equals(that.resourceKey)) {
            return false;
        }
        return this.resourceType.equals((Object)that.resourceType);
    }

    public int hashCode() {
        int result = this.resourceType.hashCode();
        result = 31 * result + this.resourceKey.hashCode();
        return result;
    }

    private Configuration getDefaultPluginConfiguration() {
        ConfigurationTemplate template;
        ConfigurationDefinition definition = this.resourceType.getPluginConfigurationDefinition();
        if (definition != null && (template = definition.getDefaultTemplate()) != null) {
            return template.getConfiguration().deepCopy();
        }
        return new Configuration();
    }
}

