/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core;

import java.io.Serializable;
import org.hornetq.core.logging.Logger;
import org.hornetq.utils.UUIDGenerator;

public class DiscoveryGroupConfiguration
implements Serializable {
    private static final long serialVersionUID = 8657206421727863400L;
    private static final Logger log = Logger.getLogger(DiscoveryGroupConfiguration.class);
    private String name;
    private String localBindAddress;
    private String groupAddress;
    private int groupPort;
    private long refreshTimeout;
    private long discoveryInitialWaitTimeout;

    public DiscoveryGroupConfiguration(String name, String localBindAddress, String groupAddress, int groupPort, long refreshTimeout, long discoveryInitialWaitTimeout) {
        this.name = name;
        this.groupAddress = groupAddress;
        this.localBindAddress = localBindAddress;
        this.groupPort = groupPort;
        this.refreshTimeout = refreshTimeout;
        this.discoveryInitialWaitTimeout = discoveryInitialWaitTimeout;
    }

    public DiscoveryGroupConfiguration(String groupAddress, int groupPort) {
        this(UUIDGenerator.getInstance().generateStringUUID(), null, groupAddress, groupPort, 10000L, 10000L);
    }

    public String getName() {
        return this.name;
    }

    public String getLocalBindAddress() {
        return this.localBindAddress;
    }

    public String getGroupAddress() {
        return this.groupAddress;
    }

    public int getGroupPort() {
        return this.groupPort;
    }

    public long getRefreshTimeout() {
        return this.refreshTimeout;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLocalBindAdress(String localBindAddress) {
        this.localBindAddress = localBindAddress;
    }

    public void setGroupAddress(String groupAddress) {
        this.groupAddress = groupAddress;
    }

    public void setGroupPort(int groupPort) {
        this.groupPort = groupPort;
    }

    public void setRefreshTimeout(long refreshTimeout) {
        this.refreshTimeout = refreshTimeout;
    }

    public long getDiscoveryInitialWaitTimeout() {
        return this.discoveryInitialWaitTimeout;
    }

    public void setDiscoveryInitialWaitTimeout(long discoveryInitialWaitTimeout) {
        this.discoveryInitialWaitTimeout = discoveryInitialWaitTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryGroupConfiguration that = (DiscoveryGroupConfiguration)o;
        if (this.discoveryInitialWaitTimeout != that.discoveryInitialWaitTimeout) {
            return false;
        }
        if (this.groupPort != that.groupPort) {
            return false;
        }
        if (this.refreshTimeout != that.refreshTimeout) {
            return false;
        }
        if (this.groupAddress != null ? !this.groupAddress.equals(that.groupAddress) : that.groupAddress != null) {
            return false;
        }
        if (this.localBindAddress != null ? !this.localBindAddress.equals(that.localBindAddress) : that.localBindAddress != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.localBindAddress != null ? this.localBindAddress.hashCode() : 0);
        result = 31 * result + (this.groupAddress != null ? this.groupAddress.hashCode() : 0);
        result = 31 * result + this.groupPort;
        result = 31 * result + (int)(this.refreshTimeout ^ this.refreshTimeout >>> 32);
        result = 31 * result + (int)(this.discoveryInitialWaitTimeout ^ this.discoveryInitialWaitTimeout >>> 32);
        return result;
    }
}

