/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jmx;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.hibernate.AssertionFailure;
import org.hibernate.Cache;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.TypeHelper;
import org.hibernate.classic.Session;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.impl.SessionFactoryObjectFactory;
import org.hibernate.jmx.HibernateService;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.stat.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionFactoryStub
implements SessionFactory {
    private static final IdentifierGenerator UUID_GENERATOR = UUIDGenerator.buildSessionFactoryUniqueIdentifierGenerator();
    private static final Logger log = LoggerFactory.getLogger(SessionFactoryStub.class);
    private transient SessionFactory impl;
    private transient HibernateService service;
    private String uuid;
    private String name;

    SessionFactoryStub(HibernateService service) {
        this.service = service;
        this.name = service.getJndiName();
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryObjectFactory.addInstance(this.uuid, this.name, this, service.getProperties());
    }

    @Override
    public Session openSession(Connection connection, Interceptor interceptor) {
        return this.getImpl().openSession(connection, interceptor);
    }

    @Override
    public Session openSession(Interceptor interceptor) throws HibernateException {
        return this.getImpl().openSession(interceptor);
    }

    @Override
    public Session openSession() throws HibernateException {
        return this.getImpl().openSession();
    }

    @Override
    public Session openSession(Connection conn) {
        return this.getImpl().openSession(conn);
    }

    @Override
    public Session getCurrentSession() {
        return this.getImpl().getCurrentSession();
    }

    private synchronized SessionFactory getImpl() {
        if (this.impl == null) {
            this.impl = this.service.buildSessionFactory();
        }
        return this.impl;
    }

    private Object readResolve() throws ObjectStreamException {
        Object result = SessionFactoryObjectFactory.getInstance(this.uuid);
        if (result == null) {
            result = SessionFactoryObjectFactory.getNamedInstance(this.name);
            if (result == null) {
                throw new InvalidObjectException("Could not find a stub SessionFactory named: " + this.name);
            }
            log.debug("resolved stub SessionFactory by name");
        } else {
            log.debug("resolved stub SessionFactory by uid");
        }
        return result;
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(SessionFactoryStub.class.getName(), new StringRefAddr("uuid", this.uuid), SessionFactoryObjectFactory.class.getName(), null);
    }

    @Override
    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.getImpl().getClassMetadata(persistentClass);
    }

    @Override
    public ClassMetadata getClassMetadata(String entityName) throws HibernateException {
        return this.getImpl().getClassMetadata(entityName);
    }

    @Override
    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return this.getImpl().getCollectionMetadata(roleName);
    }

    @Override
    public Map<String, ClassMetadata> getAllClassMetadata() throws HibernateException {
        return this.getImpl().getAllClassMetadata();
    }

    @Override
    public Map getAllCollectionMetadata() throws HibernateException {
        return this.getImpl().getAllCollectionMetadata();
    }

    @Override
    public void close() throws HibernateException {
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public Cache getCache() {
        return this.getImpl().getCache();
    }

    @Override
    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        this.getImpl().evict(persistentClass, id);
    }

    @Override
    public void evict(Class persistentClass) throws HibernateException {
        this.getImpl().evict(persistentClass);
    }

    @Override
    public void evictEntity(String entityName, Serializable id) throws HibernateException {
        this.getImpl().evictEntity(entityName, id);
    }

    @Override
    public void evictEntity(String entityName) throws HibernateException {
        this.getImpl().evictEntity(entityName);
    }

    @Override
    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        this.getImpl().evictCollection(roleName, id);
    }

    @Override
    public void evictCollection(String roleName) throws HibernateException {
        this.getImpl().evictCollection(roleName);
    }

    @Override
    public void evictQueries() throws HibernateException {
        this.getImpl().evictQueries();
    }

    @Override
    public void evictQueries(String cacheRegion) throws HibernateException {
        this.getImpl().evictQueries(cacheRegion);
    }

    @Override
    public Statistics getStatistics() {
        return this.getImpl().getStatistics();
    }

    @Override
    public StatelessSession openStatelessSession() {
        return this.getImpl().openStatelessSession();
    }

    @Override
    public StatelessSession openStatelessSession(Connection conn) {
        return this.getImpl().openStatelessSession(conn);
    }

    @Override
    public Set getDefinedFilterNames() {
        return this.getImpl().getDefinedFilterNames();
    }

    @Override
    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        return this.getImpl().getFilterDefinition(filterName);
    }

    @Override
    public boolean containsFetchProfileDefinition(String name) {
        return this.getImpl().containsFetchProfileDefinition(name);
    }

    @Override
    public TypeHelper getTypeHelper() {
        return this.getImpl().getTypeHelper();
    }
}

