/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.injector.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import org.jboss.injection.injector.util.FieldInjectionPoint;
import org.jboss.injection.injector.util.InjectionPoint;
import org.jboss.injection.injector.util.MethodInjectionPoint;
import org.jboss.injection.injector.util.NoSuchPropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionPointFactory {
    static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    public static InjectionPoint create(Class<?> targetClass, String property, Class<?> paramType) throws NoSuchPropertyException {
        String writeMethodName = "set" + InjectionPointFactory.capitalize(property);
        Method writeMethod = InjectionPointFactory.findWriteMethod(targetClass, writeMethodName, paramType);
        if (writeMethod != null) {
            return new MethodInjectionPoint(writeMethod);
        }
        writeMethod = InjectionPointFactory.findWriteMethod(targetClass, property, paramType);
        if (writeMethod != null) {
            return new MethodInjectionPoint(writeMethod);
        }
        try {
            Field field = targetClass.getDeclaredField(property);
            return new FieldInjectionPoint(field);
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchPropertyException("No such property " + property + " on " + targetClass, e);
        }
    }

    private static Method findWriteMethod(Class<?> cls, String methodName, Class<?> paramType) {
        for (Method m : cls.getDeclaredMethods()) {
            if (!m.getName().equals(methodName) || m.getReturnType() != Void.TYPE || m.getParameterTypes().length != 1) continue;
            if (paramType == null) {
                return m;
            }
            Class<?>[] paramTypes = m.getParameterTypes();
            if (paramTypes[0].isAssignableFrom(paramType)) {
                return m;
            }
            if (paramType.isPrimitive() && InjectionPointFactory.isCompatibleForBoxedType(paramType, paramTypes[0])) {
                return m;
            }
            if (!paramTypes[0].isPrimitive() || !InjectionPointFactory.isCompatibleForBoxedType(paramTypes[0], paramType)) continue;
            return m;
        }
        return null;
    }

    private static boolean isCompatibleForBoxedType(Class<?> primitiveType, Class<?> wrapperType) {
        if (primitiveType.equals(Integer.TYPE)) {
            return wrapperType.equals(Integer.class);
        }
        if (primitiveType.equals(Float.TYPE)) {
            return wrapperType.equals(Float.class);
        }
        if (primitiveType.equals(Double.TYPE)) {
            return wrapperType.equals(Double.class);
        }
        if (primitiveType.equals(Byte.TYPE)) {
            return wrapperType.equals(Byte.class);
        }
        if (primitiveType.equals(Character.TYPE)) {
            return wrapperType.equals(Character.class);
        }
        if (primitiveType.equals(Boolean.TYPE)) {
            return wrapperType.equals(Boolean.class);
        }
        if (primitiveType.equals(Long.TYPE)) {
            return wrapperType.equals(Long.class);
        }
        if (primitiveType.equals(Short.TYPE)) {
            return wrapperType.equals(Short.class);
        }
        return false;
    }
}

