/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.javassist;

import java.lang.reflect.InvocationHandler;
import javassist.util.proxy.MethodHandler;
import org.jboss.ejb3.proxy.javassist.JavassistInvocationHandlerAdapter;
import org.jboss.ejb3.proxy.spi.factory.ProxyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistProxyFactory
implements ProxyFactory {
    public Object createProxy(ClassLoader cl, Class<?>[] types, InvocationHandler invocationHandler) throws IllegalArgumentException {
        if (types.length == 0) {
            throw new IllegalArgumentException("Class type not specified for creating proxy");
        }
        if (types.length > 1) {
            throw new IllegalArgumentException("More than one class type specified for creating proxy");
        }
        if (cl == null) {
            throw new IllegalArgumentException("Null classloader passed to proxy creation");
        }
        String className = types[0].getName();
        try {
            Class<?> type = cl.loadClass(className);
            return this.createProxy(new Class[]{type}, invocationHandler);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not load class: " + className + " during proxy creation", cnfe);
        }
    }

    public Object createProxy(Class<?>[] types, InvocationHandler invocationHandler) throws IllegalArgumentException {
        Object proxy;
        if (types.length == 0) {
            throw new IllegalArgumentException("Class type not specified for creating proxy");
        }
        if (types.length > 1) {
            throw new IllegalArgumentException("More than one class type specified for creating proxy");
        }
        javassist.util.proxy.ProxyFactory javassistProxyFactory = new javassist.util.proxy.ProxyFactory();
        javassistProxyFactory.setSuperclass(types[0]);
        try {
            proxy = javassistProxyFactory.create(new Class[0], new Object[0], (MethodHandler)new JavassistInvocationHandlerAdapter(invocationHandler));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a proxy of type " + types[0], e);
        }
        return types[0].cast(proxy);
    }
}

