/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.injection;

import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.injection.manager.spi.InjectionContext;
import org.jboss.injection.manager.spi.InjectionException;
import org.jboss.injection.manager.spi.Injector;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.integration.deployer.env.helpers.BootstrapBean;
import org.jboss.weld.manager.api.WeldManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jsr299InterceptorInjector
implements Injector {
    private BootstrapBean bootstrapBean;
    private String bdaId;
    private AtomicReference<WeldManager> weldManagerRef;
    private JBossEnterpriseBeanMetaData enterpriseBeanMetaData;

    public Jsr299InterceptorInjector(String bdaId, JBossEnterpriseBeanMetaData enterpriseBeanMetaData) {
        this.bdaId = bdaId;
        this.enterpriseBeanMetaData = enterpriseBeanMetaData;
        this.weldManagerRef = new AtomicReference();
    }

    public void setBootstrapBean(BootstrapBean bootstrapBean) {
        this.bootstrapBean = bootstrapBean;
    }

    public <T> void inject(InjectionContext<T> injectionContext) throws InjectionException {
        if (this.isInterceptor(injectionContext.getInjectionTarget())) {
            WeldManager weldManager = this.initWeldManagerIfNecessary();
            Object instance = injectionContext.getInjectionTarget();
            if (weldManager == null) {
                throw new IllegalArgumentException("Null bean manager.");
            }
            CreationalContext creationalContext = weldManager.createCreationalContext(null);
            InjectionTarget injectionTarget = weldManager.fireProcessInjectionTarget(weldManager.createAnnotatedType(instance.getClass()));
            injectionTarget.inject(instance, creationalContext);
        }
        injectionContext.proceed();
    }

    private WeldManager initWeldManagerIfNecessary() {
        WeldManager weldManager = this.weldManagerRef.get();
        if (weldManager == null) {
            weldManager = this.locateWeldManager();
        }
        this.weldManagerRef.compareAndSet(null, weldManager);
        return weldManager;
    }

    private WeldManager locateWeldManager() {
        BeanDeploymentArchive foundBeanDeploymentArchive = null;
        for (BeanDeploymentArchive beanDeploymentArchive : this.bootstrapBean.getDeployment().getBeanDeploymentArchives()) {
            if (!beanDeploymentArchive.getId().equals(this.bdaId)) continue;
            foundBeanDeploymentArchive = beanDeploymentArchive;
        }
        if (foundBeanDeploymentArchive == null) {
            throw new IllegalStateException("Cannot find BeanManager for BeanDeploymentArchive with id=" + this.bdaId);
        }
        return this.bootstrapBean.getBootstrap().getManager(foundBeanDeploymentArchive);
    }

    private boolean isInterceptor(Object instance) {
        return !instance.getClass().getName().equals(this.enterpriseBeanMetaData.getEjbClass());
    }

    public void release() {
        this.bootstrapBean = null;
        this.weldManagerRef.set(null);
    }
}

