/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.management.ObjectName;
import org.jboss.classloading.spi.RealClassLoader;

public final class IdFactory {
    private static String serverHome;

    private IdFactory() {
    }

    public static String getIdFromClassLoader(ClassLoader cl) {
        ObjectName on;
        ClassLoader current;
        if (cl == null) {
            throw new IllegalArgumentException("Null classloader.");
        }
        for (current = cl; current != null && !(current instanceof RealClassLoader); current = current.getParent()) {
        }
        if (current != null && (on = ((RealClassLoader)current).getObjectName()) != null) {
            String canonical = on.getCanonicalName();
            if (serverHome != null) {
                return canonical.replace(serverHome, "-JBossAS-");
            }
            return canonical;
        }
        return cl.toString();
    }

    static {
        SecurityManager sm = System.getSecurityManager();
        String home = sm == null ? System.getProperty("jboss.server.home.url") : AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("jboss.server.home.url");
            }
        });
        if (home != null && home.startsWith("file:")) {
            home = home.substring("file:".length());
        }
        serverHome = home;
    }
}

