/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env.bda;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.integration.deployer.env.bda.Archive;
import org.jboss.weld.integration.deployer.env.bda.ArchiveCollection;
import org.jboss.weld.integration.deployer.env.bda.ArchiveFactory;
import org.jboss.weld.integration.deployer.env.bda.ArchiveInfo;
import org.jboss.weld.integration.deployer.env.bda.ArchiveLoader;
import org.jboss.weld.integration.deployer.env.bda.ServiceRegistryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentImpl
implements Deployment {
    private static ArchiveLoader archiveLoader = new ArchiveLoader();
    private String name;
    private final ArchiveCollection archives;
    private final ServiceRegistry services;
    private final ServiceRegistry bdaServices;
    private Collection<Archive> loadedArchives;
    private ServiceRegistryFactory loadedBDAServiceRegistry;
    private Iterable<Metadata<Extension>> extensions;

    public DeploymentImpl(String name, Collection<ArchiveInfo> archiveInfos, Collection<EjbDescriptor<?>> ejbs, EjbServices ejbServices) {
        this.name = name;
        this.archives = new ArchiveCollection();
        this.services = new SimpleServiceRegistry();
        this.bdaServices = new SimpleServiceRegistry();
        for (ArchiveInfo archiveInfo : archiveInfos) {
            this.archives.add(ArchiveFactory.createArchive(archiveInfo, ejbs));
        }
        this.loadedBDAServiceRegistry = new ServiceRegistryFactory(ejbServices);
        this.loadedArchives = new HashSet<Archive>();
    }

    public void initialize(Bootstrap bootstrap) {
        for (Archive archive : this.archives) {
            if (!archive.hasXml()) continue;
            archive.createBeanDeploymentArchive(bootstrap, this.bdaServices);
        }
        this.extensions = bootstrap.loadExtensions(Thread.currentThread().getContextClassLoader());
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return this.archives.getBDAs();
    }

    public ServiceRegistry getServices() {
        return this.services;
    }

    public BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass) {
        Archive archive = archiveLoader.load(beanClass, this);
        this.loadedArchives.add(archive);
        BeanDeploymentArchive bda = archive.getBeanDeploymentArchive();
        if (archive.getBeanDeploymentArchive() == null) {
            ServiceRegistry serviceRegistry = this.loadedBDAServiceRegistry.create();
            bda = archive.createBeanDeploymentArchive(serviceRegistry);
        }
        return bda;
    }

    public <S extends Service> void addBootstrapService(Class<S> type, S service) {
        for (BeanDeploymentArchive beanDeploymentArchive : this.getBeanDeploymentArchives()) {
            beanDeploymentArchive.getServices().add(type, service);
        }
        this.bdaServices.add(type, service);
        this.loadedBDAServiceRegistry.addService(type, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        Iterator<Archive> iterator = this.archives.iterator();
        while (iterator.hasNext()) {
            Archive archive = iterator.next();
            iterator.remove();
            archive.undeploy();
        }
        for (Archive archive : this.loadedArchives) {
            ClassLoader classLoader = archive.getClassLoader();
            synchronized (classLoader) {
                if (archiveLoader.unload(archive, this)) {
                    archive.undeploy();
                }
            }
        }
    }

    public Iterable<Metadata<Extension>> getExtensions() {
        return this.extensions;
    }

    public String toString() {
        return "Deployment[" + this.name + "]";
    }
}

