/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.provider;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.jboss.weld.integration.deployer.env.bda.DUTopLevelClassLoaderGetter;
import org.jboss.weld.integration.deployer.env.bda.TopLevelClassLoaderGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossSingletonProvider
extends SingletonProvider {
    private TopLevelClassLoaderGetter topLevelClassLoaderGetter;

    public void setTopLevelClassLoaderGetter(TopLevelClassLoaderGetter topLevelClassLoaderGetter) {
        this.topLevelClassLoaderGetter = topLevelClassLoaderGetter;
    }

    public void start() {
        if (this.topLevelClassLoaderGetter == null) {
            this.topLevelClassLoaderGetter = DUTopLevelClassLoaderGetter.getInstance();
        }
    }

    public <T> Singleton<T> create(Class<? extends T> expectedType) {
        return new TopLevelSingleton();
    }

    private static ClassLoader getThreadContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TopLevelSingleton<T>
    implements Singleton<T> {
        private final ConcurrentMap<ClassLoader, T> store = new ConcurrentHashMap<ClassLoader, T>();

        private TopLevelSingleton() {
        }

        public T get() {
            ClassLoader currentClassLoader = this.getTopLevelClassLoader();
            Object value = this.store.get(currentClassLoader);
            if (value == null) {
                throw new IllegalStateException("Singleton not set for " + currentClassLoader);
            }
            return (T)value;
        }

        public boolean isSet() {
            return this.store.containsKey(this.getTopLevelClassLoader());
        }

        public void set(T object) {
            this.store.put(this.getTopLevelClassLoader(), object);
        }

        public void clear() {
            this.store.remove(this.getTopLevelClassLoader());
        }

        private ClassLoader getTopLevelClassLoader() {
            return JBossSingletonProvider.this.topLevelClassLoaderGetter.getTopLevelClassLoader(JBossSingletonProvider.getThreadContextClassLoader());
        }
    }
}

