/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.spi.structure.MetaDataEntry;
import org.jboss.deployers.spi.structure.MetaDataType;
import org.jboss.deployers.spi.structure.MetaDataTypeFilter;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.helpers.AbstractDeploymentContext;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSDeploymentContextMBean;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSDeploymentUnit;
import org.jboss.deployers.vfs.plugins.structure.MetaDataMatchFilter;
import org.jboss.deployers.vfs.plugins.structure.SecurityActions;
import org.jboss.deployers.vfs.plugins.structure.VFSDeploymentResourceLoaderImpl;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentResourceLoader;
import org.jboss.logging.Logger;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.util.automount.Automounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractVFSDeploymentContext
extends AbstractDeploymentContext
implements VFSDeploymentContext,
AbstractVFSDeploymentContextMBean {
    private static final long serialVersionUID = 4474515937180482776L;
    private static final Logger log = Logger.getLogger(AbstractVFSDeploymentContext.class);
    private VirtualFile root;
    private Map<VirtualFile, MetaDataType> metaDataLocations;
    private List<VirtualFile> classPath;
    private transient VFSDeploymentResourceLoader loader;

    static final String safeVirtualFileName(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        try {
            return root.toURI().toString();
        }
        catch (Exception e) {
            return root.getName();
        }
    }

    public AbstractVFSDeploymentContext() {
    }

    public AbstractVFSDeploymentContext(String name, String simpleName, VirtualFile root, String relativePath) {
        super(name, simpleName, relativePath);
        this.root = root;
    }

    public AbstractVFSDeploymentContext(VirtualFile root, String relativePath) {
        super(AbstractVFSDeploymentContext.safeVirtualFileName(root), root.getName(), relativePath);
        this.root = root;
    }

    @Override
    public VirtualFile getRoot() {
        return this.root;
    }

    public void setMetaDataPath(List<MetaDataEntry> paths) {
        if (paths == null) {
            this.setMetaDataLocations(null);
            return;
        }
        LinkedHashMap<VirtualFile, MetaDataType> locations = new LinkedHashMap<VirtualFile, MetaDataType>();
        for (MetaDataEntry entry : paths) {
            if (entry == null) {
                throw new IllegalArgumentException("Null entry in paths: " + paths);
            }
            String path = entry.getPath();
            VirtualFile child = this.root.getChild(path);
            if (child != null) {
                locations.put(child, entry.getType());
                continue;
            }
            log.debugf("Meta data path does not exist: root=%1s path=%2s", (Object)this.root.getPathName(), (Object)path);
        }
        this.setMetaDataLocationsMap(locations);
    }

    @Override
    public List<VirtualFile> getMetaDataLocations() {
        return this.getMetaDataLocations(MetaDataTypeFilter.DEFAULT);
    }

    public List<VirtualFile> getMetaDataLocations(MetaDataTypeFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Null filter");
        }
        if (this.metaDataLocations == null || this.metaDataLocations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Map.Entry<VirtualFile, MetaDataType> entry : this.metaDataLocations.entrySet()) {
            if (!filter.accepts(entry.getValue())) continue;
            VirtualFile location = entry.getKey();
            result.add(location);
        }
        return result;
    }

    public void setMetaDataLocations(List<VirtualFile> locations) {
        LinkedHashMap<VirtualFile, MetaDataType> locationsMap = null;
        if (locations != null) {
            locationsMap = new LinkedHashMap<VirtualFile, MetaDataType>();
            for (VirtualFile file : locations) {
                locationsMap.put(file, MetaDataType.DEFAULT);
            }
        }
        this.setMetaDataLocationsMap(locationsMap);
    }

    protected void setMetaDataLocationsMap(Map<VirtualFile, MetaDataType> locations) {
        this.metaDataLocations = locations;
    }

    public VirtualFile getMetaDataFile(String name) {
        return this.getMetaDataFile(name, MetaDataTypeFilter.DEFAULT);
    }

    public VirtualFile getMetaDataFile(String name, MetaDataTypeFilter filter) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Null filter");
        }
        try {
            if (this.metaDataLocations == null || this.metaDataLocations.isEmpty()) {
                String fileName;
                if (this.root != null && this.root.exists() && SecurityActions.isLeaf(this.root) && (fileName = this.root.getName()).equals(name)) {
                    return this.root;
                }
                return null;
            }
            return this.searchMetaDataLocations(name, filter);
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Error retrieving meta data: " + name + " reason=" + e));
            }
            return null;
        }
    }

    protected VirtualFile searchMetaDataLocations(String name) {
        return this.searchMetaDataLocations(name, MetaDataTypeFilter.DEFAULT);
    }

    protected VirtualFile searchMetaDataLocations(String name, MetaDataTypeFilter filter) {
        VirtualFile result = null;
        for (Map.Entry<VirtualFile, MetaDataType> entry : this.metaDataLocations.entrySet()) {
            VirtualFile location;
            if (!filter.accepts(entry.getValue()) || !(result = (location = entry.getKey()).getChild(name)).exists()) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Found " + name + " in " + location.getName()));
            }
            this.deployed();
            break;
        }
        return result != null && result.exists() ? result : null;
    }

    public List<VirtualFile> getMetaDataFiles(String name, String suffix) {
        return this.getMetaDataFiles(name, suffix, MetaDataTypeFilter.DEFAULT);
    }

    public List<VirtualFile> getMetaDataFiles(String name, String suffix, MetaDataTypeFilter mdtf) {
        if (name == null && suffix == null) {
            throw new IllegalArgumentException("Null name and suffix");
        }
        MetaDataMatchFilter filter = new MetaDataMatchFilter(name, suffix);
        return this.getMetaDataFiles((VirtualFileFilter)filter, mdtf);
    }

    public List<VirtualFile> getMetaDataFiles(VirtualFileFilter filter) {
        return this.getMetaDataFiles(filter, MetaDataTypeFilter.DEFAULT);
    }

    public List<VirtualFile> getMetaDataFiles(VirtualFileFilter filter, MetaDataTypeFilter mdtf) {
        if (filter == null || mdtf == null) {
            throw new IllegalArgumentException("Null filter - VFS or MetaDataType: vfs=" + filter + ", mdt=" + mdtf);
        }
        try {
            if (this.metaDataLocations == null || this.metaDataLocations.isEmpty()) {
                if (this.root != null && SecurityActions.isLeaf(this.root) && filter.accepts(this.root)) {
                    return Collections.singletonList(this.root);
                }
                return Collections.emptyList();
            }
            ArrayList<VirtualFile> results = new ArrayList<VirtualFile>();
            for (Map.Entry<VirtualFile, MetaDataType> entry : this.metaDataLocations.entrySet()) {
                VirtualFile location;
                List result;
                if (!mdtf.accepts(entry.getValue()) || (result = (location = entry.getKey()).getChildren(filter)) == null || result.isEmpty()) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Found results with " + filter + " in " + location.getName()));
                }
                results.addAll(result);
                this.deployed();
            }
            return results;
        }
        catch (Exception e) {
            log.debugf((Throwable)e, "Error retrieving meta data: filter=%1s", (Object)filter);
            return Collections.emptyList();
        }
    }

    public void prependMetaDataLocation(VirtualFile ... locations) {
        if (locations == null) {
            throw new IllegalArgumentException("Null locations");
        }
        LinkedHashMap<VirtualFile, MetaDataType> locationsMap = new LinkedHashMap<VirtualFile, MetaDataType>();
        for (int i = locations.length - 1; i >= 0; --i) {
            VirtualFile location = locations[i];
            if (location == null) {
                throw new IllegalArgumentException("Null virtual file in " + Arrays.toString(locations));
            }
            locationsMap.put(location, MetaDataType.DEFAULT);
        }
        if (this.metaDataLocations != null) {
            locationsMap.putAll(this.metaDataLocations);
        }
        this.setMetaDataLocationsMap(locationsMap);
    }

    public void appendMetaDataLocation(VirtualFile ... locations) {
        if (locations == null) {
            throw new IllegalArgumentException("Null location");
        }
        LinkedHashMap<VirtualFile, MetaDataType> locationsMap = new LinkedHashMap<VirtualFile, MetaDataType>();
        if (this.metaDataLocations != null) {
            locationsMap.putAll(this.metaDataLocations);
        }
        for (VirtualFile location : locations) {
            if (location == null) {
                throw new IllegalArgumentException("Null virtual file in " + Arrays.toString(locations));
            }
            locationsMap.put(location, MetaDataType.DEFAULT);
        }
        this.setMetaDataLocationsMap(locationsMap);
    }

    public void removeMetaDataLocation(VirtualFile ... locations) {
        if (locations == null || locations.length == 0) {
            return;
        }
        for (VirtualFile location : locations) {
            this.metaDataLocations.remove(location);
        }
    }

    public VirtualFile getFile(String name) {
        return this.getResourceLoader().getFile(name);
    }

    protected List<VirtualFile> getMutableClassPath() {
        return this.classPath;
    }

    @Override
    public List<VirtualFile> getClassPath() {
        if (this.classPath == null || this.classPath.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.classPath);
    }

    public void setClassPath(List<VirtualFile> paths) {
        this.classPath = paths;
        if (log.isTraceEnabled() && paths != null) {
            log.trace((Object)("ClassPath for " + this.root.getPathName() + " is " + VFSUtils.getPathsString(paths)));
        }
    }

    public void appendClassPath(List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException("Null files");
        }
        List<VirtualFile> classPath = this.getMutableClassPath();
        if (classPath == null) {
            classPath = new ArrayList<VirtualFile>();
        }
        for (VirtualFile file : files) {
            if (file == null) {
                throw new IllegalArgumentException("Null virtual file in " + files);
            }
            classPath.add(file);
        }
        this.setClassPath(classPath);
    }

    public void prependClassPath(VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException("Null files");
        }
        List<VirtualFile> classPath = this.getMutableClassPath();
        if (classPath == null) {
            classPath = new ArrayList<VirtualFile>();
        }
        for (int i = files.length - 1; i >= 0; --i) {
            VirtualFile file = files[i];
            if (file == null) {
                throw new IllegalArgumentException("Null virtual file in " + Arrays.toString(files));
            }
            classPath.add(0, file);
        }
        this.setClassPath(classPath);
    }

    public void prependClassPath(List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException("Null files");
        }
        List<VirtualFile> classPath = this.getMutableClassPath();
        if (classPath == null) {
            classPath = new ArrayList<VirtualFile>();
        }
        for (int i = files.size() - 1; i >= 0; --i) {
            VirtualFile file = files.get(i);
            if (file == null) {
                throw new IllegalArgumentException("Null virtual file in " + files);
            }
            classPath.add(0, file);
        }
        this.setClassPath(classPath);
    }

    public void appendClassPath(VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException("Null files");
        }
        List<VirtualFile> classPath = this.getMutableClassPath();
        if (classPath == null) {
            classPath = new ArrayList<VirtualFile>();
        }
        for (VirtualFile file : files) {
            if (file == null) {
                throw new IllegalArgumentException("Null virtual file in " + Arrays.toString(files));
            }
            classPath.add(file);
        }
        this.setClassPath(classPath);
    }

    public void removeClassPath(VirtualFile ... files) {
        if (files == null || files.length == 0) {
            return;
        }
        for (VirtualFile file : files) {
            this.classPath.remove(file);
        }
    }

    public VFSDeploymentContext getTopLevel() {
        return (VFSDeploymentContext)super.getTopLevel();
    }

    public VFSDeploymentResourceLoader getResourceLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        this.loader = new VFSDeploymentResourceLoaderImpl(this.getRoot());
        return this.loader;
    }

    protected DeploymentUnit createDeploymentUnit() {
        return new AbstractVFSDeploymentUnit(this);
    }

    public void cleanup() {
        Automounter.cleanup((VirtualFile)this.root);
        super.cleanup();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.root = (VirtualFile)in.readObject();
        boolean isNullOrEmpty = in.readBoolean();
        if (!isNullOrEmpty) {
            this.metaDataLocations = (Map)in.readObject();
        }
        this.classPath = (List)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.root);
        boolean isNullOrEmpty = this.metaDataLocations == null || this.metaDataLocations.isEmpty();
        out.writeBoolean(isNullOrEmpty);
        if (!isNullOrEmpty) {
            out.writeObject(this.metaDataLocations);
        }
        out.writeObject(this.classPath);
    }
}

