/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure.link;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.deployers.vfs.spi.structure.StructureDeployer;
import org.jboss.logging.Logger;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.util.automount.Automounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSLinkStructureDeployer
implements StructureDeployer {
    protected static final Logger log = Logger.getLogger((String)"org.jboss.deployers.vfs.structure");
    public static final String VFS_LINK_PROPERTIES_SUFFIX = ".vfslink.properties";
    public static final String VFS_LINK_NAME = "vfs.link.name";
    public static final String VFS_LINK_TARGET = "vfs.link.target";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean determineStructure(StructureContext context) throws DeploymentException {
        VirtualFile root = context.getFile();
        VirtualFile vfslinks = root.getChild("META-INF/jboss-vfslinks.txt");
        if (vfslinks.exists()) {
            try {
                InputStream is = vfslinks.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("#")) continue;
                        this.mountLinks(context, line);
                    }
                }
                finally {
                    VFSUtils.safeClose((Closeable)is);
                }
            }
            catch (IOException e) {
                throw DeploymentException.rethrowAsDeploymentException((String)"Cannot read jboss-vfslinks.txt", (Throwable)e);
            }
        }
        return false;
    }

    protected void mountLinks(StructureContext context, String path) throws IOException {
        VirtualFile root = context.getFile();
        VirtualFile link = root.getChild(path + VFS_LINK_PROPERTIES_SUFFIX);
        if (link.exists()) {
            ArrayList<LinkInfo> links = new ArrayList<LinkInfo>();
            this.parseLinkProperties(link, links);
            this.mountLinks(context, link.getParent(), path, links);
        } else {
            log.warn((Object)("No .vfslink.properties match for link: " + path));
        }
    }

    protected void parseLinkProperties(VirtualFile link, List<LinkInfo> links) throws IOException {
        InputStream is = link.openStream();
        try {
            Properties props = new Properties();
            props.load(is);
            int n = 0;
            while (true) {
                String nameKey = "vfs.link.name." + n;
                String name = props.getProperty(nameKey);
                String uriKey = "vfs.link.target." + n;
                String uri = props.getProperty(uriKey);
                if (uri == null) {
                    break;
                }
                uri = StringPropertyReplacer.replaceProperties((String)uri);
                LinkInfo li = new LinkInfo(name, new URI(uri));
                links.add(li);
                ++n;
            }
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            VFSUtils.safeClose((Closeable)is);
        }
    }

    protected void mountLinks(StructureContext context, VirtualFile parent, String path, List<LinkInfo> links) throws IOException {
        VirtualFile root = context.getFile();
        VirtualFile link = parent.getChild(path);
        for (LinkInfo li : links) {
            VirtualFile linkChild = link.getChild(li.name);
            Closeable closeable = VFS.mountReal((File)new File(li.uri), (VirtualFile)linkChild);
            Automounter.addHandle((VirtualFile)root, (Closeable)closeable);
        }
    }

    public boolean isSupportsCandidateAnnotations() {
        return false;
    }

    public int getRelativeOrder() {
        return -2147483638;
    }

    public void setRelativeOrder(int order) {
    }

    private static class LinkInfo {
        private String name;
        private URI uri;

        private LinkInfo(String name, URI uri) {
            this.name = name;
            this.uri = uri;
        }
    }
}

