/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb.jboss;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.LocalHome;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.creator.ejb.AbstractHomeProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

public class LocalHomeProcessor
extends AbstractHomeProcessor
implements Processor<JBossSessionBeanMetaData, Class<?>> {
    public LocalHomeProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public void process(JBossSessionBeanMetaData metaData, Class<?> type) {
        LocalHome annotation = (LocalHome)this.finder.getAnnotation(type, LocalHome.class);
        if (annotation == null) {
            return;
        }
        Class localHome = annotation.value();
        if (!EJBLocalHome.class.isAssignableFrom(localHome)) {
            throw new IllegalStateException("Declared EJB 2.1 Home Interface " + localHome.getName() + " does not extend " + EJBLocalHome.class.getName() + " as required by EJB 3.0 Core Specification 4.6.10");
        }
        metaData.setLocalHome(localHome.getName());
        this.setLocal(metaData, localHome, metaData.isStateless());
    }

    private void setLocal(JBossSessionBeanMetaData metaData, Class<?> localHome, boolean isStateless) {
        Class<?> businessInterface = LocalHomeProcessor.getCreateReturnSignature(localHome, metaData.isStateless());
        if (!EJBLocalObject.class.isAssignableFrom(businessInterface)) {
            throw new IllegalStateException("EJB 3.0 Core Specification Violation (4.6.9): The session bean\u2019s local interface " + businessInterface + " must extend the javax.ejb.EJBLocalObject interface.");
        }
        if (metaData.getLocal() != null && !metaData.getLocal().equals(businessInterface.getName())) {
            throw new IllegalStateException("2.1 bean " + metaData.getEjbName() + " already has a local interface " + metaData.getLocal() + ", can't add " + businessInterface.getName());
        }
        metaData.setLocal(businessInterface.getName());
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(LocalHome.class);
    }
}

