/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.ssl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLSupport {
    public static SSLContext createServerContext(String keystorePath, String keystorePassword, String trustStorePath, String trustStorePassword) throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        KeyManager[] keyManagers = SSLSupport.loadKeyManagers(keystorePath, keystorePassword);
        TrustManager[] trustManagers = SSLSupport.loadTrustManager(false, trustStorePath, trustStorePassword);
        sslContext.init(keyManagers, trustManagers, new SecureRandom());
        return sslContext;
    }

    public static SSLContext createClientContext(String keystorePath, String keystorePassword) throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        KeyManager[] keyManagers = SSLSupport.loadKeyManagers(keystorePath, keystorePassword);
        TrustManager[] trustManagers = SSLSupport.loadTrustManager(true, null, null);
        context.init(keyManagers, trustManagers, new SecureRandom());
        return context;
    }

    public static SSLContext getInstance(boolean client, String keystorePath, String keystorePassword, String trustStorePath, String trustStorePassword) throws GeneralSecurityException, Exception {
        if (client) {
            return SSLSupport.createClientContext(keystorePath, keystorePassword);
        }
        return SSLSupport.createServerContext(keystorePath, keystorePassword, trustStorePath, trustStorePassword);
    }

    private static TrustManager[] loadTrustManager(boolean clientMode, String trustStorePath, String trustStorePassword) throws Exception {
        if (clientMode) {
            return new TrustManager[]{new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
        }
        KeyStore trustStore = SSLSupport.loadKeystore(trustStorePath, trustStorePassword);
        TrustManagerFactory trustMgrFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustMgrFactory.init(trustStore);
        return trustMgrFactory.getTrustManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeystore(String keystorePath, String keystorePassword) throws Exception {
        assert (keystorePath != null);
        assert (keystorePassword != null);
        KeyStore ks = KeyStore.getInstance("JKS");
        InputStream in = null;
        try {
            URL keystoreURL = SSLSupport.validateStoreURL(keystorePath);
            in = keystoreURL.openStream();
            ks.load(in, keystorePassword.toCharArray());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
        return ks;
    }

    private static KeyManager[] loadKeyManagers(String keystorePath, String keystorePassword) throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = SSLSupport.loadKeystore(keystorePath, keystorePassword);
        kmf.init(ks, keystorePassword.toCharArray());
        return kmf.getKeyManagers();
    }

    private static URL validateStoreURL(String storePath) throws Exception {
        assert (storePath != null);
        try {
            return new URL(storePath);
        }
        catch (MalformedURLException e) {
            File file = new File(storePath);
            if (file.exists() && file.isFile()) {
                return file.toURI().toURL();
            }
            URL url = Thread.currentThread().getContextClassLoader().getResource(storePath);
            if (url != null) {
                return url;
            }
            throw new Exception("Failed to find a store at " + storePath);
        }
    }
}

