/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.mc.resource.provider;

import java.util.Collection;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.switchboard.impl.resource.IndependentResource;
import org.jboss.switchboard.impl.resource.LinkRefResource;
import org.jboss.switchboard.javaee.environment.InjectionTarget;
import org.jboss.switchboard.javaee.environment.SimpleEnvironmentEntryType;
import org.jboss.switchboard.javaee.util.InjectionTargetUtil;
import org.jboss.switchboard.mc.spi.MCBasedResourceProvider;
import org.jboss.switchboard.spi.Resource;

public class EnvEntryResourceProvider
implements MCBasedResourceProvider<SimpleEnvironmentEntryType> {
    private static Logger logger = Logger.getLogger(EnvEntryResourceProvider.class);

    public Resource provide(DeploymentUnit deploymentUnit, SimpleEnvironmentEntryType envEntry) {
        String lookupName = envEntry.getLookupName();
        if (lookupName != null && !lookupName.trim().isEmpty()) {
            return new LinkRefResource(lookupName);
        }
        String mappedName = envEntry.getMappedName();
        if (mappedName != null && !mappedName.trim().isEmpty()) {
            return new LinkRefResource(mappedName);
        }
        ClassLoader cl = deploymentUnit.getClassLoader();
        Object targetValue = this.getEnvEntryValue(cl, envEntry);
        IndependentResource resource = new IndependentResource(targetValue);
        return resource;
    }

    public Class<SimpleEnvironmentEntryType> getEnvironmentEntryType() {
        return SimpleEnvironmentEntryType.class;
    }

    private Object getEnvEntryValue(ClassLoader cl, SimpleEnvironmentEntryType envEntry) {
        String value = envEntry.getValue();
        if (value == null) {
            return null;
        }
        Class<?> envEntryType = this.getEnvEntryType(cl, envEntry);
        if (envEntryType == null) {
            return value;
        }
        if (envEntryType.equals(String.class)) {
            return value;
        }
        if (envEntryType.equals(Integer.class) || envEntryType.equals(Integer.TYPE)) {
            return new Integer(value);
        }
        if (envEntryType.equals(Long.class) || envEntryType.equals(Long.TYPE)) {
            return new Long(value);
        }
        if (envEntryType.equals(Double.class) || envEntryType.equals(Double.TYPE)) {
            return new Double(value);
        }
        if (envEntryType.equals(Float.class) || envEntryType.equals(Float.TYPE)) {
            return new Float(value);
        }
        if (envEntryType.equals(Byte.class) || envEntryType.equals(Byte.TYPE)) {
            return new Byte(value);
        }
        if (envEntryType.equals(Character.class) || envEntryType.equals(Character.TYPE)) {
            if (value == null || value.length() == 0) {
                return new Character('\u0000');
            }
            if (value.length() > 1) {
                logger.warn((Object)("Warning character env-entry is too long: binding=" + envEntry.getName() + " value=" + value));
            }
            return new Character(value.charAt(0));
        }
        if (envEntryType.equals(Short.class) || envEntryType.equals(Short.TYPE)) {
            return new Short(value);
        }
        if (envEntryType.equals(Boolean.class) || envEntryType.equals(Boolean.TYPE)) {
            return new Boolean(value);
        }
        if (envEntryType.equals(Class.class)) {
            try {
                return Class.forName(value, true, cl);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not load class: " + value + " for env-entry: " + envEntry.getName(), cnfe);
            }
        }
        if (envEntryType.isEnum()) {
            return Enum.valueOf(envEntryType, value);
        }
        return value;
    }

    private Class<?> getEnvEntryType(ClassLoader cl, SimpleEnvironmentEntryType envEntry) {
        String explicitType = envEntry.getType();
        if (explicitType != null && !explicitType.trim().isEmpty()) {
            try {
                return this.loadClass(explicitType, cl);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not load class: " + explicitType + " for env-entry: " + envEntry.getName(), cnfe);
            }
        }
        Collection injectionTargets = envEntry.getInjectionTargets();
        if (injectionTargets == null || injectionTargets.isEmpty()) {
            return null;
        }
        InjectionTarget injectionTarget = (InjectionTarget)injectionTargets.iterator().next();
        Class type = InjectionTargetUtil.getInjectionTargetPropertyType((ClassLoader)cl, (InjectionTarget)injectionTarget);
        return type;
    }

    private Class<?> loadClass(String className, ClassLoader cl) throws ClassNotFoundException {
        if (className.equals(Void.TYPE.getName())) {
            return Void.TYPE;
        }
        if (className.equals(Byte.TYPE.getName())) {
            return Byte.TYPE;
        }
        if (className.equals(Short.TYPE.getName())) {
            return Short.TYPE;
        }
        if (className.equals(Integer.TYPE.getName())) {
            return Integer.TYPE;
        }
        if (className.equals(Long.TYPE.getName())) {
            return Long.TYPE;
        }
        if (className.equals(Character.TYPE.getName())) {
            return Character.TYPE;
        }
        if (className.equals(Boolean.TYPE.getName())) {
            return Boolean.TYPE;
        }
        if (className.equals(Float.TYPE.getName())) {
            return Float.TYPE;
        }
        if (className.equals(Double.TYPE.getName())) {
            return Double.TYPE;
        }
        return Class.forName(className, false, cl);
    }
}

