/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl;

import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import org.jboss.ha.framework.interfaces.ObjectStreamSource;
import org.jboss.ha.framework.server.MarshalledValueHelper;
import org.jboss.ha.framework.server.SimpleCachableMarshalledValue;
import org.jboss.util.loading.ContextClassLoaderSwitcher;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.SessionAttributeMarshaller;

public class SessionAttributeMarshallerImpl
implements SessionAttributeMarshaller {
    private final ContextClassLoaderSwitcher switcher = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
    private final LocalDistributableSessionManager manager;
    private final ObjectStreamSource source;

    public SessionAttributeMarshallerImpl(LocalDistributableSessionManager manager, ObjectStreamSource source) {
        this.manager = manager;
        this.source = source;
    }

    public Object marshal(Object value) {
        if (value == null || MarshalledValueHelper.isTypeExcluded(value.getClass())) {
            return value;
        }
        if (!(value instanceof Serializable)) {
            throw new IllegalArgumentException(String.format("%s does not implement %s", value, Serializable.class.getName()));
        }
        return new SimpleCachableMarshalledValue((Serializable)value, this.source, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Object object) throws IOException, ClassNotFoundException {
        if (object == null || !(object instanceof SimpleCachableMarshalledValue)) {
            return object;
        }
        SimpleCachableMarshalledValue value = (SimpleCachableMarshalledValue)object;
        ContextClassLoaderSwitcher.SwitchContext switchContext = this.switcher.getSwitchContext(this.manager.getApplicationClassLoader());
        try {
            value.setObjectStreamSource(this.source);
            Serializable serializable = value.get();
            return serializable;
        }
        finally {
            switchContext.reset();
        }
    }
}

