/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.plugins.jmx;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.jmx.ClassLoadingMXBeanMO;
import org.jboss.managed.plugins.jmx.GarbageCollectorMXBeanMO;
import org.jboss.managed.plugins.jmx.MemoryMXBeanMO;
import org.jboss.managed.plugins.jmx.MemoryManagerMXBeanMO;
import org.jboss.managed.plugins.jmx.MemoryPoolMXBeanMO;
import org.jboss.managed.plugins.jmx.OperatingSystemMXBeanMO;
import org.jboss.managed.plugins.jmx.RuntimeMXBeanMO;
import org.jboss.managed.plugins.jmx.ThreadMXBeanMO;
import org.jboss.metadata.plugins.loader.reflection.AnnotatedElementMetaDataLoader;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalToMetaDataBridge;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.EnumMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.ArrayValue;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementFactoryUtils {
    public static Map<String, ManagedObject> getPlatformMBeanMOs(ManagedObjectFactory mof) {
        HashMap<String, ManagedObject> mos = new HashMap<String, ManagedObject>();
        ManagedObject classLoadingMO = ManagementFactoryUtils.getClassLoadingMO(mof);
        mos.put(classLoadingMO.getName(), classLoadingMO);
        ManagedObject memoryMXBean = ManagementFactoryUtils.getMemoryMXBean(mof);
        mos.put(memoryMXBean.getName(), memoryMXBean);
        ManagedObject operatingSystemMXBean = ManagementFactoryUtils.getOperatingSystemMXBean(mof);
        mos.put(operatingSystemMXBean.getName(), operatingSystemMXBean);
        ManagedObject threadMXBean = ManagementFactoryUtils.getThreadMXBean(mof);
        mos.put(threadMXBean.getName(), threadMXBean);
        ManagedObject runtimeMXBean = ManagementFactoryUtils.getRuntimeMXBean(mof);
        mos.put(runtimeMXBean.getName(), runtimeMXBean);
        return mos;
    }

    public static ManagedObject getClassLoadingMO(ManagedObjectFactory mof) {
        ClassLoadingMXBean mbean = ManagementFactory.getClassLoadingMXBean();
        ManagedObject mo = ManagementFactoryUtils.getMO(mbean, ClassLoadingMXBeanMO.class, mof);
        return mo;
    }

    public static ManagedObject getMemoryMXBean(ManagedObjectFactory mof) {
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        ManagedObject mo = ManagementFactoryUtils.getMO(mbean, MemoryMXBeanMO.class, mof);
        return mo;
    }

    public static ManagedObject getOperatingSystemMXBean(ManagedObjectFactory mof) {
        OperatingSystemMXBean mbean = ManagementFactory.getOperatingSystemMXBean();
        ManagedObject mo = ManagementFactoryUtils.getMO(mbean, OperatingSystemMXBeanMO.class, mof);
        return mo;
    }

    public static ManagedObject getThreadMXBean(ManagedObjectFactory mof) {
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        ManagedObject mo = ManagementFactoryUtils.getMO(mbean, ThreadMXBeanMO.class, mof);
        return mo;
    }

    public static ManagedObject getRuntimeMXBean(ManagedObjectFactory mof) {
        RuntimeMXBean mbean = ManagementFactory.getRuntimeMXBean();
        ManagedObject mo = ManagementFactoryUtils.getMO(mbean, RuntimeMXBeanMO.class, mof);
        return mo;
    }

    public static List<ManagedObject> getMemoryManagerMXBeans(ManagedObjectFactory mof) {
        List<MemoryManagerMXBean> mbeans = ManagementFactory.getMemoryManagerMXBeans();
        ArrayList<ManagedObject> mos = new ArrayList<ManagedObject>();
        for (MemoryManagerMXBean mbean : mbeans) {
            ManagedObject mo = ManagementFactoryUtils.getMO(mbean, MemoryManagerMXBeanMO.class, mof);
            mos.add(mo);
        }
        return mos;
    }

    public static List<ManagedObject> getGarbageCollectorMXBeans(ManagedObjectFactory mof) {
        List<GarbageCollectorMXBean> mbeans = ManagementFactory.getGarbageCollectorMXBeans();
        ArrayList<ManagedObject> mos = new ArrayList<ManagedObject>();
        for (GarbageCollectorMXBean mbean : mbeans) {
            ManagedObject mo = ManagementFactoryUtils.getMO(mbean, GarbageCollectorMXBeanMO.class, mof);
            mos.add(mo);
        }
        return mos;
    }

    public static List<ManagedObject> getMemoryPoolMXBeans(ManagedObjectFactory mof) {
        List<MemoryPoolMXBean> mbeans = ManagementFactory.getMemoryPoolMXBeans();
        ArrayList<ManagedObject> mos = new ArrayList<ManagedObject>();
        for (MemoryPoolMXBean mbean : mbeans) {
            ManagedObject mo = ManagementFactoryUtils.getMO(mbean, MemoryPoolMXBeanMO.class, mof);
            mos.add(mo);
        }
        return mos;
    }

    public static MemoryUsage unwrapMemoryUsage(CompositeValue mv) {
        SimpleValue committedSV = (SimpleValue)SimpleValue.class.cast(mv.get("committed"));
        SimpleValue initSV = (SimpleValue)SimpleValue.class.cast(mv.get("init"));
        SimpleValue maxSV = (SimpleValue)SimpleValue.class.cast(mv.get("max"));
        SimpleValue usedSV = (SimpleValue)SimpleValue.class.cast(mv.get("used"));
        long committed = (Long)committedSV.getValue();
        long init = (Long)initSV.getValue();
        long max = (Long)maxSV.getValue();
        long used = (Long)usedSV.getValue();
        MemoryUsage mu = new MemoryUsage(init, used, committed, max);
        return mu;
    }

    public static <I> ManagedObject getMO(I mbean, Class<? extends I> c, ManagedObjectFactory mof) {
        Class<? extends I> mbeanClass = c;
        AnnotatedElementMetaDataLoader retrieval = new AnnotatedElementMetaDataLoader(mbeanClass);
        MetaDataRetrievalToMetaDataBridge metaData = new MetaDataRetrievalToMetaDataBridge((MetaDataRetrieval)retrieval);
        ManagedObject mo = mof.initManagedObject(mbean, c, (MetaData)metaData, null, null);
        return mo;
    }

    public static ThreadInfo unwrapThreadInfo(CompositeValue mv) throws OpenDataException, ClassNotFoundException {
        CompositeData cd = (CompositeData)ManagementFactoryUtils.getOpenValue((MetaValue)mv);
        ThreadInfo ti = ThreadInfo.from(cd);
        return ti;
    }

    static OpenType getOpenType(MetaType type) throws OpenDataException {
        OpenType openType = null;
        if (type instanceof SimpleMetaType) {
            openType = ManagementFactoryUtils.getOpenType((SimpleMetaType)SimpleMetaType.class.cast(type));
        } else if (type instanceof CompositeMetaType) {
            openType = ManagementFactoryUtils.getOpenType((CompositeMetaType)CompositeMetaType.class.cast(type));
        } else if (type instanceof ArrayMetaType) {
            openType = ManagementFactoryUtils.getOpenType((ArrayMetaType)ArrayMetaType.class.cast(type));
        } else if (type instanceof EnumMetaType) {
            openType = SimpleType.STRING;
        } else {
            throw new OpenDataException("Unhandled MetaType: " + type);
        }
        return openType;
    }

    static OpenType getOpenType(SimpleMetaType type) {
        SimpleType<Object> openType = null;
        if (type.equalsIgnorePrimitive((Object)SimpleMetaType.BOOLEAN)) {
            openType = SimpleType.BOOLEAN;
        } else if (type.equalsIgnorePrimitive((Object)SimpleMetaType.BYTE)) {
            openType = SimpleType.BYTE;
        } else if (type.equalsIgnorePrimitive((Object)SimpleMetaType.CHARACTER)) {
            openType = SimpleType.CHARACTER;
        } else if (type.equalsIgnorePrimitive((Object)SimpleMetaType.LONG)) {
            openType = SimpleType.LONG;
        } else if (type.equalsIgnorePrimitive((Object)SimpleMetaType.INTEGER)) {
            openType = SimpleType.INTEGER;
        } else if (type.equalsIgnorePrimitive((Object)SimpleMetaType.SHORT)) {
            openType = SimpleType.SHORT;
        } else if (type.equalsIgnorePrimitive((Object)SimpleMetaType.STRING)) {
            openType = SimpleType.STRING;
        }
        return openType;
    }

    static ArrayType getOpenType(ArrayMetaType type) throws OpenDataException {
        int dimension = type.getDimension();
        OpenType elementType = ManagementFactoryUtils.getOpenType(type.getElementType());
        ArrayType openType = new ArrayType(dimension, elementType);
        return openType;
    }

    static CompositeType getOpenType(CompositeMetaType type) throws OpenDataException {
        String[] items = new String[type.itemSet().size()];
        type.itemSet().toArray(items);
        String[] descriptions = new String[type.itemSet().size()];
        OpenType[] itemTypes = new OpenType[items.length];
        for (int n = 0; n < items.length; ++n) {
            String item = items[n];
            descriptions[n] = type.getDescription(item);
            MetaType mt = type.getType(item);
            itemTypes[n] = ManagementFactoryUtils.getOpenType(mt);
        }
        CompositeType ct = new CompositeType(type.getTypeName(), type.getDescription(), items, descriptions, itemTypes);
        return ct;
    }

    static Object getOpenValue(MetaValue mv) throws OpenDataException {
        Object openValue = null;
        if (mv instanceof SimpleValue) {
            SimpleValue sv = (SimpleValue)SimpleValue.class.cast(mv);
            openValue = sv.getValue();
        } else if (mv instanceof CompositeValue) {
            CompositeValue cv = (CompositeValue)CompositeValue.class.cast(mv);
            HashMap itemsMap = new HashMap();
            CompositeMetaType cmt = cv.getMetaType();
            String[] items = new String[cmt.itemSet().size()];
            Object[] itemValues = new Object[items.length];
            cmt.itemSet().toArray(items);
            for (int n = 0; n < items.length; ++n) {
                String item = items[n];
                MetaValue itemMV = cv.get(item);
                Object itemValue = null;
                if (itemMV != null) {
                    itemValue = ManagementFactoryUtils.getOpenValue(itemMV);
                }
                itemValues[n] = itemValue;
            }
            CompositeType ct = ManagementFactoryUtils.getOpenType(cmt);
            CompositeDataSupport cd = new CompositeDataSupport(ct, items, itemValues);
            openValue = cd;
        } else if (mv instanceof ArrayValue) {
            ArrayValue av = (ArrayValue)ArrayValue.class.cast(mv);
            if (av.getMetaType().isPrimitiveArray() || av.getMetaType().isSimple()) {
                openValue = av.getValue();
            } else if (av.getMetaType().getElementType().isComposite()) {
                CompositeData[] cd = new CompositeData[av.getLength()];
                for (int n = 0; n < av.getLength(); ++n) {
                    cd[n] = (CompositeData)ManagementFactoryUtils.getOpenValue((MetaValue)CompositeValue.class.cast(av.getValue(n)));
                }
                openValue = cd;
            }
        } else if (mv instanceof EnumValue) {
            EnumValue ev = (EnumValue)EnumValue.class.cast(mv);
            openValue = ev.getValue();
        } else {
            throw new OpenDataException("Unhandled MetaValue: " + mv);
        }
        return openValue;
    }

    static MetaType getMetaType(OpenType type) throws Exception {
        SimpleMetaType metaType = null;
        if (type instanceof SimpleType) {
            metaType = ManagementFactoryUtils.getMetaType((SimpleType)SimpleType.class.cast(type));
        } else if (type instanceof CompositeType) {
            metaType = ManagementFactoryUtils.getMetaType((CompositeType)CompositeType.class.cast(type));
        } else if (type instanceof ArrayType) {
            metaType = ManagementFactoryUtils.getMetaType((ArrayType)ArrayType.class.cast(type));
        } else {
            throw new Exception("Unhandled OpenType: " + type);
        }
        return metaType;
    }

    static SimpleMetaType getMetaType(SimpleType type) {
        SimpleMetaType metaType = null;
        if (type == SimpleType.BOOLEAN) {
            metaType = SimpleMetaType.BOOLEAN;
        } else if (type == SimpleType.BYTE) {
            metaType = SimpleMetaType.BYTE;
        } else if (type == SimpleType.CHARACTER) {
            metaType = SimpleMetaType.CHARACTER;
        } else if (type == SimpleType.LONG) {
            metaType = SimpleMetaType.LONG;
        } else if (type == SimpleType.INTEGER) {
            metaType = SimpleMetaType.INTEGER;
        } else if (type == SimpleType.SHORT) {
            metaType = SimpleMetaType.SHORT;
        } else if (type == SimpleType.STRING) {
            metaType = SimpleMetaType.STRING;
        }
        return metaType;
    }

    static ArrayMetaType getMetaType(ArrayType type) throws Exception {
        int dimension = type.getDimension();
        OpenType<?> elementType = type.getElementOpenType();
        MetaType elementMetaType = ManagementFactoryUtils.getMetaType(elementType);
        ArrayMetaType metaType = new ArrayMetaType(dimension, elementMetaType);
        return metaType;
    }

    static CompositeMetaType getMetaType(CompositeType type) throws Exception {
        String[] itemNames = new String[type.keySet().size()];
        String[] itemDescriptions = new String[itemNames.length];
        MetaType[] itemTypes = new MetaType[itemNames.length];
        type.keySet().toArray(itemNames);
        for (int n = 0; n < itemNames.length; ++n) {
            String itemName = itemNames[n];
            itemDescriptions[n] = type.getDescription(itemName);
            OpenType<?> ot = type.getType(itemName);
            itemTypes[n] = ManagementFactoryUtils.getMetaType(ot);
        }
        String typeName = type.getTypeName();
        String description = type.getDescription();
        ImmutableCompositeMetaType cmt = new ImmutableCompositeMetaType(typeName, description, itemNames, itemDescriptions, itemTypes);
        return cmt;
    }
}

