/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.faces.model.DataModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataModel<E>
implements Iterable<E> {
    private List<DataModelListener> _listeners;

    public void addDataModelListener(DataModelListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this._listeners == null) {
            this._listeners = new ArrayList<DataModelListener>();
        }
        this._listeners.add(listener);
    }

    public DataModelListener[] getDataModelListeners() {
        if (this._listeners == null) {
            return new DataModelListener[0];
        }
        return this._listeners.toArray(new DataModelListener[this._listeners.size()]);
    }

    public abstract int getRowCount();

    public abstract E getRowData();

    public abstract int getRowIndex();

    public abstract Object getWrappedData();

    public abstract boolean isRowAvailable();

    @Override
    public Iterator<E> iterator() {
        return new DataModelIterator();
    }

    public void removeDataModelListener(DataModelListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    public abstract void setRowIndex(int var1);

    public abstract void setWrappedData(Object var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataModelIterator
    implements Iterator<E> {
        private int nextRowIndex = 0;

        private DataModelIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.nextRowIndex < DataModel.this.getRowCount();
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                DataModel.this.setRowIndex(this.nextRowIndex);
                ++this.nextRowIndex;
                if (DataModel.this.isRowAvailable()) {
                    return DataModel.this.getRowData();
                }
                --this.nextRowIndex;
            }
            throw new NoSuchElementException("Couldn't find any element in DataModel at index " + this.nextRowIndex);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

