/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.client;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.ejb3.client.ClientEJBHandler;
import org.jboss.ejb3.client.ClientJavaEEComponent;
import org.jboss.ejb3.client.ClientResourceHandler;
import org.jboss.ejb3.client.NoopDependencyPolicy;
import org.jboss.ejb3.client.injection.ClientPersistenceUnitHandler;
import org.jboss.ejb3.javaee.JavaEEComponent;
import org.jboss.injection.DependsHandler;
import org.jboss.injection.EncInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.Injector;
import org.jboss.injection.WebServiceRefHandler;
import org.jboss.logging.Logger;
import org.jboss.metadata.client.jboss.JBossClientMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.util.NotImplementedException;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientContainer
implements InjectionContainer {
    private static final Logger log = Logger.getLogger(ClientContainer.class);
    private static final String VERSION = "$Revision: 81053 $";
    private static ThreadLocal<Properties> clientJndiEnv = new ThreadLocal();
    private Class<?> mainClass;
    private JBossClientMetaData xml;
    private String applicationClientName;
    private List<Injector> injectors = new ArrayList<Injector>();
    private Context enc;
    private DependencyPolicy dependsPolicy;
    private List<Method> postConstructs = new ArrayList<Method>();

    public static Properties getJndiEnv() {
        return clientJndiEnv.get();
    }

    public ClientContainer(JBossClientMetaData xml, Class<?> mainClass, String applicationClientName) throws Exception {
        this(xml, mainClass, applicationClientName, null);
    }

    public ClientContainer(JBossClientMetaData xml, Class<?> mainClass, String applicationClientName, Properties jndiEnv) throws Exception {
        log.info((Object)"ClientContainer(version=$Revision: 81053 $)");
        log.info((Object)("DependencyPolicy.CS: " + DependencyPolicy.class.getProtectionDomain().getCodeSource()));
        log.info((Object)("ClientContainer.CS: " + this.getClass().getProtectionDomain().getCodeSource()));
        ClassLoader mainClassLoader = mainClass.getClassLoader();
        log.info((Object)("mainClass.ClassLoader: " + mainClassLoader));
        clientJndiEnv.set(jndiEnv);
        this.xml = xml;
        this.mainClass = mainClass;
        this.applicationClientName = applicationClientName;
        ClientJavaEEComponent client = new ClientJavaEEComponent(applicationClientName);
        this.dependsPolicy = new NoopDependencyPolicy((JavaEEComponent)client);
        URL jndiPropertiesURL = mainClassLoader.getResource("jndi.properties");
        log.info((Object)("mainClassLoader jndi.properties: " + jndiPropertiesURL));
        InitialContext ctx = InitialContextFactory.getInitialContext((Hashtable)jndiEnv);
        this.enc = (Context)ctx.lookup(applicationClientName);
        StringBuffer encInfo = new StringBuffer("Client ENC(" + applicationClientName + "):\n");
        ClientContainer.list(this.enc, "", encInfo, true);
        log.info((Object)encInfo.toString());
        this.processMetadata(null);
        for (Injector injector : this.injectors) {
            log.debug((Object)("injector: " + injector));
            injector.inject((Object)null);
        }
        this.postConstruct();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass, Class<?> clazz) {
        return clazz.getAnnotation(annotationClass);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass, Class<?> clazz, Method method) {
        return method.getAnnotation(annotationClass);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass, Method method) {
        return method.getAnnotation(annotationClass);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass, Class<?> clazz, Field field) {
        return field.getAnnotation(annotationClass);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass, Field field) {
        return field.getAnnotation(annotationClass);
    }

    public ClassLoader getClassloader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public DependencyPolicy getDependencyPolicy() {
        return this.dependsPolicy;
    }

    public String getDeploymentDescriptorType() {
        return "application-client.xml";
    }

    public String getEjbJndiName(Class businessInterface) throws NameNotFoundException {
        throw new RuntimeException("NYI");
    }

    public String getEjbJndiName(String link, Class<?> businessInterface) {
        throw new NotImplementedException();
    }

    public Context getEnc() {
        return this.enc;
    }

    public Map<String, Map<AccessibleObject, Injector>> getEncInjections() {
        throw new IllegalStateException("ENC setup happens on the server");
    }

    public Map<String, EncInjector> getEncInjectors() {
        throw new IllegalStateException("ENC setup happens on the server");
    }

    public RemoteEnvironment getEnvironmentRefGroup() {
        return this.xml;
    }

    public String getIdentifier() {
        return this.applicationClientName;
    }

    public List<Injector> getInjectors() {
        return this.injectors;
    }

    public Class<?> getMainClass() {
        return this.mainClass;
    }

    public boolean hasJNDIBinding(String jndiName) {
        return false;
    }

    public void invokeMain(String[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class[] parameterTypes = new Class[]{args.getClass()};
        Method method = this.mainClass.getDeclaredMethod("main", parameterTypes);
        try {
            log.info((Object)("Invoking main: " + method));
            method.invoke(null, new Object[]{args});
            log.info((Object)"Successfully invoked main");
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error((Object)"Invocation of client main failed", e);
        }
    }

    private void postConstruct() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        log.info((Object)("postConstructs = " + this.postConstructs));
        for (Method method : this.postConstructs) {
            method.setAccessible(true);
            Object instance = Modifier.isStatic(method.getModifiers()) ? null : method.getDeclaringClass().newInstance();
            Object[] args = null;
            method.invoke(instance, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMetadata(DependencyPolicy dependencyPolicy) throws Exception {
        log.debug((Object)"processMetadata");
        this.processPostConstructs();
        ArrayList<Object> handlers = new ArrayList<Object>();
        handlers.add((Object)new ClientEJBHandler());
        handlers.add(new DependsHandler());
        handlers.add(new ClientPersistenceUnitHandler());
        handlers.add(new ClientResourceHandler(this.mainClass));
        handlers.add(new WebServiceRefHandler());
        for (InjectionHandler injectionHandler : handlers) {
            injectionHandler.loadXml((RemoteEnvironment)this.xml, (InjectionContainer)this);
        }
    }

    private void processPostConstructs() throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        LifecycleCallbacksMetaData callbacks = this.xml.getPostConstructs();
        if (callbacks == null || callbacks.isEmpty()) {
            return;
        }
        List methods = callbacks.getOrderedCallbacks(this.mainClass);
        this.postConstructs.addAll(methods);
    }

    public Container resolveEjbContainer(String link, Class businessIntf) {
        log.warn((Object)("resolveEjbContainer(" + link + ", " + businessIntf + ") not implemented"));
        return null;
    }

    public Container resolveEjbContainer(Class businessIntf) throws NameNotFoundException {
        return null;
    }

    public String resolveMessageDestination(String link) {
        return null;
    }

    public VirtualFile getRootFile() {
        throw new NotImplementedException();
    }

    private static void list(Context ctx, String indent, StringBuffer buffer, boolean verbose) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            NamingEnumeration<NameClassPair> ne = ctx.list("");
            while (ne.hasMore()) {
                Class<?> c;
                boolean isProxy;
                boolean isLinkRef;
                boolean recursive;
                String className;
                String name;
                NameClassPair pair;
                block21: {
                    pair = ne.next();
                    name = pair.getName();
                    className = pair.getClassName();
                    recursive = false;
                    isLinkRef = false;
                    isProxy = false;
                    c = null;
                    try {
                        c = loader.loadClass(className);
                        if (Context.class.isAssignableFrom(c)) {
                            recursive = true;
                        }
                        if (LinkRef.class.isAssignableFrom(c)) {
                            isLinkRef = true;
                        }
                        isProxy = Proxy.isProxyClass(c);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (!className.startsWith("$Proxy")) break block21;
                        isProxy = true;
                        try {
                            Object p = ctx.lookup(name);
                            c = p.getClass();
                        }
                        catch (NamingException e) {
                            String msg;
                            Throwable t = e.getRootCause();
                            if (!(t instanceof ClassNotFoundException) || (msg = t.getMessage()) == null) break block21;
                            className = msg;
                        }
                    }
                }
                buffer.append(indent + " +- " + name);
                if (isLinkRef) {
                    try {
                        Object obj = ctx.lookupLink(name);
                        LinkRef link = (LinkRef)obj;
                        buffer.append("[link -> ");
                        buffer.append(link.getLinkName());
                        buffer.append(']');
                    }
                    catch (Throwable t) {
                        buffer.append("invalid]");
                    }
                }
                if (isProxy) {
                    buffer.append(" (proxy: " + pair.getClassName());
                    if (c != null) {
                        Class<?>[] ifaces = c.getInterfaces();
                        buffer.append(" implements ");
                        for (int i = 0; i < ifaces.length; ++i) {
                            buffer.append(ifaces[i]);
                            buffer.append(',');
                        }
                        buffer.setCharAt(buffer.length() - 1, ')');
                    } else {
                        buffer.append(" implements " + className + ")");
                    }
                } else if (verbose) {
                    buffer.append(" (class: " + pair.getClassName() + ")");
                }
                buffer.append('\n');
                if (!recursive) continue;
                try {
                    Object value = ctx.lookup(name);
                    if (value instanceof Context) {
                        Context subctx = (Context)value;
                        ClientContainer.list(subctx, indent + " |  ", buffer, verbose);
                        continue;
                    }
                    buffer.append(indent + " |   NonContext: " + value);
                    buffer.append('\n');
                }
                catch (Throwable t) {
                    buffer.append("Failed to lookup: " + name + ", errmsg=" + t.getMessage());
                    buffer.append('\n');
                }
            }
            ne.close();
        }
        catch (NamingException ne) {
            buffer.append("error while listing context " + ctx.toString() + ": " + ne.toString(true));
            ClientContainer.formatException(buffer, ne);
        }
    }

    private static void formatException(StringBuffer buffer, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        buffer.append("<pre>\n");
        t.printStackTrace(pw);
        buffer.append(sw.toString());
        buffer.append("</pre>\n");
    }
}

