/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.test.idetesting;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.DeploymentGroup;
import org.jboss.embedded.adapters.JMXKernel;
import org.jboss.embedded.test.ejb.Customer;
import org.jboss.embedded.test.ejb.DAO;

public class EjbTestCase
extends TestCase {
    public EjbTestCase() {
        super("BootstrapTestCase");
    }

    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(EjbTestCase.class);
        TestSetup wrapper = new TestSetup((Test)suite){

            protected void setUp() {
                if (Bootstrap.getInstance().isStarted()) {
                    return;
                }
                try {
                    Bootstrap.getInstance().bootstrap();
                }
                catch (Exception error) {
                    throw new RuntimeException("Failed to bootstrap", error);
                }
            }

            protected void tearDown() {
            }
        };
        return wrapper;
    }

    private static void outputJNDI() throws InstanceNotFoundException, MBeanException, ReflectionException, MalformedObjectNameException {
        MBeanServer server = EjbTestCase.getMBeanServer();
        String xml = (String)server.invoke(new ObjectName("jboss:service=JNDIView"), "listXML", null, null);
        System.out.println(xml);
    }

    private static MBeanServer getMBeanServer() {
        JMXKernel jmxKernel = (JMXKernel)Bootstrap.getInstance().getKernel().getRegistry().getEntry((Object)"JMXKernel").getTarget();
        MBeanServer server = jmxKernel.getMbeanServer();
        return server;
    }

    public void testSimpleEjb() throws Exception {
        DeploymentGroup group = Bootstrap.getInstance().createDeploymentGroup();
        group.addClasspath("ejb-test.jar");
        group.process();
        EjbTestCase.outputJNDI();
        InitialContext ctx = new InitialContext();
        DAO dao = (DAO)ctx.lookup("DAOBean/local");
        Customer cust = dao.createCustomer("Bill");
        cust = dao.findCustomer("Bill");
        assert (cust != null);
        assert (cust.getName().equals("Bill"));
        group.undeploy();
    }

    public void testSimpleEjb2() throws Exception {
        DeploymentGroup group = Bootstrap.getInstance().createDeploymentGroup();
        group.addClasspath("ejb-test.jar");
        group.process();
        EjbTestCase.outputJNDI();
        InitialContext ctx = new InitialContext();
        DAO dao = (DAO)ctx.lookup("DAOBean/local");
        Customer cust = dao.createCustomer("Bill");
        cust = dao.findCustomer("Bill");
        assert (cust != null);
        assert (cust.getName().equals("Bill"));
        group.undeploy();
    }
}

