/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.test.jndibootstrap.unit;

import java.sql.Connection;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.adapters.JMXKernel;
import org.jboss.embedded.jndi.KernelInitializingContextFactory;

public class BootstrapTestCase
extends TestCase {
    public BootstrapTestCase() {
        super("BootstrapTestCase");
    }

    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(BootstrapTestCase.class);
        return suite;
    }

    public void testDefaultDS() throws Exception {
        System.setProperty("java.naming.factory.initial", KernelInitializingContextFactory.class.getName());
        System.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        InitialContext ctx = new InitialContext();
        this.outputJNDI();
        DataSource ds = (DataSource)ctx.lookup("java:/DefaultDS");
        Connection conn = ds.getConnection();
        conn.close();
    }

    public void testTwo() throws Exception {
        assert (KernelInitializingContextFactory.initialized);
    }

    private void outputJNDI() throws InstanceNotFoundException, MBeanException, ReflectionException, MalformedObjectNameException {
        MBeanServer server = BootstrapTestCase.getMBeanServer();
        String xml = (String)server.invoke(new ObjectName("jboss:service=JNDIView"), "listXML", null, null);
        System.out.println(xml);
    }

    private static MBeanServer getMBeanServer() {
        JMXKernel jmxKernel = (JMXKernel)Bootstrap.getInstance().getKernel().getRegistry().getEntry((Object)"JMXKernel").getTarget();
        MBeanServer server = jmxKernel.getMbeanServer();
        return server;
    }
}

