/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded;

import java.net.URL;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.DeploymentGroup;

public class ServletContextResourceScanner
implements ServletContextListener {
    private DeploymentGroup group = Bootstrap.getInstance().createDeploymentGroup();

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        String resources = servletContext.getInitParameter("jboss.embedded.resources");
        if (resources == null) {
            throw new RuntimeException("You must specify a resources parameter to the ServletContextResourceScanner");
        }
        StringTokenizer tokenizer = new StringTokenizer(resources, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            try {
                URL resource = servletContext.getResource(token);
                this.group.add(resource);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to add servlet resource to deloyer: " + token, e);
            }
        }
        try {
            this.group.process();
        }
        catch (DeploymentException e) {
            throw new RuntimeException("Failed to deploy servlet resources: " + resources, e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            this.group.undeploy();
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }
}

