/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.adapters;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.Properties;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.embedded.adapters.JMXClassLoader;
import org.jboss.embedded.adapters.JMXKernelMBean;
import org.jboss.embedded.adapters.ServerConfig;
import org.jboss.kernel.Kernel;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.system.ServiceController;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.deployers.ServiceDeployer;
import org.jboss.system.server.ServerConfigImpl;
import org.jboss.system.server.ServerConfigImplMBean;
import org.jboss.system.server.ServerImplMBean;
import org.jboss.system.server.jmx.LazyMBeanServer;
import org.jboss.util.JBossObject;

public class JMXKernel
extends JBossObject
implements JMXKernelMBean,
NotificationEmitter {
    private MBeanServer mbeanServer;
    private ServiceController controller;
    private Kernel kernel;
    private ServerConfig serverConfig;
    private NotificationBroadcasterSupport broadcasterSupport = new NotificationBroadcasterSupport();
    private boolean started;

    public ServiceControllerMBean getServiceController() {
        return this.controller;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    private MBeanServer createMBeanServer(String domain) throws Exception {
        MBeanServer server;
        String builder = System.getProperty("javax.management.builder.initial", "org.jboss.mx.server.MBeanServerBuilderImpl");
        System.setProperty("javax.management.builder.initial", builder);
        if (this.serverConfig.getPlatformMBeanServer()) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = cl.loadClass("java.lang.management.ManagementFactory");
            Class<?>[] sig = null;
            Method method = clazz.getMethod("getPlatformMBeanServer", sig);
            Object[] args = null;
            server = (MBeanServer)method.invoke(null, args);
            MBeanServerLocator.setJBoss((MBeanServer)server);
            server = LazyMBeanServer.resetToJBossServer((MBeanServer)server);
        } else {
            server = MBeanServerFactory.createMBeanServer(domain);
        }
        this.log.debug((Object)("Created MBeanServer: " + server));
        return server;
    }

    public static void setupUrlHandlers() {
        String pkgs = System.getProperty("java.protocol.handler.pkgs");
        if (pkgs == null || pkgs.trim().length() == 0) {
            pkgs = "org.jboss.net.protocol";
            System.setProperty("java.protocol.handler.pkgs", pkgs);
        } else if (!pkgs.contains("org.jboss.net.protocol")) {
            pkgs = pkgs + "|org.jboss.net.protocol";
            System.setProperty("java.protocol.handler.pkgs", pkgs);
        }
    }

    public void start() throws Exception {
        JMXKernel.setupUrlHandlers();
        this.mbeanServer = this.createMBeanServer("jboss");
        MBeanServerLocator.setJBoss((MBeanServer)this.mbeanServer);
        this.mbeanServer.registerMBean(new JMXClassLoader(Thread.currentThread().getContextClassLoader()), ServiceDeployer.DEFAULT_CLASSLOADER_OBJECT_NAME);
        this.controller = new ServiceController();
        this.controller.setKernel(this.kernel);
        this.controller.setMBeanServer(this.mbeanServer);
        this.mbeanServer.registerMBean(this.controller, new ObjectName("jboss.system:service=ServiceController"));
        this.mbeanServer.registerMBean(this, ServerImplMBean.OBJECT_NAME);
        this.mbeanServer.registerMBean(new ServerConfigImpl((org.jboss.bootstrap.spi.ServerConfig)this.serverConfig), ServerConfigImplMBean.OBJECT_NAME);
        this.started = true;
    }

    public void stop() throws IllegalStateException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"stop caller:", new Throwable("Here"));
        }
        if (!this.started) {
            throw new IllegalStateException("Server not started");
        }
        this.log.debug((Object)"Shutting down all services");
        this.shutdownServices();
        this.removeMBeans();
    }

    protected void shutdownServices() {
        try {
            this.controller.shutdown();
        }
        catch (Exception e) {
            Throwable t = JMXExceptionDecoder.decode((Throwable)e);
            this.log.error((Object)"Failed to shutdown services", t);
        }
    }

    protected void removeMBeans() {
        try {
            this.mbeanServer.unregisterMBean(ServiceControllerMBean.OBJECT_NAME);
        }
        catch (Exception e) {
            Throwable t = JMXExceptionDecoder.decode((Throwable)e);
            this.log.error((Object)"Failed to unregister mbeans", t);
        }
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.broadcasterSupport.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcasterSupport.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.broadcasterSupport.removeNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.broadcasterSupport.getNotificationInfo();
    }

    public void sendNotification(Notification notification) {
        this.broadcasterSupport.sendNotification(notification);
    }

    public void runGarbageCollector() {
    }

    public void runFinalization() {
    }

    public void traceMethodCalls(Boolean flag) {
    }

    public void traceInstructions(Boolean flag) {
    }

    public Date getStartDate() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    public String getVersionName() {
        return null;
    }

    public String getBuildNumber() {
        return null;
    }

    public String getBuildJVM() {
        return null;
    }

    public String getBuildOS() {
        return null;
    }

    public String getBuildID() {
        return null;
    }

    public String getBuildDate() {
        return null;
    }

    public boolean isInShutdown() {
        return false;
    }

    public void init(Properties props) throws IllegalStateException, Exception {
    }

    public ServerConfig getConfig() throws IllegalStateException {
        return null;
    }

    public boolean isStarted() {
        return false;
    }

    public void shutdown() throws IllegalStateException {
    }

    public void exit(int exitcode) {
    }

    public void exit() {
    }

    public void halt(int exitcode) {
    }

    public void halt() {
    }

    public String getSpecificationVersion() {
        return this.serverConfig.getSpecificationVersion();
    }

    public String getVersionNumber() {
        return "";
    }
}

