/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import junit.framework.TestCase;

public class MBeanInfoTEST
extends TestCase {
    public MBeanInfoTEST(String s) {
        super(s);
    }

    public void testMBeanInfo() throws Exception {
        MBeanInfo info = new MBeanInfo("name", "description", null, null, null, null);
        MBeanInfoTEST.assertEquals((String)"name", (String)info.getClassName());
        MBeanInfoTEST.assertEquals((String)"description", (String)info.getDescription());
        MBeanInfoTEST.assertEquals((int)0, (int)info.getAttributes().length);
        MBeanInfoTEST.assertEquals((int)0, (int)info.getConstructors().length);
        MBeanInfoTEST.assertEquals((int)0, (int)info.getNotifications().length);
        MBeanInfoTEST.assertEquals((int)0, (int)info.getOperations().length);
        info = new MBeanInfo("name", "description", new MBeanAttributeInfo[0], new MBeanConstructorInfo[0], new MBeanOperationInfo[0], new MBeanNotificationInfo[0]);
        MBeanInfoTEST.assertEquals((String)"name", (String)info.getClassName());
        MBeanInfoTEST.assertEquals((String)"description", (String)info.getDescription());
        MBeanInfoTEST.assertEquals((int)0, (int)info.getAttributes().length);
        MBeanInfoTEST.assertEquals((int)0, (int)info.getConstructors().length);
        MBeanInfoTEST.assertEquals((int)0, (int)info.getNotifications().length);
        MBeanInfoTEST.assertEquals((int)0, (int)info.getOperations().length);
        MBeanParameterInfo[] parms = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "type", "description")};
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("name", "type", "description", true, true, false)};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{new MBeanConstructorInfo("name", "description", parms)};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{new MBeanOperationInfo("name", "description", parms, "type", 2)};
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"type1", "type"}, "name", "description")};
        info = new MBeanInfo("name", "description", attributes, constructors, operations, notifications);
        MBeanInfoTEST.assertEquals((String)"name", (String)info.getClassName());
        MBeanInfoTEST.assertEquals((String)"description", (String)info.getDescription());
        MBeanInfoTEST.assertEquals((int)1, (int)info.getAttributes().length);
        MBeanInfoTEST.assertEquals((int)1, (int)info.getConstructors().length);
        MBeanInfoTEST.assertEquals((int)1, (int)info.getNotifications().length);
        MBeanInfoTEST.assertEquals((int)1, (int)info.getOperations().length);
    }

    public void testEquals() throws Exception {
        MBeanParameterInfo[] parms = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "type", "description")};
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("name", "type", "description", true, true, false)};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{new MBeanConstructorInfo("name", "description", parms)};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{new MBeanOperationInfo("name", "description", parms, "type", 2)};
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"type1", "type"}, "name", "description")};
        MBeanInfo info = new MBeanInfo("name", "description", attributes, constructors, operations, notifications);
        MBeanInfoTEST.assertTrue((String)"Null is not equal to any instance", (!info.equals(null) ? 1 : 0) != 0);
        MBeanInfoTEST.assertTrue((String)"Instance is only equal another MBeanInfo instance", (!info.equals(new Object()) ? 1 : 0) != 0);
        MBeanInfoTEST.assertTrue((String)"Instance should equal itself", (boolean)info.equals(info));
        MBeanInfo info2 = new MBeanInfo("name", "description", attributes, constructors, operations, notifications);
        MBeanInfoTEST.assertTrue((String)"Instances with same values should be equal", (boolean)info.equals(info2));
        MBeanInfoTEST.assertTrue((String)"Instances with same values should be equal", (boolean)info2.equals(info));
        info2 = new MBeanInfo("name2", "description", attributes, constructors, operations, notifications);
        MBeanInfoTEST.assertTrue((String)"Instances with different class names are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanInfoTEST.assertTrue((String)"Instances with different class names are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new MBeanInfo("name", "description2", attributes, constructors, operations, notifications);
        MBeanInfoTEST.assertTrue((String)"Instances with different descriptions are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanInfoTEST.assertTrue((String)"Instances with different descriptions are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        MBeanAttributeInfo[] attributes2 = new MBeanAttributeInfo[]{new MBeanAttributeInfo("name2", "type", "description", true, true, false)};
        info2 = new MBeanInfo("name", "description", attributes2, constructors, operations, notifications);
        MBeanInfoTEST.assertTrue((String)"Instances with different attributes are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanInfoTEST.assertTrue((String)"Instances with different attributes are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        attributes2 = new MBeanAttributeInfo[]{new MBeanAttributeInfo("name2", "type", "description", true, true, false), new MBeanAttributeInfo("name3", "type", "description", true, true, false)};
        info2 = new MBeanInfo("name", "description", attributes2, constructors, operations, notifications);
        MBeanInfoTEST.assertTrue((String)"Instances with different numbers of attributes are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanInfoTEST.assertTrue((String)"Instances with different numbers of attributes are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new MBeanInfo("name", "description", null, constructors, operations, notifications);
        MBeanInfoTEST.assertTrue((String)"Instances with and without attributes are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanInfoTEST.assertTrue((String)"Instances with and without attributes are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        MBeanConstructorInfo[] constructors2 = new MBeanConstructorInfo[]{new MBeanConstructorInfo("name2", "description", parms)};
        info2 = new MBeanInfo("name", "description", attributes, constructors2, operations, notifications);
        MBeanInfoTEST.assertTrue((String)"Instances with different constructors are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanInfoTEST.assertTrue((String)"Instances with different constructors are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        constructors2 = new MBeanConstructorInfo[]{new MBeanConstructorInfo("name2", "description", parms), new MBeanConstructorInfo("name3", "description", parms)};
        info2 = new MBeanInfo("name", "description", attributes, constructors2, operations, notifications);
        MBeanInfoTEST.assertTrue((String)"Instances with different numbers of constructors are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanInfoTEST.assertTrue((String)"Instances with different numbers of constructors are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new MBeanInfo("name", "description", attributes, null, operations, notifications);
        MBeanInfoTEST.assertTrue((String)"Instances with and without constructors are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanInfoTEST.assertTrue((String)"Instances with and without constructors are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        MBeanOperationInfo[] operations2 = new MBeanOperationInfo[]{new MBeanOperationInfo("name2", "description", parms, "type", 2)};
        info2 = new MBeanInfo("name", "description", attributes, constructors, operations2, notifications);
        MBeanInfoTEST.assertTrue((String)"Instances with different operations are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanInfoTEST.assertTrue((String)"Instances with different operations are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        operations2 = new MBeanOperationInfo[]{new MBeanOperationInfo("name2", "description", parms, "type", 2), new MBeanOperationInfo("name3", "description", parms, "type", 2)};
        info2 = new MBeanInfo("name", "description", attributes, constructors, operations2, notifications);
        MBeanInfoTEST.assertTrue((String)"Instances with different numbers of operations are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanInfoTEST.assertTrue((String)"Instances with different numbers of operations are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new MBeanInfo("name", "description", attributes, constructors, null, notifications);
        MBeanInfoTEST.assertTrue((String)"Instances with and without operations are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanInfoTEST.assertTrue((String)"Instances with and without operations are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        MBeanNotificationInfo[] notifications2 = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"type", "type"}, "name2", "description")};
        info2 = new MBeanInfo("name", "description", attributes, constructors, operations, notifications2);
        MBeanInfoTEST.assertTrue((String)"Instances with different notifications are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanInfoTEST.assertTrue((String)"Instances with different notifications are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        notifications2 = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"type", "type"}, "name2", "description"), new MBeanNotificationInfo(new String[]{"type", "type"}, "name3", "description")};
        info2 = new MBeanInfo("name", "description", attributes, constructors, operations, notifications2);
        MBeanInfoTEST.assertTrue((String)"Instances with different numbers of notifications are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanInfoTEST.assertTrue((String)"Instances with different numbers of notifications are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new MBeanInfo("name", "description", attributes, constructors, operations, null);
        MBeanInfoTEST.assertTrue((String)"Instances with and without notifications are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanInfoTEST.assertTrue((String)"Instances with and without notifications are not equal", (!info2.equals(info) ? 1 : 0) != 0);
    }

    public void testHashCode() throws Exception {
        MBeanParameterInfo[] parms = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "type", "description")};
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("name", "type", "description", true, true, false)};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{new MBeanConstructorInfo("name", "description", parms)};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{new MBeanOperationInfo("name", "description", parms, "type", 2)};
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"type1", "type"}, "name", "description")};
        MBeanInfo info1 = new MBeanInfo("name", "description", attributes, constructors, operations, notifications);
        MBeanInfo info2 = new MBeanInfo("name", "description", attributes, constructors, operations, notifications);
        MBeanInfoTEST.assertTrue((String)"Different instances with the same hashcode are equal", (info1.hashCode() == info2.hashCode() ? 1 : 0) != 0);
    }

    public void testSerialization() throws Exception {
        MBeanParameterInfo[] parms = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "type", "description")};
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("name", "type", "description", true, true, false)};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{new MBeanConstructorInfo("name", "description", parms)};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{new MBeanOperationInfo("name", "description", parms, "type", 2)};
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"type1", "type"}, "name", "description")};
        MBeanInfo info = new MBeanInfo("name", "description", attributes, constructors, operations, notifications);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(info);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        MBeanInfo result = (MBeanInfo)ois.readObject();
        MBeanInfoTEST.assertEquals((String)info.getClassName(), (String)result.getClassName());
        MBeanInfoTEST.assertEquals(Arrays.asList(info.getAttributes()), Arrays.asList(result.getAttributes()));
        MBeanInfoTEST.assertEquals(Arrays.asList(info.getConstructors()), Arrays.asList(result.getConstructors()));
        MBeanInfoTEST.assertEquals(Arrays.asList(info.getOperations()), Arrays.asList(result.getOperations()));
        MBeanNotificationInfo origNotification = info.getNotifications()[0];
        MBeanNotificationInfo resultNotification = result.getNotifications()[0];
        MBeanInfoTEST.assertEquals((String)origNotification.getName(), (String)resultNotification.getName());
        MBeanInfoTEST.assertEquals((String)origNotification.getDescription(), (String)resultNotification.getDescription());
        MBeanInfoTEST.assertEquals(Arrays.asList(origNotification.getNotifTypes()), Arrays.asList(resultNotification.getNotifTypes()));
    }
}

