/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import javax.management.MBeanNotificationInfo;
import junit.framework.TestCase;

public class MBeanNotificationInfoTEST
extends TestCase {
    private String[] types1 = new String[]{"type1", "type2"};
    private String[] types2 = new String[]{"typex", "type2"};

    public MBeanNotificationInfoTEST(String s) {
        super(s);
    }

    public void testMBeanNotificationInfo() throws Exception {
        MBeanNotificationInfo info = new MBeanNotificationInfo(this.types1, "name", "description");
        MBeanNotificationInfoTEST.assertEquals((String)"name", (String)info.getName());
        MBeanNotificationInfoTEST.assertEquals((String)"description", (String)info.getDescription());
        MBeanNotificationInfoTEST.assertEquals(Arrays.asList(this.types1), Arrays.asList(info.getNotifTypes()));
    }

    public void testHashCode() throws Exception {
        MBeanNotificationInfo info1 = new MBeanNotificationInfo(this.types1, "name", "description");
        MBeanNotificationInfo info2 = new MBeanNotificationInfo(this.types1, "name", "description");
        MBeanNotificationInfoTEST.assertTrue((String)"Different instances with the same hashcode are equal", (info1.hashCode() == info2.hashCode() ? 1 : 0) != 0);
    }

    public void testEquals() throws Exception {
        MBeanNotificationInfo info = new MBeanNotificationInfo(this.types1, "name", "description");
        MBeanNotificationInfoTEST.assertTrue((String)"Null should not be equal", (!info.equals(null) ? 1 : 0) != 0);
        MBeanNotificationInfoTEST.assertTrue((String)"Only MBeanNotificationInfo should be equal", (!info.equals(new Object()) ? 1 : 0) != 0);
        MBeanNotificationInfo info2 = new MBeanNotificationInfo(this.types1, "name", "description");
        MBeanNotificationInfoTEST.assertTrue((String)"Different instances of the same data are equal", (boolean)info.equals(info2));
        MBeanNotificationInfoTEST.assertTrue((String)"Different instances of the same data are equal", (boolean)info2.equals(info));
        info2 = new MBeanNotificationInfo(this.types1, "name", "description2");
        MBeanNotificationInfoTEST.assertTrue((String)"Different instances with different descriptions are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanNotificationInfoTEST.assertTrue((String)"Different instances with different descritpions are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new MBeanNotificationInfo(this.types1, "name2", "description");
        MBeanNotificationInfoTEST.assertTrue((String)"Instances with different names are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanNotificationInfoTEST.assertTrue((String)"Instances with different names are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new MBeanNotificationInfo(this.types2, "name", "description");
        MBeanNotificationInfoTEST.assertTrue((String)"Instances with different types are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanNotificationInfoTEST.assertTrue((String)"Instances with different types are not equal", (!info2.equals(info) ? 1 : 0) != 0);
    }

    public void testSerialization() throws Exception {
        MBeanNotificationInfo info = new MBeanNotificationInfo(this.types1, "name", "description");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(info);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object result = ois.readObject();
        MBeanNotificationInfoTEST.assertEquals((Object)info, (Object)result);
    }
}

