/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.modelmbean;

import javax.management.Descriptor;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;
import junit.framework.TestCase;
import org.jboss.test.jmx.compliance.modelmbean.support.Resource;

public class ModelMBeanTEST
extends TestCase {
    public ModelMBeanTEST(String s) {
        super(s);
    }

    public void testRequiredModelMBeanConstructors() {
        try {
            new RequiredModelMBean();
        }
        catch (Throwable t) {
            t.printStackTrace();
            ModelMBeanTEST.fail((String)("Creating Required ModelMBean instance with default constructor failed: " + t.toString()));
        }
    }

    public void testRMMSetManagedResource() {
        try {
            RequiredModelMBean modelmbean = new RequiredModelMBean();
            Resource resource = new Resource();
            modelmbean.setManagedResource(resource, "ObjectReference");
        }
        catch (Throwable t) {
            t.printStackTrace();
            ModelMBeanTEST.fail((String)("Setting resource object with 'ObjectReference' type failed: " + t.toString()));
        }
    }

    public void testRMMSetManagedResourceAfterRegister() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        Resource resource = new Resource();
        RequiredModelMBean modelmbean = new RequiredModelMBean();
        modelmbean.setModelMBeanInfo(this.getModelMBeanInfo());
        ObjectName name = new ObjectName("rmm:invocationTest=true");
        server.registerMBean(modelmbean, name);
        modelmbean.setManagedResource(resource, "ObjectReference");
        MBeanInfo info = server.getMBeanInfo(name);
        ModelMBeanTEST.assertTrue((String)"MBeanInfo != null", (info != null ? 1 : 0) != 0);
        Object[] args = new Object[]{};
        String[] sig = new String[]{};
        Boolean flag = (Boolean)server.invoke(name, "isActive", args, sig);
        ModelMBeanTEST.assertTrue((String)"isActive", (boolean)flag);
    }

    public void testRMMSetManagedResourceAfterRegisterViaServer() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        Resource resource = new Resource();
        RequiredModelMBean modelmbean = new RequiredModelMBean();
        modelmbean.setModelMBeanInfo(this.getModelMBeanInfo());
        ObjectName name = new ObjectName("rmm:invocationTest=true");
        server.registerMBean(modelmbean, name);
        Object[] args = new Object[]{resource, "ObjectReference"};
        String[] sig = new String[]{"java.lang.Object", "java.lang.String"};
        server.invoke(name, "setManagedResource", args, sig);
        MBeanInfo info = server.getMBeanInfo(name);
        ModelMBeanTEST.assertTrue((String)"MBeanInfo != null", (info != null ? 1 : 0) != 0);
        args = new Object[]{};
        sig = new String[]{};
        Boolean flag = (Boolean)server.invoke(name, "isActive", args, sig);
        ModelMBeanTEST.assertTrue((String)"isActive", (boolean)flag);
    }

    public void testCreatedRMMSetManagedResourceAfterRegisterViaServer() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName name = new ObjectName("rmm:invocationTest=true");
        ModelMBeanInfo info = this.getModelMBeanInfo();
        Object[] ctorArgs = new Object[]{info};
        String[] ctorSig = new String[]{"javax.management.modelmbean.ModelMBeanInfo"};
        server.createMBean("javax.management.modelmbean.RequiredModelMBean", name, ctorArgs, ctorSig);
        Resource resource = new Resource();
        Object[] args = new Object[]{resource, "ObjectReference"};
        String[] sig = new String[]{"java.lang.Object", "java.lang.String"};
        server.invoke(name, "setManagedResource", args, sig);
        info = (ModelMBeanInfo)((Object)server.getMBeanInfo(name));
        ModelMBeanTEST.assertTrue((String)"MBeanInfo != null", (info != null ? 1 : 0) != 0);
        args = new Object[]{};
        sig = new String[]{};
        Boolean flag = (Boolean)server.invoke(name, "isActive", args, sig);
        ModelMBeanTEST.assertTrue((String)"isActive", (boolean)flag);
    }

    public void testCreatedRMMSetManagedResourceAfterRegisterViaServerListener() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName name = new ObjectName("rmm:invocationTest=true");
        ModelMBeanInfo info = this.getModelMBeanInfo();
        Object[] ctorArgs = new Object[]{info};
        String[] ctorSig = new String[]{"javax.management.modelmbean.ModelMBeanInfo"};
        server.createMBean("javax.management.modelmbean.RequiredModelMBean", name, ctorArgs, ctorSig);
        Resource resource = new Resource();
        Object[] args = new Object[]{resource, "objectReference"};
        String[] sig = new String[]{"java.lang.Object", "java.lang.String"};
        server.invoke(name, "setManagedResource", args, sig);
        RMMListener listener = new RMMListener();
        server.addNotificationListener(name, listener, null, null);
    }

    public void testRMMSetModelMBeanInfo() throws Exception {
        RequiredModelMBean modelmbean = new RequiredModelMBean();
        modelmbean.setModelMBeanInfo(this.getModelMBeanInfo());
    }

    public void testRMMInvocation() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        Resource resource = new Resource();
        RequiredModelMBean modelmbean = new RequiredModelMBean();
        modelmbean.setModelMBeanInfo(this.getModelMBeanInfo());
        modelmbean.setManagedResource(resource, "ObjectReference");
        ObjectName name = new ObjectName("rmm:invocationTest=true");
        server.registerMBean(modelmbean, name);
        MBeanInfo info = server.getMBeanInfo(name);
        ModelMBeanTEST.assertTrue((String)"MBeanInfo != null", (info != null ? 1 : 0) != 0);
        ModelMBeanTEST.assertTrue((boolean)((Boolean)server.invoke(name, "isActive", new Object[0], new String[0])));
    }

    public void testRMMDefault() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        Resource resource = new Resource();
        RequiredModelMBean modelmbean = new RequiredModelMBean();
        modelmbean.setManagedResource(resource, "ObjectReference");
        modelmbean.setModelMBeanInfo(this.getModelMBeanInfo());
        ObjectName name = new ObjectName("rmm:test=default");
        server.registerMBean(modelmbean, name);
        ModelMBeanTEST.assertTrue((String)"Should be the default room", (boolean)server.getAttribute(name, "Room").equals("D325"));
    }

    public ModelMBeanInfo getModelMBeanInfo() {
        boolean READABLE = true;
        boolean WRITABLE = true;
        boolean BOOLEAN = true;
        DescriptorSupport descr1 = new DescriptorSupport();
        descr1.setField("name", "Room");
        descr1.setField("descriptorType", "attribute");
        descr1.setField("displayName", "Room Number");
        descr1.setField("default", "D325");
        ModelMBeanAttributeInfo roomNameInfo = new ModelMBeanAttributeInfo("Room", String.class.getName(), "Room name or number.", true, true, false, descr1);
        DescriptorSupport descr2 = new DescriptorSupport();
        descr2.setField("name", "Active");
        descr2.setField("descriptorType", "attribute");
        descr2.setField("getMethod", "isActive");
        descr2.setField("currencyTimeLimit", "10");
        ModelMBeanAttributeInfo activeInfo = new ModelMBeanAttributeInfo("Active", Boolean.TYPE.getName(), "Printer state.", true, false, false, descr2);
        DescriptorSupport descr3 = new DescriptorSupport();
        descr3.setField("name", "isActive");
        descr3.setField("descriptorType", "operation");
        descr3.setField("role", "getter");
        ModelMBeanOperationInfo isActiveInfo = new ModelMBeanOperationInfo("isActive", "Checks if the printer is currently active.", null, Boolean.TYPE.getName(), 0, descr3);
        DescriptorSupport descr4 = new DescriptorSupport();
        descr4.setField("name", RequiredModelMBean.class.getName());
        descr4.setField("descriptorType", "MBean");
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(RequiredModelMBean.class.getName(), "Printer", new ModelMBeanAttributeInfo[]{roomNameInfo, activeInfo}, null, new ModelMBeanOperationInfo[]{isActiveInfo}, null, (Descriptor)descr4);
        return info;
    }

    static class RMMListener
    implements NotificationListener {
        RMMListener() {
        }

        public void handleNotification(Notification msg, Object handback) {
            System.out.println("handleNotification, msg=" + msg);
        }
    }
}

